/*
 *	init.js - initializing the skin, skin-specific utilities
 *	Author: Laza
 */

	/* 
	 *	Java imports
	 */

var JAFilter = Java.type("se.datadosen.jalbum.JAFilter"),
	Config = Java.type("se.datadosen.jalbum.Config"),
	Category = Java.type("se.datadosen.jalbum.Category"),
	Widgets = Java.type("se.datadosen.jalbum.Widgets"),
	JAlbumUtilities = Java.type("se.datadosen.jalbum.JAlbumUtilities"),
	DateRange = Java.type("se.datadosen.jalbum.DateRange"),
	FixedShapeFilter = Java.type("FixedShapeFilter"),
	ConstrainRatioFilter = Java.type(skin.toLowerCase().split(' ')[0] + ".ConstrainRatioFilter"),
	File = Java.type("java.io.File"),
	Long = Java.type("java.lang.Long"),
	SkinProperties = Java.type("se.datadosen.jalbum.SkinProperties"),
	MyJSONObject = Java.type("se.datadosen.util.MyJSONObject"),
	System = Java.type("java.lang.System"),
	IO = Java.type('se.datadosen.util.IO'),
	LinkFile = Java.type("se.datadosen.io.LinkFile"),
	Zip = Java.type(skin.toLowerCase().split(' ')[0] + ".Zip"),
	AtomicInteger = Java.type("java.util.concurrent.atomic.AtomicInteger"),
	JSONMaker = Java.type("se.datadosen.jalbum.JSONMaker");

	// No multiple index pages :: setting up before loading Util
	engine.setRows(0);
	
	// URL encoding, Write UTF-8 are madatory because the JSON database is always written in this format
	engine.setUrlEncode(true);
	//engine.setWriteUTF8(true);
	
	// Zip library
	var zip = new Zip(engine);
	engine.setUsing(zip);
	
	/* 
	 *	Global variables
	 */

	// Undefined
	UNDEF = 'undefined';
	
	time = (new Date()).getTime();					// time
	today = (time / 86400000) | 0;					// today: number of days since 1970-01-01
	
	skinVersion = new SkinProperties(skinDirectory).getProperty(SkinProperties.VERSION);
	
	lightStyle = 'Cardboard,Creme,Exhibition,Hemp,Leather Light,Retro,Ricepaper,Shine,Stonewall,Wallpaper,White,Wood light,Yellow'.indexOf(styleName) >= 0;
	
	// Fixing wrong Facebook App ID
	if (facebookAppId.indexOf('E') !== -1) {
		print('Facebook App ID is in wrong format, please check it in the Settings!');
		facebookAppId = facebookAppId.split('E')[0].replace(/\./g, '');
	}
	
	// Page protocol
	pageProtocol = basePath.startsWith('https://')? 'https:' : 'http:';
	
	// Debug mode? Don't use the minified javascript libraries.
	min = (typeof debugMode !== UNDEF && !!debugMode)? '' : '.min';
	
	// album description processed
	albumCaption = getProcessed(albumDescription);		
	
	// html formatted album info block 
	albumInfo = (function() {
			var s = '';
			
			if (typeof writer !== UNDEF) {
				s += '<div class="author"><span>' + getText('author') + '</span> '+ writer + '</div>';
			}
			
			if (typeof copyright !== UNDEF) {
				s += '<div class="copyright"><span>' + getText('copyright') + '</span> ' + copyright + '</div>';
			}
			
			if (typeof currentDate !== UNDEF && showModifiedDate) {
				s += '<div class="modifieddate"><span>' + getText('modified') + '</span> ' + dateFormatter(new JDate()) + '</div>';
			}
			
			if (typeof showImageCount !== UNDEF && showImageCount) {
				s += getCounts(rootFolder, true, 'div', 'counts');
			}
			
			return s;
		}());
	
	albumImageUrl = urlEncodeFix(basePath + folderImageFileName);
	albumThumbUrl = urlEncodeFix(basePath + folderThumbFileName);
		
	credits = getCredits();
	
	if (typeof customKeys !== UNDEF) {
		getCustomTexts(customKeys);
	}
	
	// Feature detection
	_useFacebook = !!shareFacebook;
	_useTopNavigation = topNavigationIncludeFolders || topNavigationIncludePages || topNavigationIncludeWebLocations;
	_useShop = false; //!!showShop && shopId;
	_useMap = showMapSection && !!googleApiKey;
	_useTagCloud = tagCloudSource !== 'none';
	_useSearchNew = searchNewSource !== 'none';
	_usePhotodata = !!showPhotoData && !!photoDataTemplate;
	_useRegions = !!showRegions;
	_useFotomoto = !!useFotomoto && fotomotoID;
	_useTagCloudBox = tagCloudSource !== 'none' && !!tagCloudFields;
	_useSearch = !!useSearch && !!searchFields;
	_anyVr = false;
	_storeAddedDate = searchNewReference === 'added' || newDaysRef === 'added';
	_storeTakenDate = searchNewReference === 'dateTaken' || newDaysRef === 'dateTaken';
	_storeModifiedDate = searchNewReference === 'fileModified' || newDaysRef === 'fileModified';
	_anyShares =
			shareFacebook || 
			shareTwitter || 
			sharePinterest ||
			shareLinkedin ||
			shareDigg || 
			shareReddit ||
			shareTumblr ||
			shareEmail ||
			shareLink;
			
	_titleCaptionTemplate = titleCaptionTemplate;
	_folderCaptionTemplate = folderCaptionTemplate;
	_useOriginalTime = 	thumbCaptionTemplate.indexOf('${originalTime}') >= 0 || 
						imageCaptionTemplate.indexOf('${originalTime}') >= 0;
	
	// Javascript variables compiled upfront
	jsGlobalVars = null;
	jsLightboxVars = null;
	jsCookiePolicyVars = null;

	// Background audio array
	backgroundMusicFolder = 'res';
	
	relPath = '';
	relPathEncoded = '';
	
	// Folder image :: this image is copied to the index file's folder with the given name, cropped to the given size
	// Can be used as splash image for example
	// GUI should contain a JTextField folderImageSize, otherwise uncomment this:
	folderThumbDims = (typeof folderThumbSize !== UNDEF)? folderThumbSize : '1024x768';
	folderImageDims = (heroType === 'fullWidth')? '1800x1200' : folderImageSize;
	folderImgDims = '800x' + folderImageSize.split('x')[1];
	
	extraMeta = {};
		
	_newImagesSource = '';
	
	if (!_useMap) {
		try {
			engine.getJSONMaker().setIncludeLocation(false);
		} catch (Throwable) {}
	}
	
	/* 
	 * 	New variables
	 *	All types
	 				fileLabel
	 				commentShort
	 				thumbCaption
	 				shop
	 				
	 *	Folders
	 				folderThumbPath
	 				altText
	 				folderModDate
	 				folderCounts
	 				epochDateRange
	 				
	 *  Displayable objects
	 				imageCaption
	 				mostphotos
	 				epochDate
	 				location
	 				
	 *	Images 
	 				photodata
	 				regions
	 
	 */
			
	var processFolder = function(folder) {
					 
				var	shopCount = new AtomicInteger(0),
					locationCount = new AtomicInteger(0),
					regionCount = new AtomicInteger(0),
					vrCount = new AtomicInteger(0),
					imageNum = new AtomicInteger(0),
					zipCount = new AtomicInteger(0),
					dateRange,
					storeAdded = _storeAddedDate,
					storeModified = _storeModifiedDate,
					storeTaken = _storeTakenDate,
					hasFolderImg;
					
				relPath = getRelPath(folder);
				relPathEncoded = encodeAsJava(relPath);
				
				//logger(Level.FINE, 'Processing folder "{0}"', relPath);
				updateStatus(getTextTemplate("preprocessingFolder", level? relPath : folder.getName()));
				
				if (!_newImagesSource) {
					var ao = folder.getChild('Newimages.htt');
					if (ao) {
						var nis = ao.getVars().get('newImagesSource');
						if (nis) {
							_newImagesSource = nis;
						}
					}
				}
				
				if (_newImagesSource) {
					if (_newImagesSource === 'added') {
						storeAdded = true;
					} else if (_newImagesSource ===  'dateTaken') {
						storeTaken = true;
					} else if (_newImagesSource === 'fileModified') {
						storeModified = true;
					}
				}
				
				// Processing folder image and thumbnail
				hasFolderImg = createFolderImage(folder, folderImageDims, folderThumbDims, folderImgDims, false, true, hiDpiThemeImage);
				
				// creating extra variables --> data1.json
				folder.getChildren().forEach(function(ao) { 
					// parallelStream() fails !!!
						
					var vars,
						meta,
						cat = ao.getCategory(),
						v,
						s,
						t,
						dates;
						
					if (ao.isIncluded() && 
						!(cat === Category.folder && ao.isHidden()) && 
						(vars = ao.getVars())) {
						
						// Extra fileLabel variable
						vars.put('fileLabel', vars.get('fileTitle') || vars.get('label').replace(/_/g, ' '));
						
						dates = {};
												
						// Folders and WebLocations
						
						if (cat === Category.folder || cat === Category.webLocation) {
														
							// Iconpath => SVG, folder thumb path
							if (s = vars.get('iconPath')) {
								s = s.replace('folder.png', defaultFolderIconName);
								vars.put('iconpath', s);
								vars.put('folderThumbPath', s.replace(/^\.\.\//, ''));
							} else {
								vars.put('folderThumbPath', createFolderThumb(ao, folderThumbSize, true)); 
							}
							
							// Folders only
							if (cat === Category.folder) {
								
								// Counts
								vars.put('counts', getCounts(ao, true, 'p'));
								
								dateRange = JAlbumUtilities.getDeepCameraDates(ao);
								
								// $folderModDate is for folder captions
								
								switch (folderDateSource) {
									case 'fileDate':
										vars.put('folderModDate', vars.get('fileDate'));
										break;
										
									case 'folderModDate':
										vars.put('folderModDate', getFormattedDate(deepLastModifiedObject(ao)));
										break;
										
									case 'lastCameraDate':
										if (dateRange.last) {
											vars.put('folderModDate', getFormattedDate(dateRange.last));
											break;
										}
										
									case 'cameraDateRange':
										if (dateRange.first && dateRange.last) {
											vars.put('folderModDate', getFormattedDateRange(dateRange.first + 0, dateRange.last + 0));
											break;
										}							
										
									default:
										vars.put('folderModDate', '');
								}
								
								// Added date
								if (storeAdded && (s = JAlbumUtilities.getDeepLastAdded(ao))) {
									dates.added = Long.valueOf(Math.floor(s / 1000));
								}
								
								// Taken date range
								if (storeTaken && dateRange.first && dateRange.last) {
									dates.dateRange = [ Long.valueOf(Math.floor(dateRange.first / 1000)), 
														Long.valueOf(Math.floor(dateRange.last / 1000)) ];
								}
								
								// Modified date
								if (storeModified && (s = JAlbumUtilities.deepLastModified(ao))) {
									dates.fileModified = Long.valueOf(Math.floor(s / 1000));
								}
								
							} else {
								// Counts
								if (vars.get('closeupPath').split('#').length < 2) {
									// Avoid search and tag search results, or direct image links
									vars.put('counts', getCounts(ao, true, 'p'));
								}
							}
							
							// Folder caption
							if (_folderCaptionTemplate && (s = processTemplate(ao, _folderCaptionTemplate, false))) {
								vars.put('thumbCaption', s);
							} else {
								vars.put('thumbCaption', '');
							}

						} else {
							
							// Pages and normal items
							
							// Comment
							s = vars.get('comment');
							
							// Short comment
							vars.put('commentShort', shorten(s, 160, true));
														
							if (cat === Category.webPage) {
								
								// Web page
								
								t = vars.get('title');
								
								// Page title, HTML tags removed
								vars.put('pageTitle', cleanup(stripHTML(t)));
								
								// Folder title: hero 
								vars.put('folderTitle', '<h1>' + t + '</h1>');
								
								// Top navigation
								vars.put('topNavigation', _useTopNavigation? getTree(rootFolder, topNavigationIncludeFolders, topNavigationIncludePages, topNavigationIncludeWebLocations) : '');
								
								// Page URL
								if (basePath) {
									vars.put('pageUrl', basePath + relPathEncoded + ao.getWebName());
								} else {
									vars.put('pageUrl', '');
								}
								
								// Up link
								vars.put('uplink', './' + indexName);
								vars.put('uplinkText', getText('backToIndex'));
								
								// Description
								vars.put('pageDescription', cleanup(stripHTML(s)));
								
								// Folder info: no made date, no image count
								vars.put('folderInfo', showModifiedDate? 
									('<div class="modifieddate"><span>' + getText('modified') + '</span> ' + dateFormatter(new JDate()) + '</div>') 
									: 
									''
								);
								
								// Caption
								vars.put('thumbCaption', '<h6>' + t + '</h6>' + (s? ('<div class="comment">' + s + '</div>') : ''));
								
								// Page hook for CSS
								vars.put('pageHook', getOriginalPageName(ao, 'user') + '-page');
								
								// Has folder image?
								vars.put('hasFolderImage', hasFolderImg);
						
							} else {
								
								// Normal items
								
								// Comment
								s = vars.get('comment');
								
								// Short comment
								vars.put('commentShort', shorten(s, 160, true));
								
								// Image number
								vars.put('imageNum', imageNum.getAndIncrement() + 1);
								
								// Formatted file size
								vars.put('fileSizeFormatted', getSizeAsString(vars.get('fileSize')));
								
						
								// Added date
									if (storeAdded && (s = ao.getWhenAdded())) {
									dates.added = Long.valueOf(Math.floor(s / 1000));
								}
								
								// Taken date
									if (storeTaken && (s = getEpochDate(ao, false))) {
									dates.dateTaken = Long.valueOf(Math.floor(s / 1000));
								}
								
								// Modified date
									if (storeModified && (s = ao.getLastModified())) {
									dates.fileModified = Long.valueOf(Math.floor(s / 1000));
								}
								
								// Time of day
								if (_useOriginalTime && (v = getOriginalTime(ao))) {
									vars.put('originalTime', v);
								}
								
								// Thumbnail caption
								if (thumbCaptionTemplate && (s = processTemplate(ao, thumbCaptionTemplate, false))) {
									vars.put('thumbCaption', s);
								} else {
									vars.put('thumbCaption', '');
								}
								
								// Photo data
								if (_usePhotodata && (s = getPhotodata(ao, photoDataTemplate, 'p', showPhotoDataLabel))) {
									vars.put('photodata', s);
								}
								
								// Image caption
								if (imageCaptionTemplate && (s = processTemplate(ao, imageCaptionTemplate, false))) {
									vars.put('imageCaption', s);
								} else {
									vars.put('imageCaption', '');
								}
								
								if (cat === Category.image) {
									
									// Regions / faces
									if (_useRegions && (s = getRegions(ao, regionsSkipEmpty)) !== null) {
										vars.put('regions', JSON.stringify(s));
										regionCount.getAndIncrement();
									}
									
									// 360 panorama
									if (s = checkProjectionType(ao)) {
										vars.put('projectionType', s);
										if (s === 'equirectangular') {
											vrCount.getAndIncrement();
											s = getGPano(vars);
											if (s) {
												vars.put('gpano', s);
											}
										}
									}
									
									// User designated panorama
									if (typeof panorama !== UNDEF && panorama) {
										vars.put('panorama', true);
									}
									
								}
								
								// Audio clip
								if (cat !== Category.audio) {
									var p = vars.get('audioClipPath'),
										t,
										d;
										
									if (p !== null) {
										// jAlbum attached clip
										t = vars.get('audioClipType');
										d = vars.get('audioClipDuration');
									} else if (copyAudioClips) {
										// Placed along the original?  
										p = checkAudioClip(ao);
									}
									
									if (p) {
										// Creating audioClip object
										var ac = new MyJSONObject();
										
										ac.path = p;
											
										if (t && t!== 'audio/mpeg') {
											ac.type = t;
										}
										
										if (d) {
											ac.duration = d.toString();
										}
										
										//print('Found audio clip for "' + ao.getName() + '": ' + ac.path + (ac.type? ('(' + ac.type + ')') : '')); 
										vars.put('audioClip', ac);
									}
								}
									
								// Copying GIF / SVG files with whatever settings
								s = getExt(ao.getName()).toLowerCase();
								if ((s === 'gif' || s === 'svg') && 
									!useOriginals && !ao.isIncludeOriginal() &&
									(s = copyOriginal(ao))) {
									vars.put('originalFile', s);
								}
								
								// Custom slideshow delay
								s = vars.get('customSlideshowDelay');
								if (s !== null) {
									if (typeof s === STRING) {
										s = parseInt(s);
									}
									if (typeof s === NUMBER) {
										vars.put('slideshowInterval', Long.valueOf(s));
									}
								}
								
								// Custom transition speed
								s = vars.get('customTransitionSpeed');
								if (s !== null) {
									if (typeof s === STRING) {
										s = parseInt(s);
									}
									if (typeof s === NUMBER) {
										vars.put('transitionSpeed', Long.valueOf(s));
									}
								}
								
								// Map
								if (_useMap) {
									s = getLocation(ao);
									vars.put('location', s);
									//logger(Level.FINE, 'Location for "{0}": "{1}"', [ ao.getName(), s ]);
									if (s) {
										locationCount.getAndIncrement();
									}
								}
								
								// External content
								if ((v = vars.get('externalContent')) && (v = processTemplate(ao, v, true))) {
									var ext = new MyJSONObject(),
										size = vars.get('externalContentSize');
										
									ext.put('cont', v.trim());
									
									if (!size && (size = getDimFromCode(v.toLowerCase()))) {
										size = size.join('x');
									}
									                              
									if (size) {
										ext.put('size', size);
									}
									
									vars.put('external', ext);
								}
								
							}
						}
						
						if (!isEmpty(dates)) {
							vars.put('dates', dates);
						}
					}
				});
				
				// Current folder variables --> tree.json
				
				/*************************************************
				 *
				 *	Processing the current folder for tree.json
				 *
				 *************************************************/
				 
				var	vars = folder.getVars();
				
				if (vars) {
					
					var c = vars.get('description'),
						t = vars.get('title'),
						modDate,
						topNav,
						top = (folder === rootFolder),
						count = getCountObj(folder);
						
					// Counters
					vars.put('shopCount', shopCount.get());
					vars.put('locationCount', locationCount.get());
					vars.put('regionCount', regionCount.get());
					vars.put('vrCount', vrCount.get());
					vars.put('folderCount', count.folder);
					vars.put('pageCount', count.webPage);
					vars.put('webLocationCount', count.webLocation);
					vars.put('lightboxableCount', count.image + count.audio + count.video + count.other);
					vars.put('nonLightboxableCount', count.folder + count.webPage + count.webLocation);
					
					_anyVr = vrCount.get() > 0;
					
					// Has folder image? 
					vars.put('hasFolderImage', hasFolderImg);
					
					// Zip file?
					vars.put('zipFile', zipCount.get()? (folder.getWebName() + '.zip') : '');
					
					// Folder modified date for templates
					if (top) {
						
						var dates = {};
						
						// Epoch date range
						dateRange = JAlbumUtilities.getDeepCameraDates(folder);
						
						switch (folderDateSource) {
							case 'fileDate':
								vars.put('folderModDate', modDate = vars.get('fileDate'));
								break;
								
							case 'folderModDate':
								vars.put('folderModDate', modDate = getFormattedDate(deepLastModifiedObject(folder)));
								break;
								
							case 'lastCameraDate':
								vars.put('folderModDate', modDate = getFormattedDate(dateRange.last + 0));
								break;
								
							case 'cameraDateRange':
								if (dateRange.first && dateRange.last) {
									//print(dateRange.first + ' - ' + dateRange.last);
									vars.put('folderModDate', modDate = getFormattedDateRange(dateRange.first + 0, dateRange.last + 0));
									break;
								}							
								
							default:
								vars.put('folderModDate', modDate = '');
						}
						
						// Added date
						if (storeAdded && (s = JAlbumUtilities.getDeepLastAdded(folder))) {
							dates.added = Long.valueOf(Math.floor(s / 1000));
						}

						// Taken Date
						if (storeTaken && dateRange.first && dateRange.last) {
							dates.dateRange = [ Long.valueOf(Math.floor(dateRange.first / 1000)), 
												Long.valueOf(Math.floor(dateRange.last / 1000)) ];
						}
						
						// Modified date
						if (storeModified && (s = JAlbumUtilities.deepLastModified(folder))) {
							dates.fileModified = Long.valueOf(Math.floor(s / 1000));
						}
						
						// Dates object
						if (!isEmpty(dates)) {
							vars.put('dates', dates);
						}
							
					}
					
					// Neighboring folders
					if (!top && (linkNeighboringFolders || afterLast === 'ask' || afterLast === 'nextfolder' || afterLast === 'nextindex')) {
						
						var rp;
						
						ao = neighboringFolderSkipLevels? 
								getPreviousFolder(folder, 4, true) 
								: 
								getPreviousFolder(folder, 0, false);
						
						if (ao != null) {
							v = ao.getVars();
							rp = urlEncode(getRelativePath(folder, ao));
							vars.put('previousFolderPath', rp);									//  + v.get('closeupPath')
							vars.put('previousFolderTitle', ao.getTitle() || ao.getName());
							vars.put('previousFolderThumbPath', v.get('iconPath')? '' : getThumbPath(ao));
							s = v.get('askPermission');
							if (s !== null) {
								vars.put('previousFolderAsk', s);
							}
							
							if ((ao = getLastImage(ao)) != null) {
								vars.put('previousFoldersLast', rp + indexName + '#img=' + getFinalName(ao));
							} else {
								vars.put('previousFoldersLast', '');
							}
						} else {
							vars.put('previousFolderPath', '');
							vars.put('previousFolderTitle', '');
							vars.put('previousFolderThumbPath', '');
							vars.put('previousFoldersLast', '');
						}
						
						ao = neighboringFolderSkipLevels? 
								getNextFolder(folder, 4, true, neighboringFolderLoop) 
								: 
								getNextFolder(folder, 0, false, neighboringFolderLoop);
								
						if (ao != null) {
							v = ao.getVars();
							rp = urlEncode(getRelativePath(folder, ao));
							vars.put('nextFolderPath', rp);
							vars.put('nextFolderTitle', ao.getTitle() || ao.getName());
							vars.put('nextFolderThumbPath', v.get('iconPath')? '' : getThumbPath(ao));
							s = v.get('askPermission');
							if (s !== null) {
								vars.put('nextFolderAsk', s);
							}
							
							if ((ao = getFirstImage(ao)) != null) {
								vars.put('nextFoldersFirst', rp + indexName + '#img=' + getFinalName(ao));
							} else {
								vars.put('nextFoldersFirst', '');
							}
						} else {
							vars.put('nextFolderPath', '');
							vars.put('nextFolderTitle', '');
							vars.put('nextFolderThumbPath', '');
							vars.put('nextFoldersLast', '');
						}
					}
							
					// Page URL and thumb path
					if (basePath) {
						vars.put('pageUrl', basePath + relPathEncoded + indexName);
						if (hasFolderImg) {
							vars.put('pageThumbPath', basePath + relPathEncoded + shareImageFilename);
						}
					} else {
						vars.put('pageUrl', '');
						if (hasFolderImg) {
							vars.put('pageThumbPath', shareImageFilename);
						}
					}
					
					// Page title, HTML tags removed
					vars.put('pageTitle', cleanup(stripHTML(t)));
					
					// Top navigation
					vars.put('topNavigation', _useTopNavigation? 
							getTree(rootFolder, topNavigationIncludeFolders, topNavigationIncludePages, topNavigationIncludeWebLocations) 
							: 
							''
						);
											
					// Breadcrumb path
					if (showBreadcrumbPath) {
						vars.put('breadcrumbPath', getBreadcrumbPath(folder));
					}
					
					// Up link
					if (level) {
						vars.put('uplink', '../' + indexName);
						vars.put('uplinkText', getText('upOneLevel'));
					} else {
						vars.put('uplink', homepageAddress || '');
						vars.put('uplinkText', homepageLinkText || getText('home'));
					}
					
					// Description
					vars.put('pageDescription', stripQuot(stripHTML(c)));
					
					// Map overlay
					vars.put('mapOverlay', getMapOverlayFiles(imageDirectory, outputDirectory));
						
					vars.put('folderInfo', 
						(
							showModifiedDate? 
								('<div class="modifieddate"><span>' + getText('modified') + '</span> ' + dateFormatter(new JDate()) /*+ vars.get('fileDate')*/ + '</div>') 
								: 
								''
						) + (
							showImageCount? getCounts(folder, true, 'div', 'counts') : '')
						);
					
					// Title as in the Hero
					
					if (_titleCaptionTemplate && (s = processTemplate(folder, _titleCaptionTemplate, false))) {
						vars.put('folderTitle', s);
					} else {
						vars.put('folderTitle', '');
					}
					
				}
				
				revertStatus();
			},
					
		/*
		 *	Initializing Javascript variables
		 */
		 
		getGlobalVars = function() {
				var o = {
							albumName:		stripQuot(albumTitle),
							makeDate:		Long.valueOf(Math.floor((new Date()).getTime() / 1000)),
							licensee:		license,
							thumbDims:		maxThumbWidth + 'x' + maxThumbHeight,
							locale:			locale.replace('_', '-')
						};
						
				if (indexName !== 'index.html') {
					o['indexName'] = indexName;
				}
				
				if (homepageAddress) {
					o['uplink'] = escQuot(homepageAddress);
					o['uplinkText'] = homepageLinkText? homepageLinkText : getText('home');
				}
				
				if (useOriginals) {
					o['useOriginals'] = true;
				}
				
				if (gatherWeblocationInfo && showFolderImageCount) {
					o['weblocationCounts'] = true;
				}
				
				// Controls
				if (!enableKeyboard) {
					o['enableKeyboard'] = false;
				}
				
				if (!enableMouseWheel) {
					o['enableMouseWheel'] = false;
				}
				
				if (rightClickProtect) {
					o['rightClickProtect'] = true;
				}
				
				if (!useFullScreen) {
					o['useFullScreen'] = false;
				}
				
				if (thumbstripPosition !== 'top') {
					o['thumbsPosition'] = thumbstripPosition;
				}
				
				if (fixedShapeThumbs !== true) {
					o['fixedShapeThumbs'] = false;
				}
				
				if (audioClipVolume !== 75) {
					o['audioClipVolume'] = audioClipVolume / 100;
				}

				if (_anyShares) {
					
					var s = new Array();
					
					if (shareFacebook) s.push('facebook');
					if (shareThreads) s.push('threads');
					if (shareBluesky) s.push('bluesky');
					if (shareTwitter) s.push('twitter');
					if (shareTumblr) s.push('tumblr');
					if (sharePinterest) s.push('pinterest');
					if (shareLinkedin) s.push('linkedin');
					if (shareDigg) s.push('digg');
					if (shareReddit) s.push('reddit');
					if (shareEmail) s.push('email');
					if (shareLink) s.push('link');
					o['share'] = { 
						sites:			s.join(','),
						hook:			'.social .social-root'
					}
					if (emailSubject) {
						o['share']['emailSubject'] = emailSubject;
					}
					if (emailBody) {
						o['share']['emailBody'] = emailBody;
					}
				}
				
				if (_useSearch) {
					o['search'] = {
						fields:		searchFields,
						hook:		'.search'
					}
				}
				
				if (engine.isHiDPIImages()) {
					o['hiDpiImages'] = true;
				}
				
				if (engine.isHiDPIThumbs()) {
					o['hiDpiThumbs'] = true;
				}
				
				if (markFilesNew && newDaysCount) {
					o['markNew'] = {
							days:		newDaysCount,
							reference:	newDaysRef
						}
					
					if (newDaysMark === 'text' && newDaysText) {
						o.markNew['text'] = newDaysText;
					}
				}
				
				if (slideshowAuto) {
					o['autoStart'] = true;
				}
				
				return o;
			},
			
		// Lightbox variables
		
		getLightboxVars = function() {
				var oo = {
							lightbox:	{}
						},
					o = oo.lightbox;
			
				if (afterLast !== 'donothing') {
					o['afterLast'] = afterLast;
				}
				
				o['transitionType'] = transitionType;
				
				o['slideshowDelay'] = slideshowDelay;
				o['transitionSpeed'] = transitionSpeed;
				
				if (fitImages !== 'both') {
					o['fit'] = fitImages;
				}
				if (!neverScaleUp) {
					o['scaleUp'] = true;
				}
				if (panoramaPlayer) {
					o['panoramaPlayer'] = true;
				}
				if (videoAutoPlay) {
					o['videoAuto'] = true;
				}
				if (thumbstripVisibility !== 'auto') {
					o['thumbstripVisibility'] = thumbstripVisibility;
				}
				if (showDownload) {
					o['showDownload'] = true;	
					if (downloadNonImages) {
						o['allowDownloadOthers'] = true;
					}
					if (downloadScaled) {
						o['allowDownloadScaled'] = true;
					}
				}
				if (showMap) {
					o['showMap'] = true;
				}
				if (showRegions) {
					o['showRegions'] = true;
					if (regionsBtnText && regionsBtnText !== getText('regionsBtn')) {
						o['regionsBtn'] = regionsBtnText || getText('faces');
					}
					if (regionsVisible) {
						o['regionsVisible'] = true;
					}
				}
				if (printImageButton) {
					o['printImage'] = true;
				}
				if (captionStyle !== 'dark') {
					o['captionstyle'] = captionStyle;
				}
				if (captionPlacement !== 'center bottom') {
					o['captionplacement'] = captionPlacement;
				}
				if (showImageNumbers) {
					o['showNumbers'] = true;
				}
				/*
				if (!use360Player) {
					o['use360Player'] = false;
				}
				*/
				if (backgroundAudioSlideshowControl) {
					o['backgroundAudioSlideshowControl'] = true;
				}
				if (_useFotomoto) {
					o['fotomoto'] = true;
				}
				if (clickAction !== 'donothing') {
					o['clickAction'] = clickAction;
				}
				if (hideSidebarDuringSlideshow) {
					o['hideSidebar'] = true;
				}
				
				return oo;	
			},
			
		// Audio player vars
		
		getAudioPlayerVars = function(audioFiles) {
				var o = {};
				
				o['src'] = copyResources(audioFiles.split('\t'), backgroundMusicFolder);
					
				if (o['src']) {
					
					if (backgroundAudioVolume !== 25) {
						o['volume'] = backgroundAudioVolume / 100;
					}
					if (!backgroundAudioAutoPlay) {
						o['autoPlay'] = false;
					}
					if (!backgroundAudioLoop) {
						o['loop'] = false;
					}
					if (backgroundAudioSlideshowControl) {
						o['slideshowControl'] = true;
					}
					if (!backgroundAudioRetainPosition) {
						o['saveStatus'] = false;
					}
					
					o['folder'] = backgroundMusicFolder;
				
					return o;
					
				}
				
				return {};
			},
			
		// Index page variabes
		
		getIndexVars = function(isIndex) {
				var o = {
							rootPath:	getParentFolderLink(level),
							resPath:	resPath,
							relPath:	relPathEncoded.replace(/\/$/, ''),
							level:		level
						};
				
				if (_useTagCloud && (tagCloudSource !== 'subfolders' || level >= tagCloudSkipLevels)) {
					o['tagCloud'] = {
							fields:		tagCloudFields.replace(/,\s+/g, ','),
							depth:		tagCloudSource,
							hook:		'#tag-cloud .tag-cloud'
						};
						
					if (!(tagCloudUseFolders && tagCloudUsePages && tagCloudUseWebLocations)) {
						// Selected types
						var types = [
								'image',
								'audio',
								'video',
								'other'
							];
						if (tagCloudUseFolders) {
							types.push('folder');
						}
						if (tagCloudUsePages) {
							types.push('page');
						}
						if (tagCloudUseWebLocations) {
							types.push('webLocation');
						}
						o['tagCloud']['types'] = types.join(',');
					}
					
					if (tagCloudSort !== 'none') {
						o['tagCloud']['sort'] = tagCloudSort;
					}
					
					if (tagCloudFontVaries) {
						o['tagCloud']['fontVaries'] = true;
					}
					
					if (tagCloudSearch) {
						o['tagCloud']['searchHook'] = '#tag-cloud form';
					}
				}
				
				if (isIndex) {
					
					if (_useSearchNew) {
					
						o['searchNew'] = {
								days:		searchNewDays.replace(/,\s+/g, ','),
								depth:		searchNewSource,
								hook:		'.search-new'
							}
							
						if (searchNewReference !== 'dateTaken') {
							o['searchNew']['reference'] = searchNewReference;
						}
						
						if (!searchNewSinceLastVisit) {
							o['searchNew']['sinceLastVisit'] = false;
						}
					}
				
					if (level > 0) {
						
						if (typeof previousFolderPath !== UNDEF) {
							o['previousFolderPath'] = previousFolderPath;
						}
						
						if (typeof previousFoldersLast !== UNDEF) {
							o['previousFoldersLast'] = previousFoldersLast;
						}
						
						if (typeof nextFolderPath !== UNDEF) {
							o['nextFolderPath'] = nextFolderPath;
						}
						
						if (typeof nextFoldersFirst !== UNDEF) {
							o['nextFoldersFirst'] = nextFoldersFirst;
						}
					}
				}
				
				return o;
			},

		//	Get Javascript variable to pass to the skin
		
		getJsVars = function() {
				var v = extend({}, jsGlobalVars, { 'pageType': pageType }),
					pageName;
				
				if (pageType === 'page') {
					pageName = getOriginalPageName(currentObject) + '';
					extend(v, getIndexVars(false), { 'pageName': pageName });
				} else {
					extend(v, getIndexVars(true));
				}
				
				if (pageType === 'index' || pageName === 'newimages') {
					// Lightbox
					extend(v, jsLightboxVars);
					// Map vars
					if (_useMap) {
						var o =	{
									type:				mapType,
									zoom:				mapZoom,
									index:				showMapSection
								};
								
						if (googleApiKey && googleApiKey.charAt(0) !== '#') {
							o['apiKey'] = googleApiKey.trim();
						}
						
						if (typeof mapOverlay !== UNDEF && mapOverlay) {
							o['overlay'] = mapOverlay;
						}
						
						extend(v, { map: o });
					}
				}
					
				return (JSON.stringify(v)).replace(/\:true/g, ':!0').replace(/\:false/g, ':!1');
			},
			
		// Get APIs
		
		getAPIs = function() {
				var a = {};
				
				if (googleSiteID && googleAnalytics !== 'none') {
					a['googleAnalytics'] = [ xEncrypt(googleSiteID), googleAnalytics, supportDoubleclick ];
				}
				
				if (_useFacebook) {
					a['facebook'] = [ xEncrypt(facebookAppId), (typeof locale === STRING)? locale : 'en_US' ];
				}
				
				return JSON.stringify(a).replace(/\:true/g, ':!0').replace(/\:false/g, ':!1').replace(/^\{\}$/, '');
			},	
			
		// Get Cookie Policy variables
			
		getCookiePolicyVars = function() {
			
				var v = {};
				
				v['cookiePolicy'] = showCookiePolicy;
				
				if (cookiePolicyStay != 15) {
					v['stay'] = cookiePolicyStay;
				}
			
				if (cookiePolicyUrl) {
					v['cookiePolicyUrl'] = cookiePolicyUrl;
				}
				
				return JSON.stringify(v).replace(/\:true/g, ':!0').replace(/\:false/g, ':!1');
			},
				
	
		/*
		 * Initializing album
		 */
			 
		initAlbum = function() {
			
				// Fixed shape
				if (fixedShapeThumbs) {
					engine.addFilter(new FixedShapeFilter(), JAFilter.THUMBNAILS_PRESCALE_STAGE);
				} else {
					engine.addFilter(new ConstrainRatioFilter(0.75, 2.4), JAFilter.THUMBNAILS_PRESCALE_STAGE);
				}
			
				if (folderDateSource === 'none') {
					_folderCaptionTemplate = folderCaptionTemplate.replace(/\s*(<span class="date">)?\$\{folderModDate\}<\/span>/g, '');
					_titleCaptionTemplate = titleCaptionTemplate.replace(/\s*(<span class="date">)?\$\{folderModDate\}<\/span>/g, '');
				}
				
				// Custom link
				if (typeof customLink !== UNDEF && customLink) {
					credits = '<a href="' + customLink + '" target="_blank">' + 
						((customLinkText)? customLinkText : customLink) +
						'</a>' +
						(credits? (' &middot; ' + credits) : '');
				}
				
				// MS server configuration
				if (useMsServer) {
					copySkinFile('includes', 'web.config');
				} else {
					removeOutputFile('web.config');
				}
		
				// Expiry headers
				if (useExpiry) {
					copySkinFile('includes', '.htaccess');
				} else {
					removeOutputFile('.htaccess');
				}
				
				if (useRobotsTxt) {
					copySkinFile('includes', 'robots.txt');
					copySkinFile('includes', 'humans.txt');
				} else {
					removeOutputFile('robots.txt');
					removeOutputFile('humans.txt');
				}
				
				// JS variables
				jsGlobalVars = getGlobalVars();	
				jsLightboxVars = getLightboxVars();
				jsCookiePolicyVars = showCookiePolicy? getCookiePolicyVars() : null;
				
				// Creating all.js
				mergeJs('js',
					[	// Dependencies
						// Modernizr
						'modernizr',
						// Detects input method
						'what-input',
						// Utilities
						'laza.util',
						// Album model
						'jalbum.album',
						// laza libraries
						'laza.cookie',
						'laza.thumbscroll',
						'laza.alignto',
						'laza.tooltip',
						'laza.modal',
						'laza.sharebuttons',
						'laza.transform',
						'laza.swipe',
						// Audio player
						'laza.audioPlayer',
						// Map
						_useMap? 'laza.addmap' : '',
						// Lightbox and misc utilities
						'laza.lightbox',
						// Paypal
						//(_useShop? 'laza.paypal,' : '') +
						// Feedback
						//(_useFeedback? 'laza.feedback,' : '') +
						// main Js
						'main'
					].filter(Boolean),
					// Output name
					'all',
					debugMode,
					[
						// Texts:start
						// jalbum.album
						'and',
						'from',
						'databaseMissingOrBroken',
						'checkProcessSubdirectories',
						'uploadAlbumAgain',
						'localAccessBlocked',
						'databaseAccessDenied',
						'cantLoadDataForFolder',
						// modal
						'closeWindow',
						'okButton',
						'warning',
						'error',
						// ask permission
						'restrictedLinkTitle',
						'restrictedLinkQuestion',
						'restrictedLinkYes',
						'restrictedLinkNo',
						// relative date
						'today',
						'yesterday',
						'daysAgo',
						'monthsAgo',
						'yearsAgo',
						// share buttons
						'share',
						'shareOn',
						'checkThisOut',
						'localWarning',
						'email',
						'copy',
						'copied',
						'slideshow',
						// search
						'searchPlaceholder',
						'foundNTimes',
						'notFound',
						'search',
						'newImages',
						'results',
						'reset',
						'label',
						'selectedItems',
						'addCart',
						'return',
						'select',
						'sortBy',
						'sortedBy',
						'ascending',
						'descending',
						'multipleSelectHint',
						'noRating',
						'and',
						// search new
						'newItem',
						'today',
						'inThePast24Hours',
						'inThePast48Hours',
						'inTheLastDay',
						'inThePastNDays',
						'inThePastNMonths',
						'inThePastNYears',
						'sinceMyLastVisit',
						'betweenDays',
						'onDay',
						'beforeDay',
						'afterDay',
						'imagesAdded',
						'imagesModified',
						'imagesTaken',
						// lightbox
						'startSlideshow',
						'startSlideshowShort',
						'atFirstPage',
						'atLastPage',
						'atLastPageQuestion', 
						'startOver', 
						'backToHome',
						'nextIndex',
						'stop',
						'pause',
						'pauseShort',
						'upOneLevel',
						'upOneLevelShort',
						'backToCover',
						'previousPicture',
						'previousPictureShort',
						'nextPicture',
						'nextPictureShort',
						'previousFolder',
						'nextFolder',
						'oneToOneSize',
						'oneToOneSizeShort',
						'fitToScreen',
						'fitToScreenShort',
						'showInfo',
						'showInfoShort',
						'hideInfo',
						'hideInfoShort',
						'showThumbs',
						'showThumbsShort',
						'hideThumbs',
						'hideThumbsShort',
						'clickToOpen',
						'play',
						'audioClipLabel',
						'metaBtn', 
						'metaLabel',
						'mapBtn',
						'mapLabel',
						'shareBtn',
						'shareLabel',
						'download',
						'print',
						'printLabel',
						'fotomotoBtn',
						'fotomotoTooltip',
						'regionsBtn',
						'regionsLabel',
						// scroll to top
						'scrollTopTooltip',
						// etc
						'new',
						'more',
						'less',
						'locationWarning',
						'cookiePolicyText',
						'cookiePolicyAgree',
						'cookiePolicyLearnMore',
						'gdprComplianceText',
						'allowAll',
						'denyAll',
						'allowSelected',
						'image',
						'images',
						'audio',
						'audios',
						'video',
						'videos',
						'other',
						'others'
						// Texts:end
					]
				);
								
			};
		
	initAlbum();

	if (typeof writeSitemapXml !== 'undefined' && writeSitemapXml) {
		//System.out.println('writeSitemap = ' + writeSitemapXml);
		createSitemap();
	}
	
	// Creating top bar
	
	getTopBar = function() {
		
		var	logo = '',
			menu = [];

		/******** Logo */

		if (logoName) {
			logo += '<div class="logo">';
			
			if (level) {
				logo += '<a href="' + rootPath + '/' + indexName + '" data-tooltip title="' + getText('home') + '">' +
					'<img src="' + resPath + '/' + encodeURIComponent(logoName) + '">' +
					'</a>';
			} else if (homepageAddress) {
				logo += '<a href="' + homepageAddress + '"' + 
					(homepageLinkText? (' data-tooltip title="' + homepageLinkText + '"') : '') +
					'><img src="' + resPath + '/' + encodeURIComponent(logoName) + '"></a>';
			} else {
				logo += '<img src="' + resPath + '/' + encodeURIComponent(logoName) + '">';
			}
			
			logo += '</div>';
		}
		
		/******** Top menu */
		
		if (topMenuIncludeFolders || topMenuIncludePages || topMenuIncludeWebLocations) {
			var cat,
				vars;
				
			for each (ao in currentFolder.getChildren()) {
				
				if (ao.isIncluded()) {
					cat = ao.getCategory();
					
					if (cat === Category.folder && topMenuIncludeFolders && !ao.isHidden() ||
						cat === Category.webPage && topMenuIncludePages ||
						cat === Category.webLocation && topMenuIncludeWebLocations) {
					
						vars = ao.getVars();
						
						menu.push('<a class="btn" href="' + (getExternalLink(vars) || vars.get('closeupPath')) + '">' + 
								vars.get('title') + 
							'</a>');
					}
				}
			}
		}
	
		if (logo || menu.length) {
			return '\t\t\t\t\t\t<div class="top-bar ' + 
					(logo? 'haslogo ' : '') +
					(menu.length? 'hasmenu' : '') +
				'">' + 
					logo +
					(menu.length? ('<div class="menu">' + menu.join('') + '</div>') : '') +
				'</div>';
		}
		
		return '';
	};

	