<% // Newimages.htt skin specific part
	var thumbs = [],										// Thumbnails buffer
		dmax = newImagesDays * 24 * 60 * 60 * 1000,			// Difference in ms
		n = 0,
		start = 0,
		preload = 9999,
		
		// Returns the caption according to 'thumbnailItems' variable
		getCaption = function(ao, fallback) {
			var vars = ao.getVars(),
				cat = ao.getCategory(),
				keys = thumbnailItems.split('\t'),
				k,
				val,
				sb = [];
				
			for each (k in keys) {
				
				val = vars.get(k);
				
				if (typeof val !== UNDEF && val !== null) {
					if (k === 'label') {
						val = val.replaceAll('_', ' ');
					}
					if (cat === Category.webPage && k === 'comment') {
						val = shorten(val, 160);
					}
					if (val) {
						if (thumbnailItemsDisplay === 'firstFound') {
							sb.push(val);
							break;
						} else {
							sb.push((sb.length || k === 'comment')? val : ('<strong>' + val + '</strong>'));
						}
					}
				}
			}
			
			if (sb.length === 0 && typeof fallback !== UNDEF) {
				sb.push(fallback);
			}
			
			return sb.join('<br>');
		},
		
		// Returns the lightbox caption according to 'lightboxItems' variable
		getLightboxCaption = function(ao) {
			var vars = ao.getVars(),
				keys = lightboxItems.split('\t'),
				k,
				val,
				sb = [];
				
			for each (k in keys) {
				
				val = vars.get(k);
				
				if (typeof val !== UNDEF && val !== null) {
					if (k === 'label') {
						val = val.replaceAll('_', ' ');
					}
					if (val) {
						if (lightboxItemsDisplay === 'firstFound') {
							sb.push(val);
							break;
						} else {
							sb.push((sb.length || k === 'comment')? val : ('<strong>' + val + '</strong>'));
						}
					}
				}
			}
			
			return sb.join('<br>');
		},
		
		writeOutThumbnails = function() {
			var maxPage = rows? Math.ceil(thumbs.length / (rows * cols)) : 1,
				ao,
				vars,
				cat,
				rp,
				
				getThumbnails = function(pageNo) {
					var sb = new StringBuilder(),
						mx = rows? Math.min((pageNo + 1) * (rows * cols), thumbs.length) : thumbs.length;
					
					for (var i = rows? pageNo * rows * cols : 0; i < mx; i++) {
						ao = thumbs[i][0];
						cat = ao.getCategory(), 
						vars = ao.getVars();
						rp = getRelativePath(currentFolder, ao.getParent());
						
						if (rp && !rp.endsWith('/')) {
							rp += '/';
						}
						
						sb.append('\t\t\t\t\t<div class="' + cat + ' card has-caption" data-width="' + vars.get('thumbWidth') + '">' +
							'<a href="' + rp + vars.get('closeupPath') + '" class="thumb"');
			
						if (cat === Category.image || cat === Category.video) {
							// Lightboxable items: adding Photoswipe-related data
							sb.append(' data-pswp-src="' + rp + vars.get('imagePath') + '"');
				
							if (cat === Category.image) {
								// Check for variants
								var srcSet = getCloseupSrcset(ao);
								if (srcSet) {
									sb.append(' data-pswp-srcset="' + srcSet + '"');
									var maxDims = getMaxImageDims(ao);
									if (maxDims) {
										sb.append(' data-pswp-width="' + maxDims[0] + '" data-pswp-height="' + maxDims[1] + '"');
									}
								} else {
									sb.append(' data-pswp-width="' + vars.get('imageWidth') + '" data-pswp-height="' + vars.get('imageHeight') + '"');
								}
							} else {
								// Video
								sb.append(' data-pswp-width="' + vars.get('videoWidth') + '" data-pswp-height="' + vars.get('videoHeight') + '"');
							}
				
							if (fixedShapeThumbs) {
								// Cropped thumbnails
								sb.append(' data-cropped="true"');
							}
							
							// Caption
							s = getLightboxCaption(ao);
							if (s.length) {
								sb.append(' data-caption="' + s.replaceAll('"', '&#34;') + '"');
							}
							
							// Photo data
							if (usePhotodata) {
								s = getPhotodataFields(ao, photodataTemplate);
								if (s) {
									sb.append(' data-photodata="' + s.replaceAll('"', '&#34;') + '"');
								}
							}
							
							// GPS data
							if (useLocation) {
								s = vars.get('gpsLocation');
								if (s && s !== '0.000000,0.000000') {
									sb.append(' data-location="' + s + '"');
								}
							}
							
							// Original path for download button
							s = vars.get('originalPath');
							if (s) {
								sb.append(' data-download="' + rp + s + '"');
							}
							
							// Video source
							if (cat === Category.video) {
								sb.append(' data-pswp-video-src="' + rp + vars.get('videoPath') + '" data-pswp-video-poster="' + vars.get('imagePath') + '"');
							}
						}
						
						sb.append('>');
					
						s = vars.get('iconPath');
						if (typeof s !== UNDEF && s) {
							// Icon
							sb.append('<img class="noborder" src="' + s + '" width="' + vars.get('thumbWidth') + '" height="' + vars.get('thumbHeight') + '" alt="' + title + '"></a>');
						} else {
							// Thumbnail
							sb.append(getThumbnailElement(ao));
						}
						
						sb.append('</a>');
						
						s = getCaption(ao);
						// Caption
						if (s.length) {
							sb.append('<div class="caption"' + ((!fixedShapeThumbs && justifyThumbs)? (' style="max-width:' + vars.get('thumbWidth') + 'px"') : '') + '>' + s + '</div>');
						}
						
						sb.append('</div>\n');
					}
					
					return sb.toString();
				};
						
			for (var pageNo = 0; pageNo < maxPage; pageNo++) {
				out.println('\t\t\t<div class="items' + (pageNo? '' : (' first' + ((!fixedShapeThumbs && justifyThumbs)? ' hide':''))) + '" data-pageno="' + (pageNo + 1) + '">');
					out.println('\t\t\t\t<div class="bunchof thumbnails ' +
							(fixedShapeThumbs? 'fixed-shape' : (justifyThumbs? 'justified' : 'free-shape')) +
						'">');
						out.print(getThumbnails(pageNo));
					out.println('\t\t\t\t</div>');
				out.println('\t\t\t</div>');
			}
		},
		
		sortThumbnails = function() {
			
			if (newImagesSort === 'date') {
				if (newImagesReverse) {
					thumbs.sort(function(a, b) {
							//print('a:'+a['refDate']+(a['refDate']>b['refDate']? '>':'<')+' b:'+b['refDate']);
							return  a[1] - b[1];
						});
				} else {
					thumbs.sort(function(a, b) {
							return  b[1] - a[1];
						});
				}
			} else if (newImagesSort === 'name') {
				if (newImagesReverse) {
					thumbs.sort(function(a, b) {
							return 	(b[0]['title']||b[0]['name']).localeCompare(a[0]['title']||a[0]['name']);
						});
				} else {
					thumbs.sort(function(a, b) {
							return 	(a[0]['title']||a[0]['name']).localeCompare(b[0]['name']||b[0]['name']);
						});
				}
			} else if (newImagesSort === 'random') {
				thumbs.sort(function() {
						return  0.5 - Math.random();
					});
			}
		},
			
		// Gathering new images		
		
		gatherNew = function(folder) {
			
			var images = folder.getChildren(),
				ao,
				cat,				// Category
				now = new Date(),
				d;
		
			for (var i = start; i < images.length; i++) {

				ao = images[i];
				
						if (ao.isIncluded()) {
					cat = ao.getCategory();
					//print(ao.getName() + ' [' + cat + ']');

					if (cat === Category.folder) {
						if (newImagesDepth !== 'current' && !ao.isHidden() && !getFolderView(ao)) {
							gatherNew(ao);
						}
					} else if (cat === Category.image || cat === Category.other ||
						cat === Category.audio || cat === Category.video) {
						
						if (newImagesSource === 'added') {
							d = ao.getWhenAdded();
						} else if (newImagesSource === 'dateTaken') {
							d = getEpochDate(ao, false);
						} else {
							d = ao.getLastModified();
						}
						
						if (d && (now - d) <= dmax) {
							thumbs.push([ao, d]);
						}
					}
				}
			}
		};
		
	if (newImagesDays) {
			
		gatherNew((newImagesDepth === 'tree')? rootFolder : currentFolder);
		
		if (newImagesSort !== 'original') {
			sortThumbnails();
		}
		
		writeOutThumbnails();
	}

%>