<%
	var sb = new StringBuilder(),
		ao,
		vars,
		cat,
		mosaic,
		caption,
		s,
		preload = rows? rows * cols : 20,
		
		// Returns the caption according to 'thumbnailItems' variable
		getCaption = function(ao, fallback) {
			var vars = ao.getVars(),
				cat = ao.getCategory(),
				keys = thumbnailItems.split('\t'),
				k,
				val,
				sb = [];
				
			for each (k in keys) {
				
				val = vars.get((k === 'comment' && cat === Category.folder)? 'description' : k);
				
				if (typeof val !== UNDEF && val !== null) {
					if (k === 'label') {
						val = val.replaceAll('_', ' ');
					}
					if (k === 'comment' && cat === Category.webPage) {
						val = shorten(val, 160);
					}
					if (val) {
						if (thumbnailItemsDisplay === 'firstFound') {
							sb.push(val);
							break;
						} else if (	cat === Category.folder && folderPlacement === 'above' || 
									cat === Category.webPage && pagePlacement === 'above' ||
									cat === Category.webLocation && webLocationPlacement === 'above'
								) {
							sb.push((sb.length || k === 'comment')? ('<p class="small">' + val + '</p>') : val);
						} else {
							sb.push((sb.length || k === 'comment')? val : ('<strong>' + val + '</strong>'));
						}
					}
				}
			}
			
			if (sb.length === 0 && typeof fallback !== UNDEF) {
				sb.push(fallback);
			}
			
			return sb.join('<br>');
		},
		
		// Returns the lightbox caption according to 'lightboxItems' variable
		getLightboxCaption = function(ao) {
			var vars = ao.getVars(),
				keys = lightboxItems.split('\t'),
				k,
				val,
				sb = [];
				
			for each (k in keys) {
				
				val = vars.get(k);
				
				if (typeof val !== UNDEF && val !== null) {
					if (k === 'label') {
						val = val.replaceAll('_', ' ');
					}
					if (val) {
						if (lightboxItemsDisplay === 'firstFound') {
							sb.push(val);
							break;
						} else {
							sb.push((sb.length || k === 'comment')? val : ('<strong>' + val + '</strong>'));
						}
					}
				}
			}
			
			return sb.join('<br>');
		},
		
		getMosaic = function(folder, cp) {
				var sb = new StringBuilder(),
					imgs = getRandomThumbs(folder, 3),
					co = getCountObj(folder),
					ti = (typeof co !== UNDEF)? (co.image + co.audio + co.video) : 0;

				for (var i = 0, vars, cat, alt, tp, rp, l = imgs.length; i < l; i++) {
					vars = imgs[i].getVars();
					
					if (vars) {
						cat = imgs[i].getCategory();
						
						alt = stripHTML(vars.get('title') || vars.get('label')).replace(/"/g, '&#34;'); //" syntax highlighter fix
							
						if (cat === Category.folder && (tp = vars.get('iconPath'))) {
							// Icon
							tp = resPath + '/' + defaultFolderIconName;
							icc = 'icon ';
						} else {
							// Any other
							tp = getThumbPath(imgs[i]);
							ic = '';
						}
						
						//print('\tthumb[' + i + '] ' + cp + mosaic[i].getVars().get('thumbPath'));
						sb.append('<a href="' + cp + '">' +
								'<img src="' + tp + '" alt="' + alt + '">' +		// ' 
								((!showFolderInfo && i === l - 1)? '<span>+<small>' + (ti - imgs.length) + '</small></span>' : '') + 
							'</a>');
					}
				}
				
				return sb.length? ('<div class="mosaic">' + sb.toString() + '</div>') : '';				
			},
			
		getNewImagesContent = function(ao) {
			var vars = ao.getVars(),
				cp = vars.get('closeupPath'),
				now = new Date(),
				newimages = [],
				newImagesDepth = vars.get('newImagesDepth') || 'current',
				newImagesSource = vars.get('newImagesSource') || 'dateTaken',
				dmax = (vars.get('newImagesDays') || 30) * 24 * 60 * 60 * 1000,
				buf = new StringBuilder(),
				gatherNew = function(folder) {
					var items = folder.getChildren();
					if (items.length) {
						for (var i = 0, ao, cat, d; i < items.length; i++) {
							ao = items[i];
							if (ao.isIncluded()) {
								cat = ao.getCategory();
								if (cat === Category.folder) {
									if (newImagesDepth !== 'current' && !ao.isHidden()) {
										gatherNew(ao);
									}
								} else if (cat === Category.image || cat === Category.other ||
									cat === Category.audio || cat === Category.video) {
									if (newImagesSource === 'added') {
										d = ao.getWhenAdded();
									} else if (newImagesSource === 'dateTaken') {
										d = getEpochDate(ao, false);
									} else {
										d = ao.getLastModified();
									}
									if (d && (now - d) <= dmax) {
										newimages.push([ao, d]);
									}
								}
							}
						}
					}
				};

			gatherNew((newImagesDepth === 'tree')? rootFolder : currentFolder);
			
			if (newimages.length) {
				buf.append('<h3>' + (ao.getTitle() || vars.get('label')) + '</h3>');
				buf.append('<div class="single-row">');
				for (var i = 0; i < newimages.length && i < 10; i++) {
					buf.append('<div class="thumb"><a href="' + cp + '"><img src="' + getRelativePath(currentFolder, newimages[i][0].getParent()) + '/' + newimages[i][0].getVars().get('thumbPath') + '"></a></div>');
				}
				buf.append('</div>');
			}
			
			return buf.toString(); 
		},
			
		// Current section type
		currentSection = null,
		
		// Writing out collected thumbnails
		flushBuffer = function() {
			if (sb.length()) {
				out.println('\t\t\t\t<div class="' + [
						'bunchof',
						(currentSection || 'thumbnails'),
						(currentSection === 'thumbnails')? (fixedShapeThumbs? 'fixed-shape' : (justifyThumbs? 'justified' : 'free-shape')) : '',
						(currentSection === 'thumbnails')? ((folderPlacement !== 'mixed' || totalFolders === 0)? 'images-only' : ((totalImages > 0)? 'mixed' : 'folders-only')) : '', 
						(currentSection === 'pages')? 'pages-cont' : ''
					].filter(Boolean).join(' ') +
					'">\n' + sb + '\t\t\t\t</div>');
				sb.setLength(0);
			}
		};
		
	/* 
	 *	Pages section - if above the thumbnails 
	 */
	 
	if (totalPages > 0 && pagePlacement === 'above') {
		sb.setLength(0);
		
		for each (ao in children.include(Category.webPage)) {
			vars = ao.getVars();
			caption = getCaption(ao, capitalize(getOriginalPageName(ao, vars.get('label'))));
			
			sb.append('<div class="page card">' +
				'<a href="' + vars.get('closeupPath') + '" class="thumb">' + 
					'<span class="icon"><img src="' + resPath + '/' + secondaryIconTheme + '/' + getOriginalPageName(ao, 'user') + '-page.svg"></span>' + 
					'<span class="caption">' + caption + '</span>' + 
				'</a>' +
			'</div>');
		}
		
		if (sb.length() > 0) {
			out.println('\t\t<section id="pages" class="pages">' + 
					'<div class="cont">' + sb.toString() + '</div>' +
				'</section>');
		}
	}
	
	/* 
	 *	Folders section - if above the thumbnails 
	 */
	 
	if (totalFolders > 0 && (folderPlacement === 'above' || 
		(foldersAboveIfNoImages && totalImages === 0 && folderPlacement !== 'mixed' && folderPlacement !== 'section'))) {
		sb.setLength(0);
		
		for each (ao in children.dirs()) {
			if (ao.isIncluded() && !ao.isHidden()) {
				vars = ao.getVars();
				mosaic = folderMosaic? getMosaic(ao) : '';
				ip = vars.get('iconPath');
				
				if (ip) {
					s = (ip.startsWith('../')? ip.slice(3) : ip).replace(/\.png$/i, '.svg');
				} else {
					s = vars.get('thumbPath');
				}
				
				sb.append('<div class="folder card ' + (mosaic? 'hasmosaic' : 'nomsaic') + '">');
					// Folder info
					if (showFolderInfo) {
						var c = getCounts(ao, false, 'div', 'folderinfo');
						if (c) {
							sb.append(c);
						}
					}
					// Thumbnail
					sb.append('<div  class="thumb' + (ip? ' icon' : '') + '">' +
						'<a href="' + vars.get('closeupPath') + '">' +
							(s?
								('<img class="noborder" src="' + s + '" width="' + vars.get('thumbWidth') + '" height="' + vars.get('thumbHeight') + '" alt="' + vars.get('label') + '">')
								:
								getThumbnailElement(ao)
							) +
						'</a>');
						// Mosaic
						if (mosaic) {
							sb.append(mosaic);
						}
					sb.append('</div>');
					// Caption
					sb.append('<div class="caption">' + getCaption(ao, vars.get('label')) + '</div>');
				
				sb.append('</div>');
			}
		}
		
		if (sb.length() > 0) {
			out.println('\t\t<section id="folders" class="folders ' + (fixedShapeThumbs? 'grid-type' : 'full') + '">' +
					'<div class="cont">' + sb.toString() + '</div>' +
				'</section>');
		}
	}
	
	/* 
	 *	Weblocations section - if above the thumbnails 
	 */
	 
	if (totalWebLocations > 0 && webLocationPlacement === 'above') {
		sb.setLength(0);
		
		for each (ao in children.include(Category.webLocation)) {
			if (ao.isIncluded()) {
				vars = ao.getVars();
				caption = getCaption(ao);
				s = vars.get('iconPath');
				sb.append('<div class="weblocation card">' +
					'<a href="' + vars.get('closeupPath') + '" class="thumb' + (s? ' icon' : '') + '">' +
						(s?
							('<img class="noborder" src="' + s + '" width="' + vars.get('thumbWidth') + '" height="' + vars.get('thumbHeight') + '" alt="' + vars.get('label') + '">')
							:
							getThumbnailElement(ao)
						) +
					'</a>' +
					'<span class="caption">' + caption + '</span>' + 
				'</div>');
			}
		}
		
		if (sb.length() > 0) {
			out.println('\t\t<section id="weblocations" class="weblocations">' +
					'<div class="cont">' + sb.toString() + '</div>' +
				'</section>');
		}
	}
	
	/* 
	 *	Main thumbnails (and mixed mode) section 
	 */
	 
	if (items.length) {
	
		out.println('\t\t<section class="main-cont">');
		
		for (var pageNo = 0; pageNo < items.totalPages(); pageNo++) {
			// Paging
			// Creating a bunch
			out.println('\t\t\t<div class="items' + (pageNo? '' : (' first' + ((!fixedShapeThumbs && justifyThumbs)? ' hide':''))) + '" data-pageno="' + (pageNo + 1) + '">');
			sb.setLength(0);
			
			//if (pageNo) preload = 0;
			
			for each (ao in items.page(pageNo)) {
				cat = ao.getCategory();
				vars = ao.getVars();
				
				if (cat === Category.folder) {
					// Folder
					if (folderPlacement === 'mixed' && currentSection !== 'thumbnails' || 
						folderPlacement === 'section' && currentSection !== 'folders') {
						// Start new section
						flushBuffer();
						currentSection = (folderPlacement === 'mixed')? 'thumbnails' : 'folders';
					}
						
					caption = getCaption(ao, vars.get('label').replaceAll('_', ' '));
						
					sb.append('\t\t\t\t\t<div class="folder card has-caption" data-width="' + vars.get('thumbWidth') + '">' +
							(showFolderInfo? getCounts(ao, false, 'div', 'folderinfo') : '') +
							'<a href="' + vars.get('closeupPath') + '" class="thumb">' + getThumbnailElement(ao, !preload) + '</a>' +
							'<div class="caption">' + caption + '</div>' +
						'</div>\n');
					
					if (preload) preload--;
					
				} else if (cat === Category.webPage) {
					// Custom page
					if (pagePlacement === 'mixed' && currentSection !== 'thumbnails' || 
						pagePlacement === 'embed' && currentSection !== 'pages') {
						// Start new section
						flushBuffer();
						currentSection = (pagePlacement === 'mixed')? 'thumbnails' : 'pages';
					}
					
					var n = getOriginalPageName(ao, 'user');
					
					if (pagePlacement === 'embed') {
						if (n === 'newimages') {
							s = getNewImagesContent(ao);
							if (s) {
								sb.append('\t\t\t\t\t<div class="page newimages-page"><div class="page-wrap">' + s + '</div></div>\n');
							}
						} else {
							s = getCustomPageContent(ao);
							if (s) {
								sb.append('\t\t\t\t\t<div class="page ' + n + '-page">' +
										'<div class="page-wrap">' + 
											((n === 'contents')? s : s.replace(/<h2/, '<h3').replace(/<\/h2>/, '</h3>')) +
										'</div>' +
									'</div>\n');
							}
						}
					} else {
						sb.append('\t\t\t\t<div class="page card' + (caption? ' has-caption':'') + '" data-width="' + vars.get('thumbWidth') + '">' +
								'<a href="' + vars.get('closeupPath') + '" class="thumb icon"><img src="' + resPath + '/' + secondaryIconTheme + '/' + getOriginalPageName(ao, 'user') + '-page.svg"></a>' +
								'<div class="caption">' + (vars.get('fileTitle') || capitalize(n)) + '</div>' +
							'</div>\n');
						
						if (preload) preload--;
					}
					
				} else if (cat === Category.webLocation) {
					// Web location
					if (currentSection !== 'thumbnails') {
						// Start new section
						flushBuffer();
						currentSection = 'thumbnails';
					}
					
					caption = getCaption(ao);					// Fallback? vars.get('label').replaceAll('_', ' ')
					
					sb.append('\t\t\t\t<div class="folder card' + (caption? ' has-caption':'') + '" data-width="' + vars.get('thumbWidth') + '">' +
							'<a href="' + vars.get('closeupPath') + '" class="thumb">' + getThumbnailElement(ao, !preload) + '</a>' +
							'<div class="caption">' + caption + '</div>' +
						'</div>\n');
					
					if (preload) preload--;
					
				} else {
					// Anything other: image, video, audio, other
					if (currentSection !== 'thumbnails') {
						flushBuffer();
						currentSection = 'thumbnails';
					}
					
					if (zipImages === 'originals' || zipImages === 'slides' || zipImages === 'included' && vars.get('originalPath')) {
						zipCount += 1;
					}
					
					caption = getCaption(ao);
					
					sb.append('\t\t\t\t\t<div class="' + cat + ' card has-caption" data-width="' + vars.get('thumbWidth') + '">' +
								'<a href="' + vars.get('closeupPath') + '" class="thumb"');
					
					if (cat === Category.image || cat === Category.video) {
						// Lightboxable items: adding Photoswipe-related data
						sb.append(' data-pswp-src="' + vars.get('imagePath') + '"');
						
						if (cat === Category.image) {
							// Check for variants
							var srcSet = vars.get('imageSrcset');
							if (typeof srcSet !== UNDEF && srcSet !== null) {
								sb.append(' data-pswp-srcset="' + srcSet + '"');
								var maxDims = getMaxImageDims(ao);
								if (maxDims) {
									sb.append(' data-pswp-width="' + maxDims[0] + '" data-pswp-height="' + maxDims[1] + '"');
								}
							} else {
								sb.append(' data-pswp-width="' + vars.get('imageWidth') + '" data-pswp-height="' + vars.get('imageHeight') + '"');
							}
							// Original path for download button
							s = vars.get('originalPath');
							if (s) {
								sb.append(' data-download="' + s + '"');
							}
							
						} else {
							// Video
							sb.append(' data-pswp-width="' + vars.get('videoWidth') + '" data-pswp-height="' + vars.get('videoHeight') + '"');
						}
						
						// Cropped thumbnails
						sb.append(' data-cropped="true"');
						
						// Caption
						s = getLightboxCaption(ao);
						if (s) {
							sb.append(' data-caption="' + s.replaceAll('"', '&#34;') + '"');
						}
						
						// Photo data
						if (usePhotodata) {
							s = getPhotodataFields(ao, photodataTemplate);
							if (s) {
								sb.append(' data-photodata="' + s.replaceAll('"', '&#34;') + '"');
							}
						}
						
						// GPS data
						if (useLocation) {
							s = vars.get('gpsLocation');
							if (s && s !== '0.000000,0.000000') {
								sb.append(' data-location="' + s + '"');
							}
						}
						
						// Original path for download button
						s = vars.get('audioClipPath');
						if (s) {
							sb.append(' data-audioclip="' + s + '"');
						}
						
						// Video source
						if (cat === Category.video) {
							sb.append(' data-pswp-video-src="' + vars.get('videoPath') + '" data-pswp-video-poster="' + vars.get('imagePath') + '"');
						}
					}
					
					sb.append('>');
					
					s = vars.get('iconPath');
					if (typeof s !== UNDEF && s) {
						// Icon
						sb.append('<img class="noborder" src="' + s + '" width="' + vars.get('thumbWidth') + '" height="' + vars.get('thumbHeight') + '" alt="' + title + '"></a>');
					} else {
						// Thumbnail
						sb.append(getThumbnailElement(ao, !preload));
						if (preload) preload--;
					}
					
					sb.append('</a>');
					
					// Caption
					if (caption.length) {
						sb.append('<div class="caption"' + ((!fixedShapeThumbs && justifyThumbs)? (' style="max-width:' + vars.get('thumbWidth') + 'px"') : '') + '>' + caption + '</div>');
					}
					
					sb.append('</div>\n');
				}
			}
				
			flushBuffer();
			out.println('\t\t\t</div>');
		}
		
		flushBuffer();
		
		if (zipCount) {
			out.println('\t\t<div class="download-btn"><a href="' + encodeAsJava(currentFolder.getWebName()) + '.zip" class="icon-download button" download>' + ((zipImages === 'slides')? getText('downloadImages') : getText('downloadHighResImages')) + '</a></div>');
		}
		
		out.println('\t\t</section>');
		
	}
	
%>