	import PhotoSwipeLightbox from './photoswipe/photoswipe-lightbox.esm.min.js';
	import PhotoSwipe from './photoswipe/photoswipe.esm.min.js';
	let hashChangedBySkin = false;
	const UNDEF = 'undefined',
		LB_SELECTOR = '.card.image > .thumb,.card.video > .thumb,.aday > .thumb',
		IS_LOCAL = location.protocol === 'file' || location.host.startsWith('127.0.0.1') || location.host.startsWith('192.168'),
		HISTORY = window.hasOwnProperty('history') && !!window.history.pushState,
		noContextMenu = function(e) { 
			e.preventDefault(); 
		},
		findImageNumber = function(name) {
			const imgs = document.querySelectorAll(LB_SELECTOR);
			for (let i = 0; i < imgs.length; i++) {
				if (imgs[i].getAttribute('data-pswp-src') === ('slides/' + name)) return i;
			}
			return -1;
		},
		setHash = function(hash, title) {
			const h = (typeof hash === UNDEF)? '' : '#img=' + encodeURIComponent(hash);
			if (h !== window.location.hash) {
				hashChangedBySkin = true;
				if (h) {
					history.pushState(h, (typeof title === UNDEF)? '' : title, h);
				} else {
					history.pushState('', document.title || '', '<%= indexName %>');
				}
				setTimeout(function() { hashChangedBySkin = false; }, 1000);
			}
		},
		hashChanged = function() {
			if (hashChangedBySkin) return;
			const name = window.location.hash.match(/#img=(.+)$/);
			if (name) {
				const n = findImageNumber(name[1]);
				if (n !== -1) {
					if (typeof lightbox.pswp === UNDEF) {
						lightbox.loadAndOpen(n);
					} else {
						lightbox.pswp.goTo(n);
					}
				}
			} else {
				lightbox.pswp.close();
			}
		},
		<ja:if test="${hasShare}">
		openWindow = function(url) {
			const sw = screen.width, 
				sh = screen.height, 
				ww = Math.min(sw, 570), 
				wh = Math.min(sh, 570);
			window.open(url, 'SharingWindow', 'menubar=no,toolbar=no,status=no,width=' + ww + ',height=' + wh + ',left=' + ((sw - ww) / 2) + ",top=" + ((sh - wh) / 2));
		},
		copyCb = function(url) {
			const success = () => { alert('<%= getSafeText("linkCopiedToClipboard") %>'); };
			navigator.clipboard.writeText(url)
				.then(() => { success() })
				.catch(() => {
					const inp = document.createElement('input');
					inp.value = url;
					document.body.appendChild(inp);
					inp.select();
					document.execCommand('copy');
					document.body.removeChild(inp);
					success();
				});
		},
		</ja:if>
		<%------------------------------- 
			Full screen API
		-------------------------------%>
		<ja:if test="${fullScreenLightbox}">
		getFullscreenPromise = function() {
			return new Promise((resolve) => {
				if (!fullscreenAPI || fullscreenAPI.isFullscreen()) {
					resolve();
					return;
				}
				document.addEventListener(fullscreenAPI.change, (event) => {
					pswpContainer.style.display = 'block';
					setTimeout(function() {
						resolve();
					}, 300);
				}, { once: true });
				fullscreenAPI.request(pswpContainer);
			});
		},
		getFullscreenAPI = function() {
			let api,
				enterFS,
				exitFS,
				elementFS,
				changeEvent,
				errorEvent;
			if (document.documentElement.requestFullscreen) {
				enterFS = 'requestFullscreen';
				exitFS = 'exitFullscreen';
				elementFS = 'fullscreenElement';
				changeEvent = 'fullscreenchange';
				errorEvent = 'fullscreenerror';
			} else if (document.documentElement.webkitRequestFullscreen) {
				enterFS = 'webkitRequestFullscreen';
				exitFS = 'webkitExitFullscreen';
				elementFS = 'webkitFullscreenElement';
				changeEvent = 'webkitfullscreenchange';
				errorEvent = 'webkitfullscreenerror';
			}
			if (enterFS) {
				api = {
					request: function (el) {
						if (enterFS === 'webkitRequestFullscreen') {
							el[enterFS](Element.ALLOW_KEYBOARD_INPUT);
						} else {
							el[enterFS]();
						}
					},
					exit: function () {
						return document[exitFS]();
					},
					isFullscreen: function () {
						return document[elementFS];
					},
					change: changeEvent,
					error: errorEvent
				};
			}
			return api;
		},
		getContainer = function() {
			const pswpContainer = document.createElement('div');
			pswpContainer.style.background = '#000';
			pswpContainer.style.width = '100%';
			pswpContainer.style.height = '100%';
			pswpContainer.style.display = 'none';
			document.body.appendChild(pswpContainer);
			return pswpContainer;
		},
		<ja:if test="${fullScreenLightboxMobilesOnly}">
		fullscreenAPI = (document.documentElement.clientWidth <= 640)? getFullscreenAPI() : null,
		pswpContainer = (document.documentElement.clientWidth <= 640)? getContainer() : null,
		</ja:if><ja:else>
		fullscreenAPI = getFullscreenAPI(),
		pswpContainer = getContainer(),
		</ja:else>
		</ja:if>
		<%------------------------------- 
			Modal handling
		-------------------------------%>
		removeModals = function() {
			const modals = lightbox.pswp.element.querySelectorAll('.modal');
			if (modals) {
				Array.prototype.forEach.call(modals, function(modal) {
					modal.parentNode.removeChild(modal);
				});
				lightbox.pswp.element.classList.remove('has-modal');
			}
		},
		closeModals = function(except) {
			const modals = lightbox.pswp.element.querySelectorAll('.modal' + ((typeof except !== 'undefined')? (':not(.' + except + ')') : ''));
			if (modals) {
				Array.prototype.forEach.call(modals, modal => { modal.style.display = 'none'; });
			}
		},
		createModal = function(el, className) {
			removeModals();
			const window = document.createElement('div'),
				br = el.getBoundingClientRect();
			window.classList.add(className, 'modal');
			window.style.right = (window.innerWidth || document.documentElement.clientWidth) - br.right + 'px';
			window.style.top = br.bottom + 'px';
			lightbox.pswp.element.appendChild(window);
			lightbox.pswp.element.classList.add('has-modal');
			return window;
		},
		getModal = function(className) {
			return lightbox.pswp.element.querySelector('.modal.' + className);
		},
		closeModal = function(el) {
			if (typeof el === 'string') el = getModal(el);
			el.style.display = 'none';
			lightbox.pswp.element.classList.remove('has-modal');
		},
		openModal = function(el) {
			if (typeof el === 'string') el = getModal(el);
			closeModals();
			el.style.display = 'block';
			lightbox.pswp.element.classList.add('has-modal');
		},
		toggleModal = function(el) {
			if (typeof el === 'string') el = getModal(el);
			if (el.style.display === 'block') {
				closeModal(el);
			} else {
				openModal(el);
			}
		},
		<%------------------------------- 
			Media handling
		-------------------------------%>
		pauseAllMedia = function() {
			if (lightbox['pswp']) {
				let media = lightbox.pswp.element.querySelectorAll('video,audio');
				if (media) {
					Array.prototype.forEach.call(media, function(m) {
						m.pause();
					});
				}
			}
		},
		<%------------------------------- 
			Prev/Next arrow
		-------------------------------%>
		leftArrowSVGString = '<svg aria-hidden="true" class="pswp__icn" width="60" height="60" viewBox="0 0 60 60"><path fill="${buttonColor}" fill-rule="evenodd" d="m17.23 30 21-21 1.54 1.54L20.3 30l19.47 19.46L38.23 51Z"/></svg>',
		<%------------------------------- 
			Initing lightbox
		-------------------------------%>
		lightbox = new PhotoSwipeLightbox({
			gallery: 				'.main',
			children: 				LB_SELECTOR,
			<ja:if test="${fullScreenLightbox}">
			openPromise: 			getFullscreenPromise,
			appendToEl: 			fullscreenAPI? pswpContainer : document.body,
			showAnimationDuration: 	0,
			hideAnimationDuration: 	0,
			preloadFirstSlide: 		false,
			</ja:if>
			mouseMovePan: 			true,
			initialZoomLevel: 		'fit',
			secondaryZoomLevel: 	1,
			maxZoomLevel: 			4,
			bgOpacity: 				<%= getAlpha(lightboxBgColor).toFixed(3) %>,
			counter: 				false,
			arrowPrevSVG:			leftArrowSVGString,
			arrowNextSVG:			leftArrowSVGString,
			closeSVG:				'<svg aria-hidden="true" class="pswp__icn" width="32" height="32" viewBox="0 0 32 32"><path fill="${buttonColor}" d="M26.11 4.83 16 14.94 5.89 4.83 4.83 5.89 14.94 16 4.83 26.11l1.06 1.07L16 17.06l10.11 10.12 1.07-1.07L17.06 16 27.18 5.89l-1.07-1.06z"/></svg>',
			zoomSVG:				'<svg aria-hidden="true" class="pswp__icn" width="32" height="32" viewBox="0 0 32 32"><path fill="${buttonColor}" d="m27.75 26.69-5.35-5.35a9.76 9.76 0 1 0-1.06 1.06l5.35 5.35ZM15 23.25A8.25 8.25 0 1 1 23.25 15 8.25 8.25 0 0 1 15 23.25Z"/><path fill="${buttonColor}" d="M9.75 14.25h10.5v1.5H9.75z" class="pswp__zoom-icn-bar-h"/><path fill="${buttonColor}" d="M14.25 9.75h1.5v10.5h-1.5z" class="pswp__zoom-icn-bar-v"/></svg>',
			closeTitle: 			'<%= getSafeText("close") %>',
			zoomTitle: 				'<%= getSafeText("zoom") %>',
			arrowPrevTitle: 		'<%= getSafeText("previous") %>',
			arrowNextTitle: 		'<%= getSafeText("next") %>',
			<%= getUserInclude(rootImageDirectory, 'user-options.inc') %>
			pswpModule: 			PhotoSwipe
		});
	<%------------------------------- 
		Listening to navigation events
	-------------------------------%>
	window.addEventListener('popstate', hashChanged);
	<%------------------------------- 
		Mouse wheel handler
	-------------------------------%>
	lightbox.on('bindEvents', () => {
		lightbox.pswp.container.addEventListener('wheel', (e) => {
			e.preventDefault();
			if (e.wheelDelta > 0) {
				lightbox.pswp.prev();
			<ja:if test="${afterLast}" value="loop">
			} else {
			</ja:if><ja:else>
			} else if (lightbox.pswp.currIndex < lightbox.getNumItems() - 1) {
			</ja:else>
				lightbox.pswp.next();
			}
		});
	});
	<%------------------------------- 
		Disabling clicks and swipe when using a modal
	-------------------------------%>
	let swiped = false,
		swipedTo,
		setSwiped = function(on) {
			clearTimeout(swipedTo);
			swiped = on;
			if (on) {
				swipedTo = setTimeout(function() {
					swiped = false;
				}, 500);
			}
		};
	lightbox.on('pointerUp', (e) => {
		setSwiped(!e.originalEvent.target.classList.contains('pswp__button'));
	});
	lightbox.on('pointerDown', (e) => {
		if (lightbox.pswp.element.classList.contains('has-modal')) {
			e.preventDefault();
			if (!e.originalEvent.target.closest('.modal') && !e.originalEvent.target.getAttribute('rel')) {
				closeModals();
				lightbox.pswp.element.classList.remove('has-modal');
			}
		}
	});
	<%------------------------------- 
		Fade in/out animations between pictures
	-------------------------------%>
	lightbox.on('contentActivate', ({ content }) => {
		if (!swiped) { 
			content.element.classList.add('fadein');
			setTimeout(function() { content.element.classList.remove('fadein'); }, 550)
		}
	});
	<%------------------------------- 
		Counter
	-------------------------------%>
	lightbox.on('uiRegister', function() {
		lightbox.pswp.ui.registerElement({
			name: 		'custom-counter',
			order: 		7,
			isButton: 	false,
			appendTo: 	'bar',
			onInit: 	(el, pswp) => {
							pswp.on('change', () => {
								const index = lightbox.pswp.currIndex + 1,
									max = lightbox.getNumItems();
								el.innerHTML = <ja:if test="${afterLast}" not value="loop">(index < max)? (index + '<span>' + (max - 1) + '</span>') : ''</ja:if>
									<ja:else>index + '<span>' + max + '</span>'</ja:else>;
							});
						}
		});
	});
	<%------------------------------- 
		Setting hash reference
	-------------------------------%>
	lightbox.on('contentActivate', ({ content }) => {
		// Changing hash
		if (HISTORY && content.data.src) {
			setHash(content.data.src.replace(/^slides\//, ''), (content.data.element.getAttribute('data-caption') || content.data.alt || '').replace(/<\/?[^>]+>/g, ' '));
		}
	});
	lightbox.on('close', () => {
		// Removing hash
		if (HISTORY) {
			setHash();
		}
	});
	<ja:if test="${rightClickProtect}">
	<%------------------------------- 
		Right-click protection
	-------------------------------%>
	lightbox.on('contentActivate', ({ content }) => {
		lightbox.pswp.element.addEventListener('contextmenu', noContextMenu);
	});
	</ja:if>
	<%------------------------------- 
		Audio player
	-------------------------------%>
	lightbox.on('uiRegister', function() {
		lightbox.pswp.ui.registerElement({
			name: 		'audio-player',
			order: 		8,
			isButton: 	false,
			appendTo: 	'bar',
			onInit: 	(el, pswp) => {
							pswp.on('change', () => {
								const currSlideElement = lightbox.pswp.currSlide.data.element;
								if (currSlideElement) {
									const clip = currSlideElement.getAttribute('data-audioclip');
									if (clip) {
										el.classList.remove('hidden');
										el.innerHTML = '<audio controls controlslist="play notimeline nofullscreen nodownload noplaybackrate"><source src="' + clip + '" type="audio/mpeg"></audio>';
										return;
									}
								}
								el.innerHTML = '';
							});
						}
		});
	});
	<ja:if test="${lightboxItems}">
	<%------------------------------- 
		Displaying captions
	-------------------------------%>
	lightbox.on('uiRegister', function() {
		lightbox.pswp.ui.registerElement({
			name: 		'custom-caption',
			order: 		9,
			isButton: 	false,
			appendTo: 	'root',
			onInit: 	(el, pswp) => {
							pswp.on('change', () => {
								const currSlideElement = lightbox.pswp.currSlide.data.element;
								if (currSlideElement) {
									const caption = currSlideElement.getAttribute('data-caption');
									if (caption) {
										el.classList.remove('hidden');
										el.innerHTML = caption;
										return;
									}
								}
								el.classList.add('hidden');
							});
						}
		});
	});
	</ja:if>
	<%------------------------------- 
		Video support
	-------------------------------%>
	lightbox.addFilter('itemData', (itemData, index) => {
		<ja:if test="${afterLast}" not value="loop">
		if (index === lightbox.getNumItems() - 1) {
			return;
		}
		</ja:if>
		let d = itemData.element.dataset.pswpVideoSrc;
		if (d) {
			itemData.videoSrc = d;
		}
		d = itemData.element.dataset.pswpVideoPoster;
		if (d) {
			itemData.videoPoster = d;
		}
		return itemData;
	});
	<%-- use <video> instead of <img> --%>
	lightbox.on('contentLoad', (e) => {
		const { content, isLazy } = e;
		if (content.data.videoSrc) {
			<%-- stopping the default behavior --%>
			e.preventDefault();
			content.element = document.createElement('div');		  
			content.element.className = 'pswp__video';
			content.state = 'loading';
			content.videoElement = document.createElement('video');
			content.videoElement.src = content.data.videoSrc;
			content.videoElement.controls = true;
			if (content.data.videoPoster) {
				content.videoElement.poster = content.data.videoPoster;
			}
			content.element.appendChild(content.videoElement);
			content.videoElement.oncanplaythrough = () => {
				content.onLoaded();
			};
			
			content.element.onerror = () => {
				content.onError();
			};
		}
	});
	<%-- on append: append the <video> element --%>
	lightbox.on('contentAppend', (e) => {
		const { content } = e;
		if (content.data.videoSrc && content.element && !content.element.parentNode) {
			e.preventDefault();
			content.slide.container.appendChild(content.element);
		}
	});
	<%-- on remove: remove the <video> element --%>
	lightbox.on('contentRemove', (e) => {
		const { content } = e;
		if (content.data.videoSrc && content.element && content.element.parentNode) {
			e.preventDefault();
			content.element.remove();
		}
	});
	<%-- on change: stop all media playing --%>
	lightbox.on('change', (e) => {
		pauseAllMedia();
	});
	<%------------------------------- 
		Full screen lightbox onclose event
	-------------------------------%>
	<ja:if test="${fullScreenLightbox}">
	lightbox.on('close', () => {
		if (pswpContainer) {
			pswpContainer.style.display = 'none';
			if (fullscreenAPI && fullscreenAPI.isFullscreen()) {
				fullscreenAPI.exit();
			}
		}
	});
	</ja:if>
	<%------------------------------- 
		Last page handling
	-------------------------------%>
	<ja:if test="${afterLast}" not value="loop">
	lightbox.addFilter('numItems', (numItems) => {
		return ++numItems;
	});
	lightbox.addFilter('itemData', (itemData, index) => {
		if (index === lightbox.getNumItems() - 1) {
			const ni = document.body.getAttribute('data-next-index');
			return {
				html: '<div class="last-slide">' +
					(ni? '<h4><%= getSafeText("whereToGoNext") %></h4>' : '') +
					'<div class="buttons">' +
						'<a class="quit btn"><%= getSafeText("backToIndex") %></a>' +
						(ni? '<a href="' + ni + '" class="next-index btn"><%= getSafeText("nextFolder") %></a>' : '') +
					'</div></div>'
			};
		}
		return itemData;
	});
	lightbox.on('contentActivate', ({ content }) => {
		if (content.type === 'html') {
			const btn = content.element.querySelector('.quit');
			if (btn) {
				btn.onclick = function(e) {
					e.preventDefault();
					lightbox.pswp.close();
				};
			}
			lightbox.pswp.element.classList.add('after-last');
		} else {
			lightbox.pswp.element.classList.remove('after-last');
		}
	});
	</ja:if>
	<%------------------------------- 
		Slideshow
	-------------------------------%>
	<ja:if test="${useSlideshow}">
	let slideshow = null,
		progressTo = null,
		progress,
		lastChange,
		setProgress = () => {
			const w = Math.min((new Date() - lastChange) / ${slideshowDelay}, 1);
			clearTimeout(progressTo);
			progress.style.width = 100 * w + '%';
			if (w < 1) {
				progressTo = setTimeout(setProgress, 25);
			}
		},
		nextSlide = () => {
			const { pswp } = lightbox;
			clearTimeout(slideshow);
			clearTimeout(progress);
			if (pswp.currIndex < pswp.getNumItems() - 1) {
				pswp.next();
				lastChange = new Date();
				progress.style.width = 0;
				progressTo = setTimeout(setProgress, 25);
				slideshow = setTimeout(nextSlide, ${slideshowDelay});
			} else {
				stopSlideshow();
			}
		},
		stopSlideshow = () => {
			clearTimeout(slideshow);
			slideshow = null;
			clearTimeout(progressTo);
			lightbox.pswp.element.classList.remove('playing');
			lightbox.pswp.element.classList.add('paused');
		},
		startSlideshow = () => {
			lightbox.pswp.element.classList.remove('paused');
			lightbox.pswp.element.classList.add('playing');
			lastChange = new Date();
			progress.style.width = 0;
			progressTo = setTimeout(setProgress, 25);
			slideshow = setTimeout(nextSlide, ${slideshowDelay});
		};
	<%-- handling the Start/Stop buttons --%>
	lightbox.on('uiRegister', function() {
		lightbox.pswp.ui.registerElement({
			name: 		'slideshow',
			ariaLabel: 	'<%= getSafeText("startStopSlideshow") %>',
			title:		'<%= getSafeText("startStopSlideshow") %>',
			order: 		12,
			isButton: 	true,
			tagName: 	'button',
			html: 		'<svg aria-hidden="true" class="pswp__icn play" width="32" height="32" viewBox="0 0 32 32"><path d="M8.67,7.34l15,8.66-15,8.66V7.34M7,4.45v23.1L27,16,7,4.45Z" fill="${buttonColor}"/></svg>' +
						'<svg aria-hidden="true" class="pswp__icn pause" width="32" height="32" viewBox="0 0 32 32"><path d="M13.71,26H12V6h1.71ZM20,26H18.29V6H20Z" fill="${buttonColor}"/></svg>' +
						'<div class="progress"></div>',
			onInit:		(el, pswp) => {
							pswp.element.classList.add('paused');
							progress = el.querySelector('.progress');
							pswp.on('close', () => {
								if (slideshow) {
									stopSlideshow();
								}
							});
							
							document.addEventListener('keydown', (e) => {
								if (e.keyCode === 32) {
									const { pswp } = lightbox;
									if (pswp) {
										e.stopImmediatePropagation();
										e.preventDefault();
										if (slideshow) {
											stopSlideshow();
										} else {
											startSlideshow();
										}
									}
								}
							});
						},
			onClick: 	(event, el) => {
							if (slideshow) {
								stopSlideshow();
							} else {
								startSlideshow();
							}
						}
		});
	});
	</ja:if>
	<%------------------------------- 
		Photodata button
	-------------------------------%>
	<ja:if test="${usePhotodata}">
	lightbox.on('uiRegister', function() {
		lightbox.pswp.ui.registerElement({
			name: 		'photodata-button',
			ariaLabel: 	'<%= getSafeText("showPhotodata") %>',
			title:		'<%= getSafeText("showPhotodata") %>',
			order: 		11,
			isButton: 	true,
			tagName: 	'button',
			html: 		'<svg aria-hidden="true" class="pswp__icn" width="32" height="32" viewBox="0 0 32 32"><path fill="${buttonColor}" d="M16 24.38A6.38 6.38 0 1 1 22.38 18 6.38 6.38 0 0 1 16 24.38Zm0-11.25A4.88 4.88 0 1 0 20.88 18 4.87 4.87 0 0 0 16 13.13ZM25.75 27H6.25A2.25 2.25 0 0 1 4 24.75v-12a2.25 2.25 0 0 1 2.25-2.25h3l.53-2.69A2.26 2.26 0 0 1 12 6h8a2.26 2.26 0 0 1 2.21 1.81l.53 2.69h3A2.25 2.25 0 0 1 28 12.75v12A2.25 2.25 0 0 1 25.75 27ZM6.25 12a.76.76 0 0 0-.75.75v12a.76.76 0 0 0 .75.75h19.5a.76.76 0 0 0 .75-.75v-12a.76.76 0 0 0-.75-.75h-4.22l-.78-3.9a.73.73 0 0 0-.75-.6h-8a.77.77 0 0 0-.74.61L10.47 12Z"/></svg>',
			onInit:		(btn, pswp) => {
							btn.setAttribute('rel', 'photodata'); 
							pswp.on('change', () => {
								removeModals();
								const currSlideElement = lightbox.pswp.currSlide.data.element;
								if (currSlideElement && currSlideElement.hasAttribute('data-photodata')) {
									btn.style.display = 'block';
								} else {
									btn.style.display = 'none';
								}
							});
						},
			onClick: 	(event, btn) => {
							let m = getModal('photodata');
							if (m) {
								toggleModal(m);
							} else {
								m = createModal(btn, 'photodata');
								const dl = m.appendChild(document.createElement('dl')),
									photodata = lightbox.pswp.currSlide.data.element.getAttribute('data-photodata').split('|');
								for (let i in photodata) {
									let k = photodata[i].split('='),
										el = document.createElement('dt');
									el.appendChild(document.createTextNode(k[0]));
									dl.appendChild(el);
									el = document.createElement('dd');
									el.appendChild(document.createTextNode(k[1]));
									dl.appendChild(el);
								}
							}
						}
		});
	});
	</ja:if>
	<%------------------------------- 
		GPS Location button
	-------------------------------%>
	<ja:if test="${useLocation}">
	let map;
	<ja:if test="${mapsApiKey}">
	<%-- Creating map with Google Maps API --%>
	async function setMap(canvas, latLng) {
		const { Map } = await google.maps.importLibrary("maps");
		const pos = { 
			lat: 		(typeof latLng[0] === 'number')? LatLng[0] : parseFloat(latLng[0]), 
			lng: 		(typeof latLng[1] === 'number')? LatLng[1] : parseFloat(latLng[1]) 
		};
		map = new Map(canvas, {
			center: 	pos,
			zoom: 		${mapZoom},
			mapTypeId: 	'${mapType}',
		});
		new google.maps.Marker({
			position: 	pos,
			map,
		});
	};
	</ja:if><ja:else>
	<%-- Creating map with OSM --%>
	async function setMap(canvas, latLng) {
		const pos = [
			(typeof latLng[0] === 'number')? latLng[0] : parseFloat(latLng[0]), 
			(typeof latLng[1] === 'number')? latLng[1] : parseFloat(latLng[1]) 
		];
		map = L.map(canvas).setView(pos, ${mapZoom}); 
		L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
			attribution: '&copy; <a href="https://openstreetmap.org/copyright">OpenStreetMap</a>'
		}).addTo(map);
		L.control.scale({
			imperial: 	true, 
			metric: 	true
		}).addTo(map); 
		L.marker(pos).addTo(map);
	};
	</ja:else>
	lightbox.on('uiRegister', function() {
		lightbox.pswp.ui.registerElement({
			name: 		'location-button',
			ariaLabel: 	'<%= getSafeText("mapLabel") %>',
			title:		'<%= getSafeText("mapLabel") %>',
			order: 		10,
			isButton: 	true,
			tagName: 	'button',
			html: 		'<svg aria-hidden="true" class="pswp__icn" width="32" height="32" viewBox="0 0 32 32"><path fill="${buttonColor}" d="M16 4.75a8.25 8.25 0 0 1 7 12.69c-1.22 1.92-5 6.6-6.95 9-1.93-2.35-5.73-7-6.95-8.95A8.25 8.25 0 0 1 16 4.75m0-1.5a9.76 9.76 0 0 0-8.22 15C9.52 21 16 28.75 16 28.75s6.48-7.79 8.22-10.5a9.76 9.76 0 0 0-8.22-15Zm0 7.5A2.25 2.25 0 1 0 18.25 13 2.25 2.25 0 0 0 16 10.75Z"/></svg>',
			onInit:		(btn, pswp) => {
							btn.setAttribute('rel', 'map'); 
							pswp.on('change', () => {
								removeModals();
								const currSlideElement = lightbox.pswp.currSlide.data.element;
								if (currSlideElement && currSlideElement.hasAttribute('data-location')) {
									btn.style.display = 'block';
								} else {
									btn.style.display = 'none';
								}
							});
						},
			onClick: 	(event, btn) => {
							let m = getModal('map');
							if (m) {
								toggleModal(m);
							} else {
								m = createModal(btn, 'map');
								setMap(m, lightbox.pswp.currSlide.data.element.getAttribute('data-location').split(','));
							}
						}
		});
	});
	</ja:if>
	<%------------------------------- 
		Share button
	-------------------------------%>
	<ja:if test="${hasShare}">
	lightbox.on('uiRegister', function() {
		lightbox.pswp.ui.registerElement({
			name: 		'sharing-button',
			ariaLabel: 	'<%= getSafeText("share") %>',
			title:		'<%= getSafeText("share") %>',
			order: 		9,
			isButton: 	true,
			tagName: 	'button',
			html:		'<svg aria-hidden="true" class="pswp__icn" width="32" height="32" viewBox="0 0 32 32"><path d="M22.5,5.5a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0,15a3,3,0,1,1-3,3,3,3,0,0,1,3-3M9.5,13a3,3,0,1,1-3,3,3,3,0,0,1,3-3m13,6a4.47,4.47,0,0,0-3.45,1.64l-5.34-3.08a4.34,4.34,0,0,0,0-3.12l5.34-3.08a4.5,4.5,0,1,0-.76-1.3L13,13.14a4.5,4.5,0,1,0,0,5.72l5.34,3.08A4.49,4.49,0,1,0,22.5,19Z" fill="${buttonColor}"/></svg>',
			onInit: 	(btn, pswp) => {
							btn.setAttribute('rel', 'share'); 
							pswp.on('change', () => {
								removeModals();
								const currSlideElement = lightbox.pswp.currSlide.data.element;
								if (currSlideElement) {
									btn.style.display = 'block';
								} else {
									btn.style.display = 'none';
								}
							});
						},
			onClick: 	(event, btn) => {
							let m = getModal('share');
							if (m) {
								toggleModal(m);
							} else {
								m = createModal(btn, 'share');
								const btns = m.appendChild(document.createElement('div')),
									shares = '${shares}'.split(','),
									url = [ location.href.slice(0, location.href.lastIndexOf('/')), lightbox.pswp.currSlide.data.element.getAttribute('href') ].join('/'),
									descr = (lightbox.pswp.currSlide.data.element.getAttribute('data-caption') || '').replace(/<\/?[^>]+>/g, ' ');
								btns.classList.add('sharing');
								shares.forEach(s => {
									let btn = document.createElement('a');
									btn.classList.add(s, 'btn');
									btn.setAttribute('target', '_blank');
									switch(s) {
										case 'facebook':
											btn.setAttribute('href', 'https://www.facebook.com/sharer/sharer.php?u=' + url);
											btn.innerHTML = '<%= icon_facebook.replace("#333333",captionColor) %>';
											btn.setAttribute('title', 'Facebook');
											break;
										case 'twitter':
											btn.setAttribute('href', 'https://twitter.com/intent/tweet?url=' + url + '&text=' + descr);
											btn.innerHTML = '<%= icon_twitter.replace("#333333",captionColor) %>';
											btn.setAttribute('title', 'X (Twitter)');
											break;
										case 'linkedIn':
											btn.setAttribute('href', 'https://www.linkedin.com/shareArticle?mini=true&url=' + url + '&summary=' + descr);
											btn.innerHTML = '<%= icon_linkedIn.replace("#333333",captionColor) %>';
											btn.setAttribute('title', 'LinkedIn');
											break;
										case 'pinterest':
											btn.setAttribute('href', 'https://www.pinterest.com/pin/create/button?url=' + url + '&media=IMAGE&description=' + descr);
											btn.innerHTML = '<%= icon_pinterest.replace("#333333",captionColor) %>';
											btn.setAttribute('title', 'Pinterest');
											break;
										case 'reddit':
											btn.setAttribute('href', 'https://www.reddit.com/submit?url=' + url + '&title=' + descr);
											btn.innerHTML = '<%= icon_reddit.replace("#333333",captionColor) %>';
											btn.setAttribute('title', 'Reddit');
											break;
										case 'email':
											btn.setAttribute('href', 'mailto:?subject=' + encodeURIComponent(document.title) + '&body=' + url + '%20%0D%0A' + descr);
											btn.innerHTML = '<%= icon_email.replace("#333333",captionColor) %>';
											btn.setAttribute('title', '<%= getSafeText("email") %>');
											break;
										case 'link':
											btn.setAttribute('href', 'javascript:void(0)');
											btn.innerHTML = '<%= icon_link.replace("#333333",captionColor) %>';
											btn.setAttribute('title', '<%= getSafeText("link") %>');
											break;
									}
									btns.appendChild(btn);
									if (!IS_LOCAL) {
										if (s === 'link') {
											btn.onclick = (e) => {
												e.stopPropagation(); 
												copyCb(url);
												return false;
											}
										} else if (s !== 'email') {
											btn.onclick = (e) => {
												e.stopPropagation(); 
												openWindow(e.currentTarget.getAttribute('href'));
												return false;
											}
										} 
									} else {
										btn.onclick = (e) => {
											e.stopPropagation();
											alert('<%= getSafeText("cantShareLocalAlbum") %>');
											return false;
										}
									}
								});
							}
						}
		});
	});
	</ja:if>
	<%------------------------------- 
		Download button
	-------------------------------%>
	lightbox.on('uiRegister', function() {
		lightbox.pswp.ui.registerElement({
			name: 		'download-button',
			ariaLabel: 	'<%= getSafeText("downloadImage") %>',
			title:		'<%= getSafeText("downloadImage") %>',
			order: 		8,
			isButton: 	true,
			tagName: 	'a',
			html: 		'<svg aria-hidden="true" class="pswp__icn" width="32" height="32" viewBox="0 0 32 32"><path fill="${buttonColor}" d="M25.5 21v4.5h-19V21H5v6h22v-6ZM21.48 12.44l-4.73 4.74V6h-1.5v11.18l-4.73-4.74-1.07 1.06L16 20.05l6.55-6.55-1.07-1.06z"/></svg>',
			onInit: 	(btn, pswp) => {
							btn.setAttribute('download', '');
							btn.setAttribute('rel', 'noopener');
							pswp.on('change', () => {
								const currSlideElement = lightbox.pswp.currSlide.data.element;
								if (currSlideElement) {
									const link = currSlideElement.getAttribute('data-download');
									if (link) {
										btn.href = link;
										btn.classList.remove('hidden');
										return;
									}
								}
								btn.classList.add('hidden');
							});
						}
		});
	});
	<%------------------------------- 
		Initializing the lightbox
	-------------------------------%>
	if (document.querySelectorAll('.card.video,.card.image,.aday').length) {
		lightbox.init();
		if (window.location.hash) {
			hashChanged();
			window.addEventListener('popstate', function() {
				hashChanged();
			});
		}
	}
	<%------------------------------- 
		Paging functionality
	-------------------------------%>
	<ja:if test="${rows}" not value="0">
	const mainCont = document.querySelector('.main-cont'),
		pages = [ ...(mainCont || document).querySelectorAll('.items') ],
		prevBtn = document.getElementById('prevpage'),
		nextBtn = document.getElementById('nextpage'),
		pageNo = document.getElementById('pageno');
	let gotoPage = function(from, to) {
			let animate = function() {
				Object.assign(pages[from].style, {
						position: 	'absolute',
						opacity:	1,
						top:		0,
						zIndex:		90
					});
				Object.assign(pages[to].style, {
						position:	'static',
						display:	'block',
						opacity:	0
					});
				pages[to].style.height = Math.max(pages[from].offsetHeight, pages[to].offsetHeight) + 'px';
				pages[from].animate({
						opacity: 	[ 1, 0 ],
						transform:	[ 'translateX(0)', 'translateX(' + ((to > from)? '-100%' : '100%') + ')' ]
					},
					{
						duration:	500,
						fill: 		'forwards',
						easing:		'ease-in-out'
					}
				);
				pages[to].animate({
						opacity: 	[ 0, 1 ],
						transform:	[ 'translateX(' + ((to > from)? '100%' : '-100%') + ')', 'translateX(0)' ]
					},
					{
						duration:	500,
						fill: 		'forwards',
						easing:		'ease-in-out'
					}
				);
				setTimeout(() => {
						Object.assign(pages[from].style, {
							display:	'none',
							position:	'static',
							height:		'auto'
						});
						Object.assign(pages[to].style, {
							display: 	'block',
							height:		'auto'
						});
					}, 510);
				if (to > 0) {
					prevBtn.classList.remove('disabled');
				} else {
					prevBtn.classList.add('disabled');
				}
				if (to < pages.length - 1) {
					nextBtn.classList.remove('disabled');
				} else {
					nextBtn.classList.add('disabled');
				}
				pageNo.innerText = to + 1;
			};
			<ja:if test="<%= !fixedShapeThumbs && justifyThumbs %>">justify(pages[to], function() { window.requestAnimationFrame(animate); });</ja:if>
			<ja:else>window.requestAnimationFrame(animate);</ja:else>
		},
		initPaging = function() {
			if (prevBtn) {
				prevBtn.onclick = (e) => {
					const curr = parseInt(pageNo.innerText) - 1;
					if (curr > 0) {
						gotoPage(curr, curr-1); 
					}
					return false;
				};
			}
			if (nextBtn) {
				nextBtn.onclick = (e) => {
					const curr = parseInt(pageNo.innerText) - 1;
					if (curr < pages.length - 1) {
						gotoPage(curr, curr+1); 
					}
					return false;
				};
				if (pages.length > 1) {
					nextBtn.classList.remove('disabled');
				}
			}
			if (pageNo && lightbox) {			
				lightbox.on('contentActivate', ({ content }) => {
					<ja:if test="${afterLast}" not value="loop">
					if (content.index === lightbox.getNumItems() - 1) {
						return;
					}
					</ja:if>
					const currSlideElement = lightbox.pswp.currSlide.data.element;
					if (currSlideElement) {
						const el = currSlideElement.closest('.items'),
							np = el && parseInt(el.getAttribute('data-pageno')) || 1,
							cp = parseInt(pageNo.innerText) || 1;
						if (np !== cp) {
							gotoPage(cp - 1, np - 1);
						}
					}
				});
			}
		};
	window.addEventListener('load', function() {
		initPaging();
	});
	</ja:if>
	<ja:if test="${rightClickProtect}">
	<%------------------------------- 
		Right-click protection on thumbnails
	-------------------------------%>
	document.querySelectorAll('.card.video,.card.image,.aday').forEach(el => { el.addEventListener('contextmenu', noContextMenu, true); });
	</ja:if>
	<ja:if test="${hasSidebar}">
	<%------------------------------- 
		Topnav toggle button
	-------------------------------%>
	const tb = document.getElementById('nav-toggle');
	if (tb) tb.onclick = (e) => {
		e.stopPropagation(); 
		tb.parentNode.classList.toggle('open'); 
		document.querySelector('aside').classList.toggle('nav-on'); 
		return false; 
	};
	<%------------------------------- 
		Preparing collapsible tree
	-------------------------------%>
	const cm = [ ...document.querySelectorAll('.collapsible .has-submenu') ];
	if (cm) cm.forEach(sm => {
		const cb = document.createElement('b');
		cb.classList.add('collbtn');
		cb.innerHTML = '\u203A'; //&#8250;
		sm.appendChild(cb);
		cb.onclick = (e) => {
			e.stopPropagation();
			const a = e.currentTarget.parentNode;
			if (a.classList.contains('collapsed')) a.classList.remove('collapsed');
			else  a.classList.add('collapsed');
		}
	});
	</ja:if>
	<%------------------------------- 
		Social sharing buttons for the index page
	-------------------------------%>
	<ja:if test="${hasShare}">
	let initShareLinks = function(el) {
			if (!el) return;
			el.childNodes.forEach(btn => {
				if (!IS_LOCAL) {
					if (btn.classList.contains('link')) {
						btn.onclick = (e) => {
							e.stopPropagation(); 
							copyCb(document.URL);
							return false;
						}
					} else {
						let href = btn.getAttribute('href');
						btn.setAttribute('href', href.replace('$PAGE_URL', encodeURI(document.URL)));
						if (!href.startsWith('mailto:')) {
							btn.onclick = (e) => {
								e.stopPropagation(); 
								openWindow(e.currentTarget.getAttribute('href'));
								return false;
							}
						}
					}
				} else {
					btn.onclick = (e) => {
						e.stopPropagation();
						alert('<%= getSafeText("cantShareLocalAlbum") %>');
						return false;
					}
				}
			});
		};
	initShareLinks(document.getElementById('social-buttons'));
	</ja:if>
	<%------------------------------- 
		Lazy loading thumbs
	-------------------------------%>
	document.addEventListener('DOMContentLoaded', function() {
		let imgs = document.querySelectorAll('.lazy');    
		if ('IntersectionObserver' in window) {
			let iobs = new IntersectionObserver(function(entries, observer) {
					entries.forEach(function(el) {
						if (el.isIntersecting) {
							setTimeout(load, 100, el);
						}
					});
				}),
				load = function(el) {
					if (el.isIntersecting) {
						const i = el.target;
						i.src = i.dataset.src;
						i.classList.remove('lazy');
						iobs.unobserve(i);
					}
				};
			imgs.forEach(function(i) {
				iobs.observe(i);
			});
		} else {  
			let llto,
				lazyload = function() {
					if (llto) {
						clearTimeout(llto);
					}    
					llto = setTimeout(function() {
						const st = window.pageYOffset;
						imgs.forEach(function(i) {
							if (i.offsetTop < (window.innerHeight + scrollTop)) {
								i.src = i.dataset.src;
								i.classList.remove('lazy');
							}
						});
						if(!imgs.length) { 
							document.removeEventListener('scroll', lazyload);
							window.removeEventListener('resize', lazyload);
						}
					}, 20);
				};
			document.addEventListener('scroll', lazyload);
			window.addEventListener('resize', lazyload);
		}
	});