/*
 *	init.js - initializing the skin, skin-specific utilities
 *	Author: Laza
 */
 
var JAFilter = Java.type("se.datadosen.jalbum.JAFilter"),
	FixedShapeFilter = Java.type("FixedShapeFilter"),
	Zip = Java.type(skin.toLowerCase().split(' ')[0] + ".Zip");
	
	// Undefined
	UNDEF = 'undefined';

 	// URL-encoding should be always on
	engine.setUrlEncode(true);
	
	// Zip library
	var zip = new Zip(engine);
	engine.setUsing(zip);
	
	// Making folder thumbs fixed shape
	if (fixedShapeThumbs || folderPlacement !== 'mixed') {
		engine.addFilter(new FixedShapeFilter(), JAFilter.FOLDERS_PRESCALE_STAGE);
	}
	
	// Directory chaning must be turned ON if afterLast is not "loop"
	var DirectoryChaining = Java.type("se.datadosen.jalbum.DirectoryChaining");
	if (afterLast !== 'loop' && engine.getDirectoryChaining().equals(DirectoryChaining.NO_CHAINING)) {	
		engine.setDirectoryChaining(DirectoryChaining.SIBLINGS);
	}
	
	// Reading custom keys
	if (typeof customKeys !== UNDEF) {
		getCustomTexts(customKeys);
	}
	
	// Icon themes
	pageIconTheme = isLightColor(pageBgColor)? 'dark' : 'light';
	sidebarIconTheme = isLightColor(sidebarBgColor)? 'dark' : 'light';
	secondaryIconTheme = isLightColor(secondaryBgColor)? 'dark' : 'light';
	
	// Icon
	icon_menu =	'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M22,3.5V5H2V3.5ZM2,13H22V11.5H2Zm0,8H22V19.5H2Z" fill="#eee" fill-rule="evenodd"/></svg>';
	icon_home =	'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M18.5,21H5.5V13h-4L12,2.5,22.5,13h-4ZM17,19.5v-8h1.88L12,4.62,5.12,11.5H7v8Z" fill="#eee"/></svg>';
	icon_up = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M14.75,19.5A3.75,3.75,0,0,1,11,15.75V6.37l5.12,5.12,1.06-1.06L10.25,3.5,3.32,10.43l1.06,1.06L9.5,6.37v9.38A5.26,5.26,0,0,0,14.75,21H22V19.5Z" fill="#eee"/></svg>';
	icon_prev =	'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><polygon points="23 11.25 4.87 11.25 12.93 3.19 11.87 2.13 2 12 11.87 21.87 12.93 20.81 4.87 12.75 23 12.75 23 11.25" fill="#eee"/></svg>';
	icon_next =	'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><polygon points="2 11.25 20.13 11.25 12.07 3.19 13.13 2.13 23 12 13.13 21.87 12.07 20.81 20.13 12.75 2 12.75 2 11.25" fill="#eee"/></svg>';
	icon_first = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><polygon points="23 11.25 9.87 11.25 15.93 5.19 14.87 4.13 7 12 14.87 19.87 15.93 18.81 9.87 12.75 23 12.75 23 11.25" fill="#eee"/><rect x="3" y="3" width="1.5" height="18" fill="#eee"/></svg>';
	icon_last =	'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><polygon points="1 11.25 14.13 11.25 8.07 5.19 9.13 4.13 17 12 9.13 19.87 8.07 18.81 14.13 12.75 1 12.75 1 11.25" fill="#eee"/><rect x="19.5" y="3" width="1.5" height="18" transform="translate(40.5 24) rotate(-180)" fill="#eee"/></svg>';
	
	icon_facebook =	'<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M9,.5A8.5,8.5,0,1,0,17.5,9,8.51,8.51,0,0,0,9,.5Zm1,15.93V10h2.22l.35-2H10V7a1.31,1.31,0,0,1,.12-.65c.08-.14.25-.2.52-.2h1.93V4H10.2a2.8,2.8,0,0,0-2.13.7,2.88,2.88,0,0,0-.65,2.06V8H6.18v2H7.42v6.33a7.51,7.51,0,1,1,2.57.1Z" fill="#333333"/></svg>';
	icon_twitter = '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M15.51,15.37,10.27,7.76,16.08,1H14.75L13.62,2.32,9.68,6.9,5.93,1.45,5.62,1H1L2.14,2.63l5,7.24L1,17H2.33l5.39-6.27,4,5.82L12,17h4.61ZM12.58,16,3,2H5.08L14.65,16Z" fill="#333333"/></svg>';
	icon_linkedIn = '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M7.5,4.5a1.41,1.41,0,0,0-.45-1,1.45,1.45,0,0,0-2.1,0,1.45,1.45,0,0,0,0,2.1,1.45,1.45,0,0,0,2.1,0A1.41,1.41,0,0,0,7.5,4.5ZM7,7H5v7H7Zm7,2.5a2.56,2.56,0,0,0-.66-1.77A2.06,2.06,0,0,0,11.75,7c-.56,0-1.15.42-1.75,1.25V7H8v7h2V10a1,1,0,0,1,.3-.7A.94.94,0,0,1,11,9a1,1,0,0,1,1,1v4h2ZM16,1a1,1,0,0,1,1,1V16a1,1,0,0,1-1,1H2a1,1,0,0,1-1-1V2A1,1,0,0,1,2,1H16m0-1H2A2,2,0,0,0,0,2V16a2,2,0,0,0,2,2H16a2,2,0,0,0,2-2V2a2,2,0,0,0-2-2Z" fill="#333333"/></svg>';
	icon_pinterest = '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M9.78,11.69a2.3,2.3,0,0,1-.56-.11,2.52,2.52,0,0,1-.59-.35l-.44-.29a16.56,16.56,0,0,1-.69,2.48A3.32,3.32,0,0,1,6.34,15a5,5,0,0,1-.06-1.77c.08-.69.17-1.23.25-1.59s.21-.86.38-1.5S7.19,9,7.25,8.63A2.76,2.76,0,0,1,7,7.25,2,2,0,0,1,7.59,6a1,1,0,0,1,1.19-.23.79.79,0,0,1,.55.7,2.74,2.74,0,0,1-.16,1.13L8.78,8.8a1.93,1.93,0,0,0-.06,1.08.84.84,0,0,0,.75.59A1.56,1.56,0,0,0,10.92,10a3.25,3.25,0,0,0,.89-1.55,5,5,0,0,0,.13-1.93A2.67,2.67,0,0,0,11.31,5,2.75,2.75,0,0,0,9.5,4.14a3.57,3.57,0,0,0-1.95.39A3.49,3.49,0,0,0,6.11,5.94a2.93,2.93,0,0,0-.39,2,2.27,2.27,0,0,0,.2.5c.1.16.17.3.24.4a1,1,0,0,1,.09.46A1.17,1.17,0,0,1,6,9.94C4.86,9.67,4.31,8.75,4.38,7.19a3.75,3.75,0,0,1,1.25-2.8A4.84,4.84,0,0,1,8.41,3.06a5.41,5.41,0,0,1,3.43.67,3.48,3.48,0,0,1,1.75,2.61,5.47,5.47,0,0,1-.81,3.82A3.09,3.09,0,0,1,9.78,11.69ZM9,0a9,9,0,1,0,9,9A9,9,0,0,0,9,0Zm8,9A8,8,0,1,1,9,1,8,8,0,0,1,17,9Z" fill="#333333"/></svg>';
	icon_reddit = '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M16.67,9.09a2,2,0,0,1-.86.75A3.53,3.53,0,0,1,16,11,4.25,4.25,0,0,1,14,14.53,8.24,8.24,0,0,1,9,16a8.24,8.24,0,0,1-4.95-1.47A4.25,4.25,0,0,1,2,11a3.53,3.53,0,0,1,.19-1.16,2,2,0,0,1-.86-.75,2,2,0,0,1,.25-2.51A1.91,1.91,0,0,1,3,6,1.85,1.85,0,0,1,4.75,7,8.4,8.4,0,0,1,8.31,6L9.94,2.38a.5.5,0,0,1,.69-.32l2.56.72A1.37,1.37,0,0,1,14.5,2a1.44,1.44,0,0,1,1.06.44A1.44,1.44,0,0,1,16,3.5a1.44,1.44,0,0,1-.44,1.06A1.44,1.44,0,0,1,14.5,5a1.43,1.43,0,0,1-.86-.28A1.55,1.55,0,0,1,13.09,4l-2.28-.66L9.59,6a8.73,8.73,0,0,1,3.66,1A1.86,1.86,0,0,1,15,6a2,2,0,0,1,2,2A1.92,1.92,0,0,1,16.67,9.09Zm-14-.15A5.16,5.16,0,0,1,3.91,7.56,1,1,0,0,0,3,7a.94.94,0,0,0-.7.3A1,1,0,0,0,2,8,.93.93,0,0,0,2.63,8.94ZM14.81,11a3.21,3.21,0,0,0-1.7-2.7A7.38,7.38,0,0,0,9,7.19,7.38,7.38,0,0,0,4.89,8.3,3.19,3.19,0,0,0,3.19,11a3.19,3.19,0,0,0,1.7,2.7A7.38,7.38,0,0,0,9,14.81a7.38,7.38,0,0,0,4.11-1.11A3.21,3.21,0,0,0,14.81,11ZM6,9a1,1,0,0,1,1,1,.94.94,0,0,1-.3.7A1,1,0,0,1,6,11a1,1,0,0,1-1-1,1,1,0,0,1,.3-.7A.94.94,0,0,1,6,9Zm3,3.81a3.27,3.27,0,0,1-2.06-.68A.64.64,0,0,0,6.52,12a.51.51,0,0,0-.39.21.57.57,0,0,0-.13.44.56.56,0,0,0,.22.39A4.33,4.33,0,0,0,9,14a4.33,4.33,0,0,0,2.78-.94.56.56,0,0,0,.22-.39.61.61,0,0,0-.12-.44.55.55,0,0,0-.4-.21.64.64,0,0,0-.42.11A3.27,3.27,0,0,1,9,12.81ZM12,9a1,1,0,0,1,1,1,.94.94,0,0,1-.3.7,1,1,0,0,1-.7.3,1,1,0,0,1-1-1,1,1,0,0,1,.3-.7A.94.94,0,0,1,12,9Zm1.94-5.5a.5.5,0,0,0,.17.39.55.55,0,1,0,.78-.78.53.53,0,0,0-.78,0A.5.5,0,0,0,13.94,3.5ZM16,8a1,1,0,0,0-1.91-.44,5.56,5.56,0,0,1,1.29,1.38A.94.94,0,0,0,16,8Z" fill="#333333"/></svg>';
	icon_email = '<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M9,1,1,5.5V16H17V5.5Zm6.15,4.61L9,8.87,2.85,5.61,9,2.15ZM16,15H2V6.29L9,10l7-3.71Z" fill="#333333"/></svg>';
	icon_link =	'<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M9.1,6.77a3.49,3.49,0,0,1,1.31,5.77L7.59,15.36a3.5,3.5,0,0,1-4.95-4.95L5.46,7.59l.15-.12a4.3,4.3,0,0,0,0,1.34L3.34,11.12a2.5,2.5,0,1,0,3.54,3.54l2.83-2.83a2.52,2.52,0,0,0,0-3.54,2.47,2.47,0,0,0-1.12-.63A1.45,1.45,0,0,1,9,6.88ZM9,11.12a1.45,1.45,0,0,0,.41-.78,2.47,2.47,0,0,1-1.12-.63,2.52,2.52,0,0,1,0-3.54l2.83-2.83a2.5,2.5,0,1,1,3.54,3.54L12.35,9.19a4.3,4.3,0,0,1,0,1.34,1.58,1.58,0,0,0,.15-.12l2.82-2.82a3.5,3.5,0,0,0-4.95-4.95L7.59,5.46A3.49,3.49,0,0,0,8.9,11.23Z" fill="#333333"/></svg>';

	// Has subfolders or a simple album
	albumHasFolders = JAlbumUtilities.countCategories(rootFolder, false).getCount(Category.folder) > 0;
	
	// Has sidebar
	hasSidebar = folderPlacement === 'sidebar' || pagePlacement === 'sidebar' || webLocationPlacement === 'sidebar';
	
	// Has top bar
	hasTopbar = folderPlacement === 'top' || pagePlacement === 'top' || webLocationPlacement === 'top';
	
	// Has sharing options
	hasShare = shareFacebook || shareTwitter || shareLinkedIn || sharePinterest || shareReddit || shareEmail || shareLink;
	shares = [ shareFacebook? 'facebook':'', shareTwitter? 'twitter':'', shareLinkedIn? 'linkedIn':'', sharePinterest? 'pinterest':'', shareReddit? 'reddit':'', shareEmail? 'email':'', shareLink? 'link':'' ].filter(Boolean).join(',');
	
	// Create a stripped album description for use in a meta tag
	strippedAlbumDescription = stripHTML(albumDescription);
	
	photodataTemplate = "# Creator & rights\n" +
		"Creator: xmp.dc:creator|photographer|artist|Artist|Owner|xmp.aux:OwnerName|Creator|Xmp.Author|Iptc.IIM/Creator\n" +
		"Credit: xmp.dc:credit|Credit|Iptc.IIM/CreditLine\n" +
		"Rights: xmp.dc:rights|rights|xmp.xmpRights:UsageTerms|Iptc.IIM/Usage Terms\n" +
		"Copyright: Copyright|Iptc.Copyright Notice|Iptc.IIM/CopyrightNotice\n" +
		"# Title\n" +
		"Title: xmp.dc:title|Xmp.Title|objectName|Iptc.IIM/ObjectName|Xmp.UserComment\n" +
		"Headline: xmp.photoshop:Headline|Headline|Iptc.IIM/Headline\n" +
		"# Description\n" +
		"Description: xmp.dc:description|ImageDescription|Xmp.Description|Xmp.Subject|Iptc.IIM/Caption/Abstract\n" +
		"Category: xmp.photoshop:Category|Category|Iptc.IIM/Category\n" +
		"# Keywords\n" +
		"Keywords: xmp.dc:subject|keywords|Iptc.IIM/Keywords\n" +
		"Identifier: xmp.dc:identifier|Xmp.Identifier\n" +
		"Label: Xmp.Label\n" +
		"# Location\n" +
		"Country: xmp.photoshop:Country|Country|Country/Primary Location|Country/Primary Location Name|Iptc.IIM/Country\n" +
		"State: xmp.photoshop:State|Province/State|Iptc.IIM/Province/State\n" +
		"City: xmp.photoshop:City|City|Iptc.IIM/City\n" +
		"Sub-location: Sub-location|Iptc.IIM/Sub-Location\n" +
		"# Camera\n" +
		"Date/Time: originalDate|Date/Time Original|Date/Time|CreateDate|ModifyDate\n" +
		"Make: Make\n" +
		"Model: Model|Camera\n" +
		"Lens: lens|Lens|Lens Model|Canon makernote.Lens Model|Xmp.Lens-Information|xmp.aux:Lens|Lens Specification\n" +
		"Focal length: focalLength35mm|focusDistance|Focal Length|Focallength\n" +
		"Distance: SubjectDistance\n" +
		"Metering mode: meteringMode|Metering Mode\n" +
		"ISO equivalent: isoEquivalent|ISO Speed Ratings\n" +
		"Exposure time: exposureTime|Exposure Time|Shutter Speed Value|ShutterSpeedValue\n" +
		"Aperture: Aperture Value|aperture|F-Number|FNumber|Aperturevalue\n" +
		"Exposure bias: Exposure Bias Value\n" +
		"Exposure program: Exposure Program|Exposureprogram|Exposure Mode\n" +
		"Scene type: Xmp.SceneType\n" +
		"White balance: White Balance|WhiteBalance\n" +
		"Color space: Xmp.ColorSpace\n" +
		"Light source: Xmp.LightSource\n" +
		"Flash: flash|Flash\n" +
		"Resolution: resolution\n";
		
	processFile('justify.js', 'res/justify.js');
	
	/* Initializing variables for CSS files */
	isMainLight = getLuminosity(pageBgColor) > 0.6;
	isSidebarLight = getLuminosity(sidebarBgColor) > 0.6;
	if (!useLineborder) {
		borderWidth = 0;
		borderPadding = 0;
		boxShadow = dropShadow? (isMainLight? '1px 3px 6px rgba(0,0,0,0.3)' : '1px 3px 6px rgba(0,0,0,0.6)') : 'none';
		cardBgColor = 'transparent';
		cardTextColor = textColor;
		cardLinkColor = accentColor;
		cardBoxShadow = 'none';
		cardBorderRadius = borderRounding? (borderRounding + 'px') : '0';
		borderRadius = cardBorderRadius;
	} else {
		boxShadow = 'none';
		cardBgColor = borderPadding? 'transparent' : borderColor;
		cardTextColor = borderPadding? textColor : getLegibleColor(borderColor, textColor, 0.6);
		cardLinkColor = borderPadding? accentColor : getLegibleColor(borderColor, accentColor, 0.6);
		cardBoxShadow = dropShadow? (isMainLight? '1px 3px 6px rgba(0,0,0,0.3)' : '1px 3px 6px rgba(0,0,0,0.6)') : 'none';
		cardBorderRadius = borderRounding? (borderRounding + 'px') : '0';
		borderRadius = borderRounding? (Math.max(borderRounding - borderPadding - borderWidth, 0) + 'px') : '0';
	}
	minThumbWidth = fixedShapeThumbs? Math.round(maxThumbWidth * .7) : maxThumbWidth;
	minThumbHeight = fixedShapeThumbs? Math.round(maxThumbHeight * .7) : maxThumbHeight;
	thumbboxWidth = minThumbWidth + 2 * (borderPadding + borderWidth);
	thumbnailsWidth = cols * (2 * thumbSpacing + thumbboxWidth) + 2 * contentPadding;
	maxPageWidth = fixedShapeThumbs? Math.min(thumbnailsWidth, 1280) : 1280;
	transparentText = setAlpha(secondaryTextColor, 0.25);
	accentTextColor = (getLuminosity(accentColor) > 0.6)? '#222222' : '#eeeeee';
	accentHoverTextColor = (getLuminosity(accentColor) > 0.6)? '#000000' : '#ffffff';
	linkColor = getLegibleColor(pageBgColor, accentColor, 0.6);
	hoverColor = getLegibleColor(pageBgColor, accentColor, 0.8);
	sidebarActualBg = isSidebarLight? 'rgba(0,0,0,.1)' : 'rgba(255,255,255,.15)';
	lightboxBg = getCssColor(setAlpha(lightboxBgColor, 1));
	lightboxBorder = getCssColor(lightboxBorderColor);
	if (isLightColor(lightboxBgColor)) {
		buttonBg = 'rgba(255,255,255,.35)';
		buttonColor = '#222222';
		buttonColorSec = 'rgba(34,34,34,.5)';
		buttonHoverBg = 'rgba(255,255,255,.75)';
		captionBg = 'rgba(255,255,255,.94)';
		captionColor = '#222222';
	} else {
		buttonBg = 'rgba(0,0,0,.25)';
		buttonColor = '#f4f4f4';
		buttonColorSec = 'rgba(244,244,244,.5)';
		buttonHoverBg = 'rgba(0,0,0,.75)';
		captionBg = 'rgba(16,16,16,.94)';
		captionColor = '#f4f4f4';
	}
	fontFamilyCss = (fontFamily.charAt(0) == '_')? ("'" + fontFamily.substring(1) + "',sans-serif") : fontFamily;
	boldWeight = Math.min(fontWeight + 300, 900);
	headlineFamilyCss = headlineFontFamily? ("'" + headlineFontFamily.split(':')[0] + "',sans-serif") : 'inherit';
	headlineWeight = (headlineFontFamily && headlineFontFamily.indexOf(':') !== -1)? headlineFontFamily.split(':')[1] : 'inherit';
	
	processFile('main.js', 'res/main.js');

	