<% // Newimages.htt skin specific part
	var thumbs = [],										// Thumbnails buffer
		dmax = newImagesDays * 24 * 60 * 60 * 1000,			// Difference in ms
		n = 0,
		start = (typeof skippedCount === 'undefined')? 0 : skippedCount,
		preload = (typeof preloadThumbs === 'undefined')? 20 : preloadThumbs,
		
		getTitle = function() {
				var s;
				
				switch (newImagesSource) {
					case 'dateTaken':
						s = getText('imagesTaken');
						break;
					case 'fileModified':
						s = getText('imagesModified');
						break;
					default:
						s = getText('imagesAdded');
				}
				
				return s + ' ' + getTimespan(newImagesDays); 
			},
		
		writeOutThumbnails = function() {

					//print('Writing out thumbs [' + thumbs.length + ']');

					out.print('\t\t\t\t\t\t<h2>' + getTitle() + '</h2>' +
						'<section class="cont thumb-cont"><div class="' +
							[ 	'thumbnails',
								thumbLayout,
								'caption-' + captionPlacement,
								(captionShowOnHover && captionPlacement !== 'below')? 'hover' : '',
								thumbGrayscaleEffect? 'grayscale' : '',
								(thumbs.length > 2)? 'wrap' : ''
							].filter(Boolean).join(' ') +
						'">');

					for (var i = 0; i < thumbs.length; i++) {
						var ao		= thumbs[i][0],
							vars 	= ao.getVars(),
							tp		= vars.get('thumbPath'),
							cp 		= vars.get('closeupPath'),
							tw		= parseInt(vars.get('thumbWidth')),
							th 		= parseInt(vars.get('thumbHeight')),
							alt 	= addAltTags? (' alt="' + stripHTML(vars.get('title')).trim() + '"') : '',
							c 		= vars.get('thumbCaption'),
							rp		= ao.getPathFrom(currentFolder),
							pano 	= ((tw / th) < 0.5)? ' pano' : '';
						
						if (checkProjectionType(ao) === 'equirectangular') {
							_anyVr = true;
						}

						rp = rp.substring(0, rp.length - ao.getName().length);
						
						out.print('<div class="card ' + 
								((i < preload)? 'preload' : 'lazyload') + 
								(c? ' hascaption' : '') + 
								pano + '"' + 
								' data-path="' + getEncodedPathFromRoot(ao) + '"' +
							'>' + 
								'<a class="thumb" href="' + rp + cp + '">' +
									((i < preload)? ('<img src="' + rp + tp + '"' + alt + ' width="' + tw + '" height="' + th + '">') : '') + 
								'</a>' + 
								(c? ('<div class="caption">' + c + '</div>') : '') +
							'</div>');
						
					}
					
					out.println('</div></section>');
				},
				
			sortThumbnails = function() {
				
					if (newImagesSort === 'date') {
						if (newImagesReverse) {
							thumbs.sort(function(a, b) {
									//print('a:'+a['refDate']+(a['refDate']>b['refDate']? '>':'<')+' b:'+b['refDate']);
									return  a[1] - b[1];
								});
						} else {
							thumbs.sort(function(a, b) {
									return  b[1] - a[1];
								});
						}
					} else if (newImagesSort === 'name') {
						if (newImagesReverse) {
							thumbs.sort(function(a, b) {
									return 	(b[0]['title']||b[0]['name']).localeCompare(a[0]['title']||a[0]['name']);
								});
						} else {
							thumbs.sort(function(a, b) {
									return 	(a[0]['title']||a[0]['name']).localeCompare(b[0]['name']||b[0]['name']);
								});
						}
					} else if (newImagesSort === 'random') {
						thumbs.sort(function() {
								return  0.5 - Math.random();
							});
					}
				},
				
			// Gathering new images		
			
			gatherNew = function(folder) {
				
					var images = folder.getChildren(),
						ao,
						cat,				// Category
						now = new Date(),
						d;
				
					for (var i = start; i < images.length; i++) {
	
						ao = images[i];
						
						if (ao.isIncluded()) {
							cat = ao.getCategory();
							//print(ao.getName() + ' [' + cat + ']');
		
							if (cat === Category.folder) {
								if (newImagesDepth !== 'current' && !ao.isHidden() && !getFolderView(ao)) {
									gatherNew(ao);
								}
							} else if (cat === Category.image || cat === Category.other ||
								cat === Category.audio || cat === Category.video) {
								
								if (newImagesSource === 'added') {
									d = ao.getWhenAdded();
								} else if (newImagesSource === 'dateTaken') {
									d = getEpochDate(ao, false);
								} else {
									d = ao.getLastModified();
								}
								
								if (d && (now - d) <= dmax) {
									thumbs.push([ao, d]);
								}
							}
						}
					}
				};
		
	if (newImagesDays) {
			
		gatherNew((newImagesDepth === 'tree')? rootFolder : currentFolder);
		
		if (newImagesSort !== 'original') {
			sortThumbnails();
		}
		
		writeOutThumbnails();
	}

%>