<%
	/* 
	 * sidebar.inc - sidebar blocks
	 */
	
	var cat = currentObject.getCategory();
	
	for each (block in sidebarOrder.split('\t')) {
		
		switch (block) {
			
			case 'tagCloud':
				
				if (cat === Category.folder && _useTagCloud && (tagCloudSource !== 'current' || itemCount > 0) && (tagCloudSource !== 'subfolders' || tagCloudSkipLevels <= level)) {
					//print('tagCloudLabel[' + (typeof tagCloudLabel) + ']="' + (tagCloudLabel || '(falseish)'));
					
					out.println(
						'\t\t\t\t\t\t<div class="box hide-on-overlay" id="tag-cloud">' +
							((tagCloudLabel === ' ')? '' : ('<h4 class="icon-tag"> ' + (tagCloudLabel || getText('ui.labels')) + '</h4>')) +
							((tagCloudSearch !== 'above')? '<div class="tag-cloud"></div>' : '') +
							((tagCloudSearch !== 'none')?
								('<form class="tag-search" data-depth="' + tagCloudSource + '" data-fields="' + tagCloudFields + '">' +
									'<div class="search-input"><label for="tag-search-inp" class="hidden">' + getText('search') + '</label><input id="tag-search-inp" type="text" placeholder="' + getText('searchPlaceholder') + '"></div>' +
									'<a class="search-btn icon-search" data-tooltip title="' + getText('search') + '"></a>' +
								'</form>') 
								: 
								''
							) +
							((tagCloudSearch === 'above')? '<div class="tag-cloud"></div>' : '') +
						'</div>'
					);
				}
				
				break;
				
			case 'folderTree':
				
				if (_useFolderTree && (folderTreeDepth === 'all' || (folderTreeDepth === 'blog' && level < blogDepth))) {
					
					out.println(
						'\t\t\t\t\t\t<div class="box hide-on-overlay" id="folder-tree">' +
							((folderTreeLabel === ' ')? '' : ('<h4 class="icon-site"> ' + (folderTreeLabel || getText('ui.folderTree')) + '</h4>')) +
							'<div class="folder-tree ' + (folderTreeCollapsible? 'collapsible' : 'plain') + '">' + getTree(rootFolder, true, false, false, 5, false, webLocationOpenNew) + '</div>' +
						'</div>'
					);
				}
				
				break;
				
			case 'filtering':
				
				if (cat === Category.folder && (typeof itemCount !== UNDEF) && itemCount > 1 && (_useFilters || _useSort)) {
					
					out.print('\t\t\t\t\t\t<div class="box filter-cont hide-on-overlay" id="filters">');
						
					if (_useFilters || _useSort) {
						var l;
						
						if (_useFilters) {
							l = filterLabel || getText('ui.filter');
						}
						
						if (_useSort) {
							l += (l.length? ' / ' : '') + (sortLabel || getText('ui.sort'));
						}
						
						out.print('<h4 class="icon-' + (_useFilters? 'filter' : 'ordering') + ' title"> ' +  l + '</h4>');
					}
					
					if (_useFilters) {
						out.print('<form class="filter"></form>');
					}
						
					if (_useSort) {
						out.print('<form class="sort"></form>');
					}
					
					out.println('</div>');
				}
				
				break;
				
			case 'searchNew':
				
				if (_useSearchNew && cat === Category.folder) {
					
					out.println(
						'\t\t\t\t\t\t<div class="box hide-on-overlay" id="search-new">' +
							((searchNewLabel === ' ')? '' : ('<h4 class="icon-new"> ' + (searchNewLabel || getText('ui.newImages'))  + '</h4>')) +
							'<div class="search-new"></div>' +
						'</div>'
					);
				}
				
				break;

			case 'zip':
			
				if (_useZip && cat === Category.folder && (typeof itemCount !== UNDEF) && itemCount) {
					
					var fn = currentFolder.getWebName();
					
					out.println(
							'\t\t\t\t\t\t<div class="box hide-on-overlay" id="download-box">' +
								((downloadLabel === ' ')? '' : ('<h4 class="icon-download"> ' + (downloadLabel || getText('ui.downloadImages')) + '</h4>')) +
								'<div class="download-links">' + 
									'<a href="' + fn + '.zip" class="small button" download>' + fn + '.zip</a>' +
								'</div>' +
							'</div>'
						);
				}
				
				break;
										
			case 'externalLinks':
				
				if (externalLinks) {
					
					var a = externalLinks.split('\n');
					
					if (a.length && a[0].length) {
						
						var btns = '';
						
						for (var i = 0, l, t; i < a.length; i++) {
							if (a[i]) {
								l = a[i].split('|');
								if (l.length > 1) {
									t = l[0];
									l = l[1];
								} else {
									t = shorten(l[0], 80);
									l = l[0];
								}
								btns += '<a href="' + l + '" target="_blank" class="small button">' + t + '</a>';
							}
						}
						
						out.println(
							'\t\t\t\t\t\t<div class="box hide-on-overlay" id="link-box">' +
								((externalLinksLabel === ' ')? '' : ('<h4 class="icon-external"> ' + (externalLinksLabel || getText('ui.links')) + '</h4>')) +
								'<div class="external-links">' + btns + '</div>' +
							'</div>'
						);
					}
				}
				
				break;
					
			case 'map':
				
				if (mapInSidebar && cat === Category.folder && (typeof locationCount !== UNDEF) && locationCount) {
					
					out.println(
						'\t\t\t\t\t\t<div class="map box hide-on-overlay" id="map-box">' +
							((indexMapLabel === ' ')? '' : ('<h4 class="icon-location"> ' + (indexMapLabel || getText('ui.map')) + '</h4>')) +
							'<div class="map-root" data-map></div>' +
						'</div>'
					);
				}
				
				break;
				
			case 'shop':
				
				if (_useShop && cat === Category.folder && (!showShopOnImagePagesOnly || (typeof shopCount !== UNDEF) && shopCount)) {
					
					out.println(
						'\t\t\t\t\t\t<div class="shop box" id="shop-box">' +
							((shopLabel === ' ')? '' : ('<h4 class="icon-shopping-cart"> ' + (shopLabel || getText('ui.shop')) + '</h4>')) +
							'<div class="select-box">' + getText('select') + ' ' +
								'<a class="icon-ok small button select-all"> ' + getText('all') + '</a>' +
								'<a class="icon-close small button select-none"> ' + getText('none') + '</a>' +
							'</div>' +
							'<p><a class="icon-filter small button keep-selected"> ' + getText('keepOnlySelected') + '</a></p>' +
							'<div id="shop-root"></div>' +
							(shopInstructionsBox? ('<div class="instructions">' + shopInstructionsBox + '</div>') : '') +
						'</div>'
					);
				}
				
				break;

			case 'feedback':
				
				if (_useFeedback && cat === Category.folder && (typeof itemCount !== UNDEF) && itemCount) {
					
					out.println(
						'\t\t\t\t\t\t<div class="feedback box" id="feedback">' +
							((feedbackLabel === ' ')? '' : ('<h4 class="icon-email-send"> ' + (feedbackLabel || getText('feedback')) + '</h4>')) +
							'<div class="select-box">' + getText('select') + ' ' +
								'<a class="icon-ok small button select-all"> ' + getText('all') + '</a>' +
								'<a class="icon-close small button select-none"> ' + getText('none') + '</a>' +
							'</div>' +
							'<p><a class="icon-filter small button keep-selected"> ' + getText('keepOnlySelected') + '</a></p>' +
							'<div id="feedback-root"></div>' +
							(feedbackInstructionsBox? ('<div class="instructions">' + feedbackInstructionsBox + '</div>') : '') +
						'</div>'
					);
				}
				
				break;

			case 'facebookBox':
				
				if (_useFacebookBox && level < blogDepth) {
					
					out.println(
						'\t\t\t\t\t\t<div class="box hide-on-overlay" id="facebook-box">' +
							(facebookLabel? ('<h4 class="icon-facebook"> ' + facebookLabel + '</h4>') : '') +
							'<div class="fb-page" data-href="https://www.facebook.com/' + facebookPageId +
							'" data-small-header="true" data-adapt-container-width="true" data-hide-cover="false" data-show-facepile="true" data-show-posts="false"><div class="fb-xfbml-parse-ignore"><blockquote cite="https://www.facebook.com/' + facebookPageId + 
							'"><a href="https://www.facebook.com/' + facebookPageId + '">' + facebookPageId + '</a></blockquote></div></div>' +
						'</div>'
					);
				}
				
				break;
				
			case 'twitterBox':
				
				if (_useTwitterBox && level < blogDepth) {
					out.println(
						'\t\t\t\t\t\t<div class="box hide-on-overlay" id="twitter-feed">' +
							(twitterLabel? ('<h4 class="icon-twitter"> ' + twitterLabel + '</h4>') : '') +
							_twitterCode + 
						'</div>'
					);
				}
				
				break;
			
			case 'instagramBox':
				
				if (_useInstagramBox && level < blogDepth) {
					out.println(
						'\t\t\t\t\t\t<div class="box hide-on-overlay" id="instagram-feed">' +
							(instagramLabel? ('<h4 class="icon-instagram"> ' + instagramLabel + '</h4>') : '') +
							'<div id="instafeed"></div>' +
						'</div>');
				}
				
				break;
			
			
			case 'customContent':
				
				if (sidebarHook && sidebarHook.trim()) {
					out.println(
						'\t\t\t\t\t\t<div class="custom box">' + getProcessed(sidebarHook) + '</div>'
					);
				}
				
				break;
		}
	}
%>