/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package photoblogger;

import icons.Lazaicon;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import se.datadosen.component.JPlainButton;
import se.datadosen.jalbum.Icons;
import se.datadosen.util.SmartResourceBundle;

/**
 * JPanel embedding a JTable containing three columns: "Label", "Variable name" and "Type" along with + and - buttons to
 * add and delete rows Install it's embedded JTable component in a skin UI class to automatically have the data
 * persisted on jAlbum 18.3 and onwards
 *
 * @author david
 */
public class JVariablesPanel extends JPanel {
	
	private VariablesTableModel model = new VariablesTableModel();
	private JTable table = new JTable(model);
	private float opacity = 1.0f;
	
	public static Icon svgIcon(String basename) {
		return Icons.get(Lazaicon.class, "svg/" + basename + ".svg", 18);
	}
	
	private final Action addRowAction = new AbstractAction("Add", svgIcon("plus")) {
		@Override
		public void actionPerformed(ActionEvent e) {
			int row = model.getRowCount();
			model.addRow();
			table.getSelectionModel().setSelectionInterval(row, row);
			table.editCellAt(row, 0);
			table.requestFocusInWindow();			
		}		
	};
	
	private final Action deleteRowAction = new AbstractAction("Remove", svgIcon("minus")) {
		@Override
		public void actionPerformed(ActionEvent e) {
			int row = table.getSelectedRow();
			if (row != -1) {
				model.deleteRow(row);
				row--;
				if (row < 0) {
					row = 0;
				}
				table.getSelectionModel().setSelectionInterval(row, row);
			}
		}		
	};
	
	private final Action moveRowUpAction = new AbstractAction("Move up", svgIcon("arrow-up")) {
		@Override
		public void actionPerformed(ActionEvent e) {
			int row = table.getSelectedRow();
			if (row > 0) {
				model.moveRowUp(row);
				table.requestFocusInWindow();
				table.getSelectionModel().setSelectionInterval(row - 1, row - 1);
			}	
		}		
	};
	
	private final Action moveRowDownAction = new AbstractAction("Move down", svgIcon("arrow-down")) {
		@Override
		public void actionPerformed(ActionEvent e) {
			int row = table.getSelectedRow();
			if (row >= 0 && row < (table.getRowCount() - 1)) {
				model.moveRowDown(row);
				table.requestFocusInWindow();
				table.getSelectionModel().setSelectionInterval(row + 1, row + 1);
			}
		}		
	};
		
	public JVariablesPanel(SmartResourceBundle texts) {
		super(new BorderLayout());
		JComboBox<DataType> dataType = new JComboBox(DataType.values());
		String[] translatedColNames = { texts.getString("ui.label"), texts.getString("ui.variableName"), texts.getString("ui.type") };
		model.setColumnNames(translatedColNames);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(dataType));
		table.setPreferredScrollableViewportSize(new Dimension(300, 160));
		table.getTableHeader().setFont(table.getTableHeader().getFont().deriveFont(table.getTableHeader().getFont().getSize2D() + 1));
		table.setFont(table.getFont().deriveFont(table.getFont().getSize2D() + 1));
		table.setRowHeight(table.getRowHeight() + 8);
		add(new JScrollPane(table));
		JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.LEADING));
		add(buttonPanel, BorderLayout.SOUTH);
		buttonPanel.add(new JPlainButton(addRowAction));
		buttonPanel.add(new JPlainButton(deleteRowAction));
		buttonPanel.add(new JPlainButton(moveRowUpAction));
		buttonPanel.add(new JPlainButton(moveRowDownAction));
	}

	public JTable getTable() {
		return table;
	}
	
	public void setDimensions(Dimension d) {
		table.setPreferredScrollableViewportSize(d);
	}
	
	@Override
    protected void paintChildren(Graphics g) {
        Graphics2D g2 = (Graphics2D) g.create();
        g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, opacity));
        super.paintChildren(g2);
        g2.dispose();
    }
	
	@Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        table.setEnabled(enabled);
        table.getTableHeader().setEnabled(enabled);
        opacity = enabled ? 1.0f : 0.5f;
        repaint();
    }
		
}
