;(function($, $window, $html, $body) {
	'use strict';
				
	/* 
		scrollTopBtn.js - add a "scroll to top" button
	*/

	$.fn.scrollToTopBtn = function() {
		
			var text = getTranslations({
							scrollTopTooltip:				"Scroll to top"
						}),
			
				btn = $('<a>', {
							'class': 			'scrollup icon-arrow-up',
							role:				'button',
							title:				text.scrollTopTooltip
						}).appendTo($(this).eq(0));
				
			$window.on('scroll', function() { 
					btn.toggleClass('show', $window.scrollTop() > 16)
					return true;
				});
			
			btn.on('click', function() {
					if ($(this).hasClass('show')) {
						var target = $html.scrollTop()? $html : $body;
						
						target.animate({ 
								scrollTop: 		0 
							}, 500);
						
						return false;
					}
				});
			
			btn.addTooltip({
					pos: 	[ 2, 1, 0, 1 ]
				});
			
			return this;
		};
	
}(jQuery, jQuery(window), jQuery('html'), jQuery('body')));