/*
 * newsfeed reader
 * using Google library
 */

var Newsfeed = (function($) {
	'use strict';
	
	var div,
		curr,
		max,
		entries = [],
		settings = {
			count: 3,
			description: true
		};

	var sortNewsfeed = function() {
		
		for (var i = 0, l = entries.length; i < l; i++) {
			entries[i].date = new Date(entries[i].publishedDate);
		}
		entries.sort(function(a, b) {
			return b.date - a.date;
		});
	};
	
	var renderNewsfeed = function() {
		
		var u = $('<ul>', {
			'class': 'newsfeed'
		});
		var e, li;
		for (var i = 0, l = entries.length; i < l; i++) {
			e = entries[i],
			li = $('<li>').appendTo(u);
			li.append($('<a>', {
				href: e.link,
				target: '_blank',
				html: e.title
			}));
			if (settings.description) {
				if (e.hasOwnProperty('contentSnippet')) {
					li.append($('<span>', {
						html: e.contentSnippet
					}));
				} else if (e.hasOwnProperty('content')) {
					li.append(e.content);
				}
			}
			li.append($('<span>', {
				'class': 'pdate',
				text: e.date.toLocaleString()
			}));
		}
		div.append(u);
	};
	
	var getEntries = function(r) {
		
		if (!r.error) {
			entries = entries.concat(r.feed.entries);
		}
		curr++;
		nextFeed();
	};
	
	var nextFeed = function() {
		
		if (curr < max) {				
			var f = new google.feeds.Feed(settings.feeds[curr]);
			f.setNumEntries(settings.count);
			f.load(getEntries);
		} else if (div.is(':empty')) {
			sortNewsfeed();
			renderNewsfeed();
		}
	};

	var init = function(set) {
		
		var tries = 20;
		
		$.extend(settings, set);
		div = $(settings.hook);
		curr = 0;
		max = (settings.hasOwnProperty('feeds') && Array.isArray(settings.feeds))? settings.feeds.length : 1;
		
		if (!div.length || !settings.hasOwnProperty('feeds')) {
			return;
		}
		
		var loadFeeds = function() {
			if (typeof google === 'undefined') {
				if (--tries) {
					setTimeout(loadFeeds, 100);
				}
			} else {
				google.load('feeds', '1', {
					callback: nextFeed
				});
			}
		};
		
		loadFeeds();
	};
	
	
	return {
		init: init
	}
	
}(jQuery));
