/*	
 *	dropdownMenu() :: operates the dropdown menu on mobiles
 *
 *	Copyright by Lazaworx
 *	http://www.lazaworx.com
 *	Author: Laszlo Molnar
 *
 *	Dual licensed under the MIT and GPL licenses.
 *	- http://www.opensource.org/licenses/mit-license.php
 *	- http://www.gnu.org/copyleft/gpl.html
 *
 *	Usage: $(element).dropdownMenu(options);
 *	options:
		openMenuClass: 	'opened'
 */

;(function($, $body) {
	'use strict';
	
	$.fn.dropdownMenu = function(settings) {
		
			settings = $.extend({}, $.fn.dropdownMenu.defaults, settings);
			
			return this.each(function() {
					var self = $(this),
						ns = '_ldm_' + Math.floor(Math.random()*10000),
						lastDate = new Date(),
						
						doAnimations = function(el, close) {
								var toHide = $(),
									toShow = $(),
									p = el.parents('.' + settings.openMenuClass);			// Parent(s): do not hide them
							
								if (close) {
									p = p.slice(1);
								}
								
								self.find('.' + settings.openMenuClass).not(p).each(function() {
										var menu = $(this).find('.' + settings.menuClass);
										
										if (menu.length) {
											if (!menu.data('height')) {
												menu.data('height', settings.fixed? Math.min(window.innerHeight - menu.offset().top, menu.outerHeight()) : menu.outerHeight());
											}
											toHide = toHide.add(menu);
										}
										
										$(this).removeClass(settings.openMenuClass);
									});
								
								toHide.on('transitionend.' + ns, function() {
										$(this).css({
											display: 		'none',
											transition:		'none'
										});
									})
									.css({
										overflow:		'hidden'
									});
								
								if (!close) {
									// No menu to show
									p = el.parent();
									
									if (!p.hasClass(settings.openMenuClass)) {
										// Not open yet
										toShow = p.children('.' + settings.menuClass);
								
										if (toShow.length) {
											if (!toShow.data('height')) {
												// No height yet: show invisibly to get height
												toShow.css({
														'display':		'flex',
														'visibility':	'hidden'
													});
												
												toShow.data('height', settings.fixed? Math.min(window.innerHeight - toShow.offset().top, toShow.outerHeight()) : toShow.outerHeight());
											}
										}
									
										p.addClass(settings.openMenuClass);
									}
									
									toShow.parents('.' + settings.menuClass).css({
											maxHeight:		'none'
										});
									
									toShow.on('transitionend.' + ns, function() {
											$(this).css({
												display:		'flex',
												overflow:		'visible'
											});
										})
										.css({
											maxHeight:		0,
											display:		'flex',
											overflow:		'hidden',
											visibility:		'visible'
										});
								}
									
								window.requestAnimationFrame(function() {
										toHide.css({
												transition:		'max-height 500ms ease-out',
												maxHeight:		0
											});
										
										toShow.css({
												transition:		'max-height 500ms ease-out',
												maxHeight:		toShow.data('height') || '100vh'
											});
									});
							};
							
					// Starts here		
					self.find('.' + settings.hasDropdownClass + '> a').each(function() {
							$(this)
								.on('click.' + ns, function(e) {
										if (/*lastEvt === TOUCH.START && */ 
											((new Date() - lastDate) > 300)) {
											var el = $(this),
												arrowClick = (getCoords(e).x - el.offset().left) > (el.outerWidth() - 32),
												open = el.parent().hasClass(settings.openMenuClass);
											
											if (!open || arrowClick) {
											
												e.stopImmediatePropagation();
												lastDate = new Date();
												window.requestAnimationFrame(function() {
														doAnimations(el, arrowClick && open);
													});
												return false;
											}
										}
										
										return true;
									});
						});
				});		
								
		};
		
	$.fn.dropdownMenu.defaults = {
			hasDropdownClass:		'has-submenu',
			menuClass:				'menu',
			openMenuClass: 			'opened',
			fixed:					false
		};
	
})(jQuery, $('body'));
