/*jslint browser: true*/
;(function($, window, document, undefined) {
	'use strict';
	
	/*
	 *	Open Street Maps interace
	 *	canvas is a jQuery element with data('location') and other optional parameters
	 */

			
	$.fn.addMap = function(settings) {
		
		settings = $.extend({}, $.fn.addMap.defaults, settings);
		
		var normalPin = L.icon({
					iconUrl:		[ settings.resPath, 'normalpin.png' ].join('/'),
					iconSize:		[ 24, 30 ],
					iconAnchor:		[ 12, 30 ],
					shadowUrl:		[ settings.resPath, 'pinshadow.png' ].join('/'),
					shadowSize:		[ 30, 30 ],
					shadowAnchor:	[ 12, 30 ]
				}),
			activePin = L.icon({
					iconUrl:		[ settings.resPath, 'activepin.png' ].join('/'),
					iconSize:		[ 24, 30 ],
					iconAnchor:		[ 12, 30 ],
					shadowUrl:		[ settings.resPath, 'pinshadow.png' ].join('/'),
					shadowSize:		[ 30, 30 ],
					shadowAnchor:	[ 12, 30 ]
				});
			
		return this.each(function() {

				var canvas 			= 	$(this),								// Map root
					ns				=	canvas.data('map_ns');					// Namespace 
				
				if (typeof ns !== UNDEF) {
					// Already instantitated
					return;
				}
				
				canvas.data('map_ns', ns = 'map_' + Math.floor(Math.random() * 10000));
				if (!this.id) {
					this.id = ns;
				}

				var	options 		= $.extend({}, settings, readData(canvas, 'location,type,zoom,label,markers,overlay,current')),
					map,
					marker 			= [],
					active 			= -1,
					bounds,
					hasBounds		= false,
					boundsApplied 	= false,
					
					// Gets a marker by its name
					
					getMarkerByName = function(n) {
						
							for (var i = 0; i < marker.length; i++) {
								if (marker[i]['link'] === n) {
									return i;
								}
							}
							
							return -1;
						},
					
					// Sets a marker as active
					
					setActive = function(e, n) {
							var n = (typeof n === UNDEF)? -1 : (typeof n === NUMBER)? n : getMarkerByName(n);
							//console.log('setActive(' + n + ')');
							if (n !== active) {
								
								if (active >= 0) {
									// Resetting the active
									marker[active].setIcon(normalPin);
								}
								
								if (n >= 0 && n < marker.length) {
									// Setting the new
									marker[n].setIcon(activePin);
								}
								
								active = n;
							}
						},
					
					// Refreshing map, if it was rendered on a hidden layer
					
					refresh = function() {
							
							if (options.fitBounds && hasBounds && !boundsApplied) {
								fitBounds();
							}
							
							if (active !== -1) {
								map.setView(marker[active].getLatLng());
							}
						},
						
					// Fits map into bounds
					
					fitBounds = function() {
							if (canvas.is(':visible')) {
								map.fitBounds(bounds);
								boundsApplied = true;
							}
						},
						
					// Reset marker animations
					
					resetMarkers = function() {
						
							if (marker && marker.length) {
								
								if (active >= 0) {
									marker[active].setIcon(normalPin);
									active = -1;
								}
							}
							
							if (options.fitBounds && hasBounds) {
								fitBounds();
							} else if (marker && marker.length) {
								map.setView(marker[0].getLatLng());
							}
						},
								
					// Marker clicked event
						
					markerClicked = function() {
						
							if (marker && marker.length) {
								
								if (active >= 0) {
									marker[active].setIcon(normalPin);
									active = -1;
								}
								
								this.setIcon(activePin);
							}
							
							if (typeof options.onMarkerClick === FUNCTION) {
								options.onMarkerClick.call(this);
							}
						},
						
					// Loading script

					initMap = async function() {
							
							if (options.autoLoad) {
								renderMap();
							}
							
							canvas.on('render', renderMap);
						},
						
					// Load overlay(s)
					
					loadOverlays = function(overlays, doneFn) {
							var xhr = new XMLHttpRequest();
							
							xhr.open('GET', overlays[0], true);
							
							xhr.onreadystatechange = function () {
								
									if (xhr.readyState === 4 && xhr.status === 200) {
										// Parse GPX data track points
										var points = xhr.responseXML.getElementsByTagName('trkpt'),
											path = [];
										
										for (var i = 0; i < points.length; i++) {
											path.push([ parseFloat(points[i].getAttribute('lat')), parseFloat(points[i].getAttribute('lon'))]);
										}
										
										if (path.length) {
											// Create a polyline and set its path
											 var polyline = L.polyline(path, { 
											 		color: 			'#FF0000',
											 		weight:			3
											 	}).addTo(map);

											// Fit the map bounds to the polyline
											map.fitBounds(polyline.getBounds());
										}
										
										if (overlays.length > 1) {
											// Next overlay
											loadOverlays(overlays.slice(1), doneFn);
										} else {
											// Overlays rendered, call doneFn
											if (typeof doneFn === FUNCTION) {
												doneFn.call(null);
											}
										}
									}
								};
								
							xhr.send();
						},

					// Rendering map
				
					renderMap = function() {
							
							if (canvas.data('rendered')) {
								return;
							}
							
							var	delay = 10,
								markerTo = null,
								hiddenEl,
							
								// Adding markers one-by-one with delay
								addMarker = function(i) {
										
										clearTimeout(markerTo);
										
										if (i < options.markers.length) {
											
											if (options.markers[i].hasOwnProperty('latLng')) {
												marker[i] = L.marker(options.markers[i]['latLng'], {
														icon: 		normalPin,
														title:		options.markers[i].hasOwnProperty('title')? options.markers[i]['title'] : ''
													}).addTo(map);
					
												if (options.markers[i].hasOwnProperty('link')) {
													marker[i].link = options.markers[i]['link'];
													marker[i].on('click', markerClicked);
												}
											}
											
											// Calling the next with delay
											markerTo = setTimeout(addMarker, delay, i + 1);
											
										} else {
											// All markers added
											// Fit bounds if more than 1 marker
											if (options.markers.length > 1) {
												fitBounds();
											}
										}
									},
									
								// Prepare markers, fit bounds or center map 
								setMarkers = function() {
										if (options.hasOwnProperty('markers')) {
											// Delay: used to delay between dropping pins
											delay = Math.minMax(10, Math.round(1000 / options.markers.length), 100);
											
											if (options.markers.length > 1) {
												// Only if more than 1 marker
												for (var i = 0; i < options.markers.length; i++) {
													bounds.extend(options.markers[i].latLng);
												}
												hasBounds = true;
												map.fitBounds(bounds);
											} else {
												map.setZoom(options.zoom);
												map.setView(options.markers[0]['latLng']);
											}
											
											addMarker(0);
										}
								
									};
							
							// Creating boundaries array
							bounds = L.latLngBounds();
							
							// Check if target layer is hidden; unhide hidden parents
							hiddenEl = canvas.parents(':hidden');
							if (canvas.is('hidden')) {
								hiddenEl.add(canvas);
							}
							hiddenEl.each(function() {
									$(this).data('saveCss', { 
											display:	$(this).css('display')
										});
									$(this).css({ 
											display:	'block'
										});
								});
							
							setTimeout(function() {
								// Creating Map
								map = new L.Map(canvas[0], {
											scrollWheelZoom: 		options.enableScrollWheel,
											zoomControl: 			options.zoomControl
										});
								
								L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
										attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a>'
									}).addTo(map);
								
								// Initializing markers
								if (options.hasOwnProperty('markers')) {
									// Converting old "pos" property into "latLng"
									for (var i = 0, ll; i < options.markers.length; i++) {
										if (options.markers[i].hasOwnProperty('pos') && !options.markers[i].hasOwnProperty('latLng')) {
											ll = options.markers[i].pos.split(',');
											options.markers[i].latLng = {
													lat:	parseFloat(ll[0]),
													lng:	parseFloat(ll[1])
												};
										}
									}
									
								} else if (options.hasOwnProperty('location')) {
									// No markers: single locations
									var ll = options.location.split(',');
									options.markers = [{ 
											latLng: { 
													lat:	parseFloat(ll[0]),
													lng:	parseFloat(ll[1])
												}
										}];
										
								} else if (!options.hasOwnProperty('overlay')) {
									// No location and no overlay => set center to 0, 0
									console.log('Error in AddMap: Nothing to display on the map!');
									options.markers = [{ 
											latLng: { 
													lat: 	0, 
													lng: 	0 
												}
										}];
								}
								
								if (options.hasOwnProperty('overlay')) {
									// Loading overlay(s), then add markers
									loadOverlays(options.overlay.split(','), setMarkers);
								} else if (options.markers) {
									// Start adding markers immediately
									setMarkers();
								}
								
								if (hiddenEl) {
									// Restore hidden elements
									hiddenEl.each(function() {
											$(this).css($(this).data('saveCss'));
										});
								}
									
								canvas.data('rendered', true);
								
								// External triggers
								canvas.on({
										setActive: 		setActive,
										resetMarkers:	resetMarkers,
										refresh:		refresh
									});
								
								if (typeof doneFn === FUNCTION) {
									doneFn.call(null);
								}
							}, 20);
						};
				
				// Loading script
				
				initMap();
				
			});
		
		};
					
	$.fn.addMap.defaults = {
			zoom:					15,
			fitBounds:				true,
			zoomControl:			true,
			enableScrollWheel:		true,
			autoLoad:				true
		};
	
})(jQuery, window, document);
