<%--------------------------------

			Content

--------------------------------%><%

	var	getFolderThumb = function(ao) {
				var vars = ao.getVars(),
					s;

				// Iconpath => SVG, folder thumb path
				if (s = vars.get('iconPath')) {
					s = s.replace('folder.png', defaultFolderIconName);
					return s.replace(/^\.\.\//, '');
				} else {
					return createFolderThumb(ao, folderThumbSize, true);
				}
			},
			
		getNewImagesContent = function(ao) {
				var vars = ao.getVars(),
					t = vars.get('fileTitle'),
					d;
				
				d = {
						fn:				'collectByDate',
						start:			today - (vars.get('newImagesDays') || 30),
						depth:			vars.get('newImagesDepth') || 'tree',
						sortBy:			vars.get('newImagesSort') || 'date',
						reference:		vars.get('newImagesSource') || 'dateTaken',
						reverse:		vars.get('newImagesReverse') || false,
						linkMore:		vars.get('closeupPath')
					};
				
				return (t? ('<h3>' + t + '</h3>') : '') + 
					'<div class="new-images single-row" data-jalbum-query=\'' + JSON.stringify(d) + '\'></div>';
			},
			
		getMosaic = function(folder, cp) {
				// Mosaic
				var rao = folder.getRepresentingAlbumObject(),
					imgs = getRandomChildren(folder, 3, 'image,video,folder,webLocation', true, rao? rao.getName() : null),
					sb = '',
					co = getCountObj(folder, false),
					ti = (typeof co !== UNDEF)? (co.image + co.audio + co.video) : 0;
					
				if (imgs.length >= 1) {
					
					for (var i = 0, ic, tp, cat, vars, l = imgs.length; i < l; i++) {
						vars = imgs[i].getVars();
						
						if (vars) {
							cat = imgs[i].getCategory();
							
							if (cat === Category.folder && vars.get('iconPath')) {
								// No folder thumbnail
								tp = resPath + '/' + defaultFolderIconName;
								ic = 'icon ';
							} else {
								//print(imgs[i] + ' thumbPath="' + getThumbPath(imgs[i]) + '"');
								tp = getThumbPath(imgs[i]);
								ic = '';
							}
							
							sb += '<a href="' + cp +
									((cat === Category.folder || cat === Category.webLocation || i === l - 1)? '' : ('#img=' + imgs[i].getWebName())) + 
									'"' + 
									ask + 
									' class="' + ic + ((i >= preloadThumbs)? 'lazyload" data-src="' : 'preload">' +
										'<img src="') + tp + '"' + 
											(addAltTags? (' alt="' + [ stripHTML(vars.get('title'), shorten(vars.get('comment'), 120, true)).trim() ].filter(Boolean).join(' ') + '"') : '') + 
										'>' + 
								((i === l - 1)? ('<span>+' + ((ti > imgs.length)? ('<small>' + (ti - imgs.length) + '</small>') : '') + '</span>') : '') +
							'</a>';
						}
					}
				}
				
				return sb? ('<div class="mosaic">' + sb + '</div>') : '';
			},
			
		getPageThumbnail = function(ao) {
				var vars = ao.getVars(),
					s,
					c;
					
				s = '<h4><a class="icon-' + getPageIcon(ao) + '" href="' + vars.get('closeupPath') + '"> ' + vars.get('title') + '</a></h4>';
				
				if (showPages === 'excerpt') {
					c = vars.get('aboutText') || vars.get('comment');
					
					if (c) {
						var i = c.indexOf('<!--more-->'); 
						s += '<div class="caption">' +
								((i > 0)? c.substring(0, i) : shorten(c)) +
							'</div>';
					}
				}
				
				return '<div class="card ' + captionPlacement + '">' + s + '</div>';
			};
		
	/******************************************************************
	 *
	 *						Main Content
	 *
	 ******************************************************************/
	
	for each (section in sectionsOrder.split('\t')) {
		
		switch (section) {
			
			case 'folders':
				
				var folders = getChildrenOfType(currentFolder, 'folder' + (hideWeblocations? '' : ',webLocation'));
				
				if (folders.length) {
					
					var vars,
						c,
						cp,
						ip,
						tp,
						ftw = folderThumbDims.split('x')[0],
						fth = folderThumbDims.split('x')[1],
						rao,
						icon,
						alt,
						ask,
						wl;
					
					out.print('\t\t\t\t\t\t<section class="folder-cont hide-on-overlay"><div class="cont folders">');
						
					for (var i = 0; i < folders.length; i++) {
						
						vars = folders[i].getVars();
						c = vars.get('thumbCaption');
						cp = getExternalLink(vars) || vars.get('closeupPath');
						ip = vars.get('iconPath');
						view = vars.get('folderViewName') || '';
						tp = vars.get('folderThumbPath') || vars.get('thumbPath');
						alt = addAltTags? (stripQuot(stripHTML(vars.get('title') + ' ' + shorten(vars.get('comment'), 120, true))).trim()) : '';
						ask = vars.get('askPermission');
						wl = folders[i].getCategory() === Category.webLocation;
						mosaic = '';
						
						// Mosaic
						if (i < enhanceFolderCnt) {
							mosaic = getMosaic(folders[i], cp);
						}
						
						if (ip || !tp) {
							tp = resPath + '/' + defaultFolderIconName;
						}
						
						if (!fixedShapeFolderThumbs) {
							// Variable folder thumb dimensions
							ftw = vars.get('folderThumbWidth');
							fth = vars.get('folderThumbHeight');
						}
						
						cnt = showFolderImageCount? (vars.get('counts') || '') : '';
						ask = (ask !== null)? (' data-ask-permission=\'' + ask.replace(/'/g, '&apos;') + '\'') : '';		//'
						
						// Card
						out.print('\t\t\t\t\t\t<div class="' + 
									[	'card',
										'folder',
										folderCaptionPlacement,
										(i < preloadThumbs)? 'preload' : 'lazyload',
										(i < enhanceFolderCnt)? 'enhance' : '',
										(mosaic && mosaic.length)? 'hasmosaic' : 'nomosaic',
										(folders[i] instanceof VirtualFolder)? ('view ' + getFolderView(folders[i])) : '',
										wl? 'webloc' : ''
									].filter(Boolean).join(' ') +  
								'">');
							// Thumbnail image
							out.print('<a href="' + cp + '" class="thumb' + (ip? ' icon' : '') + '"' + 
									ask + 			
									// Open in new tab?
									((wl && webLocationOpenNew)? ' target="_blank"' : '') + 
									// Passing along thumbPath and alt for lazy loaded folders
									((i >= preloadThumbs)?
										(' data-src="' + tp + '"' + (alt? (' data-alt="' + alt + '"') : '') + 
											' data-width="' + ftw + '" data-height="' + fth + '">'
										)
										: 
										('><img src="' + tp + '"' + (alt? (' alt="' + alt + '"') : '') + 
											' width="' + ftw + '" height="' + fth + '">'
										)
									) +
								'</a>');
						
						if (mosaic && mosaic.length) {
							// Mosaic
							out.println(mosaic);
						}
						
						// Caption
						if (c) {
							out.print('<div class="caption">' + c.replace(/(<h\d>)/, '$1<a href="' + cp + '"' + ask + '>').replace(/(<\/h\d>)/, '</a>$1') + '</div>');
						}
						
						out.println('</div>');
					}
					
					out.println('\t\t\t\t\t</div>\n\t\t\t\t</section>');
				}
				
				break;
				
			case 'pages':
				
				if (showPages !== 'none') {
					var pages = getChildrenOfType(currentFolder, 'webPage'),
						s;
					
					if (pages.length) {
						// Creating pages section
						out.println('\t\t\t\t\t\t<section class="pages-cont hide-on-overlay">');
						
						if (showPages === 'embed' || showPages === 'embedCustom') {
							
							for (var i = 0, nm; i < pages.length; i++) {
								
								if (!pages[i].isHidden() && (showPages === 'embed' || !isPredefinedPage(pages[i]))) {
									//print(pages[i].getName() + ' is ' + (typeof pages[i]));
									//nm = pages[i].getVars().get('pageHook');
									nm = getOriginalPageName(pages[i], 'user');
									//print(pages[i].getName() + ' is ' + (typeof pages[i]) + ' hook: "' + nm + '"');
									s = (nm === 'newimages')? 
										getNewImagesContent(pages[i])
										:
										getCustomPageContent(pages[i]);
									
									if (s) {
										out.println('\t\t\t\t\t\t\t<div class="custom ' + nm + '-page">');
										out.println('\t\t\t\t\t\t\t\t<div class="cont page-wrap">\n' + s  + '\n\t\t\t\t\t\t\t\t</div>');
										out.println('\t\t\t\t\t\t\t</div>');
									}
								}
							}
							
							if (showPages === 'embedCustom') {
								s = '';
								
								for (var i = 0; i < pages.length; i++) {
									if (!pages[i].isHidden() && isPredefinedPage(pages[i])) {
										s += getPageThumbnail(pages[i]);
									}
								}
								
								if (s) {
									out.println('<div class="cont pages">' + s + '</div>');
								}
							}
							
						} else {
							s = '';
							
							for (var i = 0; i < pages.length; i++) {
								if (!pages[i].isHidden()) {
									s += getPageThumbnail(pages[i]);
								}
							}
							
							if (s) {
								out.println('<div class="cont pages">' + s + '</div>');
							}
						}
						
						out.println('\t\t\t\t\t\t</section>');
					}
					
				}
				
				break;
				
			case 'images':
				
				var images = getChildrenOfType(currentFolder, 'image,audio,video,other');
				
				if (images.length) {
					
					var vars,
						cat,
						alt,
						c,
						tw,
						th,
						ar,
						ip,
						tp,
						icon,
						sb = new StringBuffer();
						
					sb.append('\t\t\t\t\t\t<section class="thumb-cont base-overlay"><div class="' + 
							[ 	'cont',
								'thumbnails',
								thumbLayout,
								'caption-' + captionPlacement,
								(captionShowOnHover && captionPlacement !== 'below')? 'hover' : '',
								markActualImage? 'mark-active' : '',
								thumbGrayscaleEffect? 'grayscale' : '',
								(images.length > 2)? 'wrap' : ''
							].filter(Boolean).join(' ') +
						'">\n');
					
					for (var i = 0, j = 0; i < images.length; i++) {
						
						if (j >= preloadThumbs) {
							break;
						}
						
						vars = images[i].getVars();
						
						if (vars.get('sliderImage')) {
							continue;
						}
						
						cat = images[i].category;
						alt = addAltTags? (' alt="' + stripHTML(vars.get('title') + ' ' + vars.get('commentShort')).trim() + '"') : '';
						c = vars.get('thumbCaption');
						tw = vars.get('thumbWidth');
						th = vars.get('thumbHeight');
						ar = tw / th;
						tp = vars.get('thumbPath');
						icon = vars.get('iconPath');
						
						if (vars.get('imageAttachmentPath') !== null) {
							// Has representing image: don't use the icon
							icon = null;
						}
						
						switch (cat) {
							case 'image':
								ip = vars.get('imagePath');
								break;
							case 'video':
								ip = vars.get('videoPath');
								break;
							default:
								ip = vars.get('originalPath') || vars.get('imagePath');
						}
						
						sb.append('<div class="' +
									[
										'card',
										'preload',
										cat,
										c? 'hascaption' : '',
										((tw < maxThumbWidth && th < maxThumbHeight)? 'tiny' : ''),
										icon? 'icon' : '',
										(ar >= 1.25)? 'landscape' : ((ar <= 0.8)? 'portrait' : 'square')
									].filter(Boolean).join(' ') +
								'">' + 
								'<a class="thumb' +
									(icon? ' iconthumb' : '') +
									(((tw < maxThumbWidth) && (th < maxThumbHeight))? ' tiny' : '') +
									'" href="' + ip + '">' +
									'<img src="' + tp + '"' +
										(!icon? (' width="' + tw + '" height="' + th + '"') : '') +
										alt +
									'>' +
								'</a>' + 
								(c? ('<div class="caption">' + c + '</div>') : '') +
							'</div>\n');
						
						j++;
					}
					
					if (j) {
						sb.append('</div></section>');
						out.println(sb.toString());
					}
				}
				
				break;
		
			case 'map':
				
				if (mapInSections && !mapInSidebar && (typeof locationCount !== UNDEF) && locationCount) {
					out.println('\t\t\t\t\t\t<section class="map-cont hide-on-overlay" data-rel="base"><div class="cont">' +
							(indexMapLabel? ('<h4 class="icon-location"> ' + indexMapLabel + '</h4>') : '') +
							'<div class="map-root" data-map-root></div>' +
						'</div></section>');
				}
				
				break;
				
			case 'neighboringFolders':
					
				if (level && linkNeighboringFolders) {
				
					if ((typeof previousFolderPath !== UNDEF) && previousFolderPath || 
						(typeof nextFolderPath !== UNDEF) && nextFolderPath) {
						
						out.print('\t\t\t\t\t\t<section class="prev-next-links hide-on-overlay"><div class="cont">');
						
						if (previousFolderPath) {
							out.print('<div class="previous-link">' + 
									'<a rel="prev" href="' + previousFolderPath + indexName + '"' +
										((typeof previousFolderAsk !== UNDEF)? (' data-ask-permission="' + previousFolderAsk + '"') : '') +
									'>' +
										((neighboringFolderBgImage && previousFolderThumbPath)? 
											('<span class="thumb" style="background-image:url(' + previousFolderThumbPath + ')">&nbsp;</span>') 
											: 
											'<span class="arrow icon-arrow-left">&nbsp;</span>'
										) +
										//'<span class="icon-caret-left"></span>' +
										'<span class="caption">' + previousFolderTitle + '</span>' +
									'</a>' +
								'</div>');
						}
						
						if (nextFolderPath) {
							out.print('<div class="next-link">' + 
									'<a rel="next" href="' + nextFolderPath + indexName + '"' + 
										((typeof nextFolderAsk !== UNDEF)? (' data-ask-permission="' + nextFolderAsk + '"') : '') +
									'>' +
										'<span class="caption">' + nextFolderTitle + ' </span>' +
										//'<span class="icon-caret-right"></span>' +
										((neighboringFolderBgImage && nextFolderThumbPath)? 
											('<span class="thumb" style="background-image:url(' + nextFolderThumbPath + ')">&nbsp;</span>') 
											: 
											'<span class="arrow icon-arrow-right">&nbsp;</span>'
										) +
									'</a>' +
								'</div>');
						}
						
						out.println('</div></section>');
					}
				}
				
				break;
				
			case 'comments':
				
				if (_useFacebookCommenting || _useDisqusCommenting) {
					
					out.println('\t\t\t\t\t\t<section class="commenting-cont hide-on-overlay"><div class="cont">' +
							(_useFacebookCommenting? ('<div class="fb-comments" id="fb-comments" data-num-posts="' + facebookCommentingPosts + '" data-width="100%" data-colorscheme="' + commentingTheme + '"' + (pageUrl? ' (data-href="' + pageUrl + '")' : '') + '></div>') : '') +
							(_useDisqusCommenting? '<div class="disqus-comments" id="disqus-comments"><div id="disqus_thread"></div></div>' : '') +
						'</div></section>');
				}
				
				break;
				
			case 'customContent':
				
				if (customSectionHook && (!level || !customSectionTopLevelOnly)) {
					var cs = getProcessed(customSectionHook).trim();
					if (cs[0] !== '<') {
						cs = '<p>' + cs + '</p>';
					}
					out.println('\t\t\t\t\t\t<section class="custom-content hide-on-overlay"><div class="cont">' + cs + '</div></section>');
				}
				
				break;
		}
	}
%>