<% // Newimages.htt skin specific part
	var thumbs = [],										// Thumbnails buffer
		dates = [],											// Corresponding Dates
		index = [],											// Pointers
		dmax = newImagesDays * 24 * 60 * 60 * 1000,			// Difference in ms
		n = 0,
		now = new Date(),
		preload = (typeof preloadThumbs === 'undefined')? 20 : preloadThumbs,
		
		getTitle = function() {
				var s;
				
				switch (newImagesSource) {
					case 'dateTaken':
						s = getText('imagesTaken');
						break;
					case 'fileModified':
						s = getText('imagesModified');
						break;
					default:
						s = getText('imagesAdded');
				}
				
				return s + ' ' + getTimespan(newImagesDays); 
			},
		
		writeOutThumbnails = function() {

					//print('Writing out thumbs [' + thumbs.length + ']');

					out.print('\t\t\t\t<h4>' + getTitle() + '</h4>' +
						'<section class="thumbnails ' + thumbStyle + '">' +
							'<div class="thumb-cont">');

					for (var i = 0; i < index.length; i++) {
						
						var ao		= thumbs[index[i]];

						if (typeof ao !== UNDEF && isSimpleObject(ao) && ao.isIncluded()) {						

							var vars 	= ao.getVars(),
								tp		= vars.get('thumbPath'),
								fn 		= encodeURIComponent(ao.getName()),
								tw		= parseInt(vars.get('thumbWidth')),
								th 		= parseInt(vars.get('thumbHeight')),
								alt 	= addAltTags? (' alt="' + stripHTML(vars.get('title')).trim() + '"') : '',
								c		= stripHTML(vars.get('thumbCaption')),
								rp		= ao.getPathFrom(currentFolder);

							rp = rp.substring(0, rp.length - ao.getName().length);
							
							out.print('<a class="thumb" href="' + rp + indexName + '#img=' + fn + '"' + 
									(c? (' title="' + c + '"') : '') + '>' + 
									'<img src="' + rp + tp + '" width="' + tw + '" height="' + th + '"' + alt + '>' +
									'<span class="icon-new-fill new-image" data-tooltip="' + 
										(new Date(dates[index[i]])).toLocaleDateString() +
										//getTimespan((now - ao['refDate']) / ONEDAY_MS) + 
									'"></span>' +
								'</a>');
						}
					}

					out.println('</div></section>');
				},
				
			sortThumbnails = function() {
				
					if (newImagesSort === 'date') {
						if (newImagesReverse) {
							index.sort(function(a, b) {
									return  dates[index[a]] - dates[index[b]];
								});
						} else {
							index.sort(function(a, b) {
									return  dates[index[b]] - dates[index[a]];
								});
						}
					} else if (newImagesSort === 'random') {
						index.sort(function() {
								return  0.5 - Math.random();
							});
					}
				},
				
			// Gathering new images		
			
			gatherNew = function(folder) {
				
					var images = folder.getChildren(),
						ao,
						cat,				// Category
						now = new Date(),
						d;
					
					for (var i = 0; i < images.length; i++) {
	
						ao = images[i];
						
						if (ao.isIncluded()) {
							cat = ao.getCategory();
							//print(ao.getName() + ' [' + cat + ']');
		
							if (cat === Category.folder) {
								if (newImagesDepth !== 'current' && !ao.isHidden()) {
									gatherNew(ao);
								}
							} else if (cat === Category.image || cat === Category.other ||
								cat === Category.audio || cat === Category.video) {
								
								if (newImagesSource === 'added') {
									d = ao.getWhenAdded();
								} else if (newImagesSource === 'dateTaken') {
									d = getEpochDate(ao, false);
								} else {
									d = ao.getLastModified();
								}
								
								if (d && (now - d) <= dmax) {
									thumbs.push(ao);
									dates.push(d);
									index.push(thumbs.length - 1);
								}
							}
						}
					}
				};
		
	if (newImagesDays) {
			
		gatherNew((newImagesDepth === 'tree')? rootFolder : currentFolder);
		
		if (newImagesSort !== 'original') {
			sortThumbnails();
		}
		
		writeOutThumbnails();
	}

%>