/*
 *	init.js - initializing the skin, skin-specific utilities
 *	Author: Laza
 */

	/* 
	 *	Java imports
	 */

var JAFilter = Java.type("se.datadosen.jalbum.JAFilter"),
	Config = Java.type("se.datadosen.jalbum.Config"),
	Category = Java.type("se.datadosen.jalbum.Category"),
	Widgets = Java.type("se.datadosen.jalbum.Widgets"),
	JAlbumUtilities = Java.type("se.datadosen.jalbum.JAlbumUtilities"),
	DateRange = Java.type("se.datadosen.jalbum.DateRange"),
	FixedShapeFilter = Java.type("FixedShapeFilter"),
	ConstrainRatioFilter = Java.type(skin.toLowerCase().split(' ')[0] + ".ConstrainRatioFilter"),
	File = Java.type("java.io.File"),
	Long = Java.type("java.lang.Long"),
	SkinProperties = Java.type("se.datadosen.jalbum.SkinProperties"),
	MyJSONObject = Java.type("se.datadosen.util.MyJSONObject"),
	System = Java.type("java.lang.System"),
	IO = Java.type('se.datadosen.util.IO'),
	LinkFile = Java.type("se.datadosen.io.LinkFile"),
	AtomicInteger = Java.type("java.util.concurrent.atomic.AtomicInteger"),
	JSONMaker = Java.type("se.datadosen.jalbum.JSONMaker");

	// No multiple index pages :: setting up before loading Util
	engine.setRows(0);
	
	// URL encoding, Write UTF-8 are madatory because the JSON database is always written in this format
	engine.setUrlEncode(true);
	//engine.setWriteUTF8(true);
	
	/* 
	 *	Global variables
	 */

	// Undefined
	UNDEF = 'undefined';
	
	time = (new Date()).getTime();					// time
	today = (time / 86400000) | 0;					// today: number of days since 1970-01-01

	skinVersion = new SkinProperties(skinDirectory).getProperty(SkinProperties.VERSION);

	if (typeof language === UNDEF) {
		language = Config.getConfig().getInterpretedLanguage();
	}
	
	// Fixing wrong Facebook App ID
	if (facebookAppId.indexOf('E') !== -1) {
		print('Facebook App ID is in wrong format, please check it in the Settings!');
		facebookAppId = facebookAppId.split('E')[0].replace(/\./g, '');
	}
	
	// Page protocol
	pageProtocol = basePath.startsWith('https://')? 'https:' : 'http:';
	
	// Debug mode? Don't use the minified javascript libraries.
	min = (typeof debugMode !== UNDEF && !!debugMode)? '' : '.min';
	
	// Folder image :: this image is copied to the index file's folder with the given name, cropped to the given size
	// Can be used as splash image for example
	// GUI should contain a JTextField folderImageSize, otherwise uncomment this:
	folderImageSize = "1800x1200";
	
	// album description processed
	albumCaption = getProcessed(albumDescription);
		
	albumImageUrl = urlEncodeFix(basePath + folderImageFileName);
	albumThumbUrl = urlEncodeFix(basePath + folderThumbFileName);
		
	credits = getCredits();
	
	// Feature detection
	_useFacebook = !!shareFacebook;
	_useTopNavigation = topNavigationIncludeFolders || topNavigationIncludePages || topNavigationIncludeWebLocations;
	_useMap = showMap && !!googleApiKey;
	_usePhotodata = !!showPhotoData && !!photoDataTemplate;
	_useRegions = typeof showRegions !== UNDEF && !!showRegions;
	//_useFotomoto = !!useFotomoto && fotomotoID;
	//_useMostPhotos = !!useMostphotos;
	_anyShares =
			shareFacebook || 
			shareTwitter || 
			sharePinterest ||
			shareLinkedin ||
			shareDigg || 
			shareReddit ||
			shareTumblr ||
			shareEmail ||
			shareLink;
						
	// Javascript variables compiled upfront
	jsGlobalVars = null;
	jsLightboxVars = null;
	jsMapVars = null;
	jsCookiePolicyVars = null;

	// Background audio array
	backgroundMusicFolder = 'res';
	
	relPath = '';
	relPathEncoded = '';
	
	// Generating slide pages for Facebook shares
	engine.setSlides(_useFacebook);
	
	if (!_useMap) {
		// Disabling GPS data writeout
		try {
			engine.getJSONMaker().setIncludeLocation(false);
		} catch (Throwable) {}
	}
	
	/* 
	 * 	New variables
	 *	All types
	 				fileLabel
	 				commentShort
	 				thumbCaption
	 				shop
	 				
	 *	Folders
	 				folderThumbPath
	 				altText
	 				folderModDate
	 				folderCounts
	 				epochDateRange
	 				
	 *  Displayable objects
	 				imageCaption
	 				mostphotos
	 				epochDate
	 				location
	 				
	 *	Images 
	 				photodata
	 				regions
	 
	 */
			
			
	var processFolder = function(folder) {
					 
				var	shopCount = new AtomicInteger(0),
					locationCount = new AtomicInteger(0),
					regionCount = new AtomicInteger(0),
					vrCount = new AtomicInteger(0),
					imageNum = new AtomicInteger(0),
					zipCount = new AtomicInteger(0),
					dateRange;
					
				relPath = getRelPath(folder);
				relPathEncoded = encodeAsJava(relPath);
				
				//logger(Level.FINE, 'Processing folder "{0}"', relPath);
				updateStatus(getTextTemplate("preprocessingFolder", level? relPath : folder.getName()));
				
				// creating extra variables --> data1.json
				folder.getChildren().forEach(function(ao) { 
					// parallelStream() fails !!!
						
					var vars,
						cat = ao.getCategory(),
						v,
						s,
						t,
						dates;
						
					if (ao.isIncluded() && 
						!(cat === Category.folder && ao.isHidden()) && 
						(vars = ao.getVars())) {
						
						// Extra fileLabel variable
						vars.put('fileLabel', vars.get('fileTitle') || vars.get('label').replace(/_/g, ' '));
						
						dates = {};
												
						// Folders and WebLocations
						
						if (cat === Category.folder || cat === Category.webLocation) {
							
							// Iconpath => SVG, folder thumb path
							if (s = vars.get('iconPath')) {
								s = s.replace('folder.png', 'folder.svg');
								vars.put('iconpath', s);
								vars.put('folderThumbPath', s.replace(/^\.\.\//, ''));
							} else {
								vars.put('folderThumbPath', createFolderThumb(ao, folderThumbSize, true)); 
							}
							
							// Counts
							vars.put('counts', getCounts(ao, true, 'p'));
							
							// Folders only
							if (cat === Category.folder) {
								// $folderModDate is for folder captions
								
								dateRange = JAlbumUtilities.getDeepCameraDates(ao);
								
								switch (folderDateSource) {
									case 'fileDate':
										vars.put('folderModDate', vars.get('fileDate'));
										break;
										
									case 'folderModDate':
										vars.put('folderModDate', getFormattedDate(deepLastModifiedObject(ao)));
										break;
										
									case 'lastCameraDate':
										if (dateRange.last) {
											vars.put('folderModDate', getFormattedDate(dateRange.last));
											break;
										}
										
									case 'cameraDateRange':
										if (dateRange.first && dateRange.last) {
											vars.put('folderModDate', getFormattedDateRange(dateRange.first + 0, dateRange.last + 0));
											break;
										}							
										
									default:
										vars.put('folderModDate', '');
								}
							}
							
							// Description
							s = vars.get((cat === Category.folder)? 'description' : 'comment');
							
							// Comment short
							vars.put('commentShort', shorten(stripHTML(s)));
							
							// Folders only
							if (cat === Category.folder) {
								
								// Counts
								vars.put('counts', (cat === Category.folder)? getCounts(ao, true, 'p') : '');
							
								dateRange = JAlbumUtilities.getDeepCameraDates(ao);
								
							}
							
							// Thumb caption
							s = processTemplate(ao, folderCaptionTemplate || '<div class="title">${fileTitle}</div><div class="comment">${comment}</div>');
							if (showFolderImageCount) {
								s += vars.get('counts');
							}
							
							vars.put('thumbCaption', s);
							
						} else {
							
							// Pages and normal items
							
							// Comment
							s = vars.get('comment');
							
							// Short comment
							vars.put('commentShort', shorten(stripHTML(s)));
														
							// Caption
							vars.put('thumbCaption', processTemplate(ao, '<div class="title">${fileTitle}</div><div class="comment">${comment}</div>'));
								
							if (cat === Category.webPage) {
								
								// Web page
								
								t = vars.get('title');
								
								// Page title, HTML tags removed
								vars.put('pageTitle', cleanup(stripHTML(t)));
								
								// Folder title: hero 
								vars.put('folderTitle', '<h1>' + t + '</h1>');
								
								// Top navigation
								vars.put('topNavigation', _useTopNavigation? getDropdownMenu(rootFolder, ao, !top, topNavigationIncludeFolders, topNavigationIncludePages, topNavigationIncludeWebLocations, topNavigationDepth - 1) : '');
								
								// Page URL
								if (basePath) {
									vars.put('pageUrl', basePath + relPathEncoded + ao.getWebName());
								} else {
									vars.put('pageUrl', '');
								}
								
								// Up link
								vars.put('uplink', './' + indexName);
								vars.put('uplinkText', getText('backToIndex'));
								
								// Description
								vars.put('pageDescription', cleanup(stripHTML(s)));
								
								// Folder info: no made date, no image count
								vars.put('folderInfo', '');
								
								// Page hook for CSS
								vars.put('pageHook', getOriginalPageName(ao, 'user') + '-page');
						
								// Has folder image?
								//vars.put('hasFolderImage', hasFolderImg);
						
							} else {
								
								// Normal items
								
								// Image number
								vars.put('imageNum', imageNum.getAndIncrement() + 1);
								
								// Formatted file size
								vars.put('fileSizeFormatted', getSizeAsString(vars.get('fileSize')));
								
								// Photo data
								if (_usePhotodata && (s = getPhotodata(ao, photoDataTemplate, 'p', showPhotoDataLabel))) {
									vars.put('photodata', s);
								}
								
								// Image caption
								if (imageCaptionTemplate && (s = processTemplate(ao, imageCaptionTemplate))) {
									vars.put('imageCaption', s);
								} else {
									vars.put('imageCaption', '');
								}
								
								if (cat === Category.image) {
									
									// Regions / faces
									if (_useRegions && (s = getRegions(ao)) !== null) {
										vars.put('regions', JSON.stringify(s));
										regionCount.getAndIncrement();
									}
									
									// User designated panorama
									if (typeof panorama !== UNDEF && panorama) {
										vars.put('panorama', true);
									}
									/*
									// Sound clip
									if (useSoundClips && (s = checkSoundClip(ao))) {
										vars.put('soundClip', s);
									}
									*/
								}
									
								// Copying GIF / SVG files with whatever settings
								s = getExt(ao.getName()).toLowerCase();
								if ((s === 'gif' || s === 'svg') && 
									!linkOriginals && !ao.isIncludeOriginal() &&
									(s = copyOriginal(ao))) {
									vars.put('originalFile', s);
								}
									
								// Map
								if (_useMap) {
									s = getLocation(ao);
									vars.put('location', s);
									//logger(Level.FINE, 'Location for "{0}": "{1}"', [ ao.getName(), s ]);
									if (s) {
										locationCount.getAndIncrement();
									}
								}
								
								// External content
								if ((v = vars.get('externalContent')) && (v = processTemplate(ao, v, true))) {
									var ext = new MyJSONObject(),
										size = vars.get('externalContentSize');
										
									ext.put('cont', v.trim());
									
									if (!size && (size = getDimFromCode(v.toLowerCase()))) {
										size = size.join('x');
									}
									                              
									if (size) {
										ext.put('size', size);
									}
									
									vars.put('external', ext);
								}
								
							}
						}
						
						if (!isEmpty(dates)) {
							vars.put('dates', dates);
						}
					}
				});
				
				// Current folder variables --> tree.json
								
				/*************************************************
				 *
				 *	Processing the current folder for tree.json
				 *
				 *************************************************/
				 
				var	vars = folder.getVars();
				
				if (vars) {
					
					var c = vars.get('description'),
						t = vars.get('title'),
						modDate,
						topNav,
						top = (folder === rootFolder),
						count = getCountObj(folder);
						
					// Counters
					vars.put('locationCount', locationCount.get());
					vars.put('regionCount', regionCount.get());
					//vars.put('vrCount', vrCount.get());
					vars.put('folderCount', count.folder);
					vars.put('webPageCount', count.webPage);
					vars.put('webLocationCount', count.webLocation);
					vars.put('lightboxableCount', count.image + count.audio + count.video + count.other);
					vars.put('nonLightboxableCount', count.folder + count.webPage + count.webLocation);
					
					// Folder modified date for templates
					if (top) {
						
						// Epoch date range
						dateRange = JAlbumUtilities.getDeepCameraDates(folder);
						
					}
					
					// Neighboring folders
					if (!top && (afterLast === 'ask' || afterLast === 'nextfolder')) {
						
						if ((ao = getPreviousFolder(folder)) != null) {
							v = ao.getVars();
							vars.put('previousFolderPath', '../' + v.get('closeupPath'));
							vars.put('previousFolderTitle', ao.getTitle() || ao.getName());
							vars.put('previousFolderThumbPath', '../' + v.get('thumbPath'));
							s = encodeAsJava(ao.getWebName());
							
							if ((ao = getLastImage(ao)) != null) {
								vars.put('previousFoldersLast', '../' + s + '/' + indexName + '#img=' + getFinalName(ao));
							} else {
								vars.put('previousFoldersLast', '');
							}
						} else {
							vars.put('previousFolderPath', '');
							vars.put('previousFolderTitle', '');
							vars.put('previousFolderThumbPath', '');
							vars.put('previousFoldersLast', '');
						}
						
						if ((ao = getNextFolder(folder)) != null) {
							v = ao.getVars();
							vars.put('nextFolderPath', '../' + v.get('closeupPath'));
							vars.put('nextFolderTitle', ao.getTitle() || ao.getName());
							vars.put('nextFolderThumbPath', '../' + v.get('thumbPath'));
							s = encodeAsJava(ao.getWebName());
							
							if ((ao = getFirstImage(ao)) != null) {
								vars.put('nextFoldersFirst', '../' + s + '/' + indexName + '#img=' + getFinalName(ao));
							} else {
								vars.put('nextFoldersFirst', '');
							}
						} else {
							vars.put('nextFolderPath', '');
							vars.put('nextFolderTitle', '');
							vars.put('nextFolderThumbPath', '');
							vars.put('nextFoldersLast', '');
						}
					}
							
					// Page URL and thumb path
					if (basePath) {
						vars.put('pageUrl', basePath + relPathEncoded + indexName);
						vars.put('pageThumbPath', basePath + relPathEncoded + shareImageFilename);
					} else {
						vars.put('pageUrl', '');
						vars.put('pageThumbPath', shareImageFilename);
					}
					
					// Page title, HTML tags removed
					vars.put('pageTitle', cleanup(stripHTML(t)));
					
					// Top navigation
					vars.put('topNavigation', _useTopNavigation? getTree(rootFolder, topNavigationIncludeFolders, topNavigationIncludePages, topNavigationIncludeWebLocations) : '');
					
					// Breadcrumb path
					if (typeof showBreadcrumbPath !== UNDEF && showBreadcrumbPath) {
						vars.put('breadcrumbPath', getBreadcrumbPath(folder));
					}
					
					// Up link
					if (level) {
						vars.put('uplink', '../' + indexName);
						vars.put('uplinkText', getText('upOneLevel'));
					} else {
						vars.put('uplink', homepageAddress || '');
						vars.put('uplinkText', homepageLinkText || getText('home'));
					}
					
					// Description
					vars.put('pageDescription', stripQuot(stripHTML(c)));
										
					// Processing folder image and thumbnail
					vars.put('hasFolderImage', createFolderImage(folder, folderImageSize));
					
				}
				
				revertStatus();
			},
					
		/*
		 *	Initializing Javascript variables
		 */
		 
		getGlobalVars = function() {
				var o = {
							albumName:		stripQuot(albumTitle),
							makeDate:		Long.valueOf(Math.floor((new Date()).getTime() / 1000)),
							licensee:		license,
							thumbDims:		maxThumbWidth + 'x' + maxThumbHeight
						};
						
				if (indexName !== 'index.html') {
					o['indexName'] = indexName;
				}
				
				if (homepageAddress) {
					o['uplink'] = escQuot(homepageAddress);
				}
				
				// Controls
				
				o['hideControls'] = hideControls;
					
				if (!enableKeyboard) {
					o['enableKeyboard'] = false;
				}
				
				if (!enableMouseWheel) {
					o['enableMouseWheel'] = false;
				}
				
				if (rightClickProtect) {
					o['rightClickProtect'] = true;
				}
				
				if (_anyShares) {
					
					var s = new Array();
					
					if (shareFacebook) s.push('facebook');
					if (shareTwitter) s.push('twitter');
					if (shareTumblr) s.push('tumblr');
					if (sharePinterest) s.push('pinterest');
					if (shareLinkedin) s.push('linkedin');
					if (shareDigg) s.push('digg');
					if (shareReddit) s.push('reddit');
					if (shareEmail) s.push('email');
					if (shareLink) s.push('link');
					o['share'] = { 
						sites:			s.join(','),
						hook:			'.social .preview'
					}
					if (emailSubject) {
						o['share']['callAction'] = emailSubject;
					}
				}
				
				if (markFilesNew && newDaysCount) {
					o['markNew'] = {
						days:		newDaysCount,
						reference:	newDaysRef
					}
					
					if (newDaysMark === 'text' && newDaysText) {
						o.markNew['text'] = newDaysText;
					}
				}
				
				if (slideshowAuto) {
					o['auto'] = true;
				}
				
				return o;
			},
			
		// Lightbox variables
		
		getLightboxVars = function() {
				var o = {};
			
				if (afterLast !== 'donothing') {
					o['afterLast'] = afterLast;
				}
				
				o['transitionType'] = 'conveyor';					//	transitionType; // Only conveyor is implemented!!!
				o['slideshowDelay'] = slideshowDelay * 1000;
				o['transitionSpeed'] = transitionSpeed;
				
				if (videoAutoPlay) {
					o['videoAuto'] = true;
				}
				if (showDownload) {
					o['showDownload'] = true;	
				}
				if (showMap) {
					o['showMap'] = true;
				}
				if (downloadNonImages) {
					o['allowDownloadOthers'] = true;
				}
				if (downloadScaled) {
					o['allowDownloadScaled'] = true;
				}
				if (printImageButton) {
					o['printImage'] = true;
				}
				if (_useRegions) {
					o['showRegions'] = true;
				}
				if (captionStyle !== 'dark') {
					o['captionStyle'] = captionStyle;
				}
				if (captionPlacement !== 'center bottom') {
					o['captionPlacement'] = captionPlacement;
				}
				if (backgroundAudio && backgroundAudioSlideshowControl) {
					o['backgroundAudioSlideshowControl'] = true;
				}
				if (useFullScreen) {
					o['useFullScreen'] = true;
				}
				if (!neverScaleUp || rootFolder.getVars().getMap().get('imageRenditions')) {
					o['scaleUp'] = true;
				}
				if (fillHorizontally !== 90) {
					o['fillHorz'] = fillHorizontally;
				}
				if (fillVertically !== 100) {
					o['fillVert'] = fillVertically;
				}
				if (showFullscreen === false) {
					o['showFullscreen'] = false;
				}
				
				return o;	
			},
			
		// Audio player vars
		
		getAudioPlayerVars = function() {
				var o = {};
				
				if (backgroundAudio) {
					o['src'] = backgroundMusic;
					
					o['target'] = 'player';
					
					if (backgroundAudioVolume !== 25) {
						o['volume'] = backgroundAudioVolume / 100;
					}
					if (!backgroundAudioAutoPlay) {
						o['autoPlay'] = false;
					}
					if (!backgroundAudioLoop) {
						o['loop'] = false;
					}
					if (backgroundAudioSlideshowControl) {
						o['slideshowControl'] = true;
					}
					if (!backgroundAudioRetainPosition) {
						o['saveStatus'] = false;
					}
					
					o['folder'] = backgroundMusicFolder;
				}
				
				return o;
			},
			
		// Map vars
		
		getMapVars = function() {
				var o = {
						map: {
							type:	mapType,
							zoom:	mapZoom
						}
					};
				
				if (googleApiKey && googleApiKey.charAt(0) !== '#') {
					o.map['apiKey'] = googleApiKey.trim();
				}
				
				return 	o;
			},
	
		// Index page variabes
		
		getIndexVars = function() {
				var o = {
							rootPath:	(rootPath === '.')? '' : rootPath,
							resPath:	resPath,
							relPath:	relPathEncoded.replace(/\/$/, '')
						};
						
				if (level > 0) {	
					o['level'] = level;
					if (typeof previousFoldersLast !== UNDEF) {
						o['previousFoldersLast'] = previousFoldersLast;
					}
					if (typeof nextFoldersFirst !== UNDEF) {
						o['nextFoldersFirst'] = nextFoldersFirst;
					}
				}
				
				return o;
			},

		//	Get Javascript variable to pass to the skin
		
		getJsVars = function() {
				var v = extend({}, jsGlobalVars, jsMapVars, { 'pageType': pageType });
				
				if (pageType === 'index') {
					extend(v, getIndexVars(), jsLightboxVars);
				}
					
				return (JSON.stringify(v)).replace(/\:true/g, ':!0').replace(/\:false/g, ':!1');
			},
			
		// Get APIs
		
		getAPIs = function() {
				var a = {};
				
				if (googleSiteID && googleAnalytics !== 'none') {
					a['googleAnalytics'] = [ xEncrypt(googleSiteID), googleAnalytics, supportDoubleclick ];
				}
				if (_useFacebook) {
					a['facebook'] = [ xEncrypt(facebookAppId), locale ];
				}

				return JSON.stringify(a).replace(/\:true/g, ':!0').replace(/\:false/g, ':!1').replace(/^\{\}$/, '');
			},	
			
		getCookiePolicyVars = function() {
			
				var v = {};
				
				v['cookiePolicy'] = showCookiePolicy;
				
				if (cookiePolicyStay != 15) {
					v['stay'] = cookiePolicyStay;
				}
			
				if (cookiePolicyUrl) {
					v['cookiePolicyUrl'] = cookiePolicyUrl;
				}
				
				return JSON.stringify(v).replace(/\:true/g, ':!0').replace(/\:false/g, ':!1');
			},
				
	
		/*
		 * Initializing album
		 */
			 
		initAlbum = function() {
			
				// Fixed shape
				if (thumbStyle === 'grid') {
					engine.addFilter(new FixedShapeFilter(), JAFilter.THUMBNAILS_PRESCALE_STAGE);
				} else {
					engine.addFilter(new ConstrainRatioFilter(0.75, 3.33333), JAFilter.THUMBNAILS_PRESCALE_STAGE);
				}
			
				// Custom link
				if (typeof customLink !== UNDEF && customLink) {
					credits = '<a href="' + customLink + '" target="_blank">' + 
						((customLinkText)? customLinkText : customLink) +
						'</a>' +
						(credits? (' &middot; ' + credits) : '');
				}
				
				// MS server configuration
				if (useMsServer) {
					copySkinFile('includes', 'web.config');
				} else {
					removeOutputFile('web.config');
				}
		
				// Expiry headers
				if (useExpiry) {
					copySkinFile('includes', '.htaccess');
				} else {
					removeOutputFile('.htaccess');
				}
				
				if (useRobotsTxt) {
					copySkinFile('includes', 'robots.txt');
					copySkinFile('includes', 'humans.txt');
				} else {
					removeOutputFile('robots.txt');
					removeOutputFile('humans.txt');
				}
				
				// Background music
				if (backgroundAudio) {
					backgroundMusic = copyResources(backgroundAudio.split('\t'), backgroundMusicFolder);
					jsAudioPlayerVars = getAudioPlayerVars(); 
				} else {
					backgroundMusic = '';
				}
				
				// JS variables
				jsGlobalVars = getGlobalVars();	
				jsLightboxVars = getLightboxVars();
				jsMapVars = _useMap? getMapVars() : null;
				jsCookiePolicyVars = showCookiePolicy? getCookiePolicyVars() : null;
				
				// Creating all.js
				mergeJs('js',
					[	// Dependencies
						// Modernizr
						'modernizr',
						// Detects input method
						'what-input',
						// Utilities
						'laza.util',
						// laza libraries
						'laza.cookie',
						'laza.alignto',
						'laza.tooltip',
						'laza.modal',
						'laza.sharebuttons',
						'laza.transform',
						'laza.swipe',
						// Audio player
						(backgroundMusic? 'laza.audioPlayer' : ''),
						// Map
						(_useMap? 'laza.addmap' : ''),
						// main Js
						'main'
					].filter(Boolean),
					// Output name
					'all',
					debugMode,
					[
						// Texts:start
						// modal
						'closeWindow',
						// sharebuttons
						'share',
						'shareOn',
						'checkThisOut',
						'localWarning',
						'email',
						'slideshow',
						'copy',
						'copied',
						// main
						'newItem',
						'atFirstPage',
						'atLastPage',
						'atLastPageQuestion', 
						'startOver', 
						'backToHome',
						'upOneLevel',
						'previousFolder',
						'nextFolder',
						'download',
						'print',
						'metaBtn', 
						'clickToOpen',
						// util
						'today',
						'yesterday',
						'daysAgo',
						'monthsAgo',
						'yearsAgo',
						'locationWarning',
						'cookiePolicyText',
						'cookiePolicyAgree',
						'cookiePolicyLearnMore',
						'gdprComplianceText',
						'allowAll',
						'denyAll',
						'allowSelected'
						// Texts:end
					]
				);
				
				var vars = rootFolder.getVars();
			};
		
	initAlbum();

	if (typeof writeSitemapXml !== 'undefined' && writeSitemapXml) {
		//System.out.println('writeSitemap = ' + writeSitemapXml);
		createSitemap();
	}