<%--------------------------------

		sections.inc - index page Content 

--------------------------------%>
<%
	
	var	getFolderThumb = function(ao) {
				var vars = ao.getVars(),
					s;

				// Iconpath => SVG, folder thumb path
				if (s = vars.get('iconPath')) {
					s = s.replace('folder.png', defaultFolderIconName);
					return s.replace(/^\.\.\//, '');
				} else {
					return createFolderThumb(ao, folderThumbSize, true);
				}
			},
			
		getNewImagesContent = function(ao) {
				var vars = ao.getVars(),
					t = vars.get('fileTitle'),
					d;
				
				d = {
						fn:				'collectByDate',
						start:			today - (vars.get('newImagesDays') || 30),
						depth:			vars.get('newImagesDepth') || 'tree',
						sortBy:			vars.get('newImagesSort') || 'date',
						reference:		vars.get('newImagesSource') || 'dateTaken',
						reverse:		vars.get('newImagesReverse') || false,
						linkMore:		vars.get('closeupPath')
					};
				
				return (t? ('<h4>' + t + '</h4>') : '') + 
					'<div class="new-images single-row" data-jalbum-query=\'' + JSON.stringify(d) + '\'></div>';
			},

		getPageThumbnail = function(ao) {
				var vars = ao.getVars(),
					s,
					c;
					
				s = '<h4><a class="icon-' + getPageIcon(ao) + '" href="' + vars.get('closeupPath') + '"> ' + vars.get('title') + '</a></h4>';
				
				if (showPages === 'excerpt') {
					c = vars.get('aboutText') || vars.get('comment');
					
					if (c) {
						var i = c.indexOf('<!--more-->'); 
						s += '<div class="caption">' +
								((i > 0)? c.substring(0, i) : shorten(c)) +
							'</div>';
					}
				}
				
				return '<div class="card">' + s + '</div>';
			};
			
	/******************************************************************
	 *
	 *						Main Content
	 *
	 ******************************************************************/
	
	// The main section
	
	// Custom code above BODY
	 
	if (bodyTopHook && bodyTopHook.trim().length && !(bodyTopTopLevelOnly && level)) {
		if (bodyTopFitWidth) {
			out.println('\t\t\t\t<section class="above-body">' +
					'<div class="cont">' + getProcessed(bodyTopHook) + '</div>' +
				'</section>');
		} else {
			out.println(getProcessed(bodyTopHook));
		}
	}
		
	// Folder description
	
	if (typeof description !== UNDEF && description.trim().length()) {
		out.println('\t\t\t\t<section class="page-description hide-on-overlay">' +
				'<div class="cont"><div class="descr">' + description + '</div></div>' +
			'</section>');
	}
	
	// Map
	
	if (_useMap && (typeof locationCount !== UNDEF) && locationCount) {
		out.println('\t\t\t\t<section class="map ' + (locationCount? '' : ' hidden') + 'hide-on-overlay">' +
				'<div class="cont box">' +
					'<div class="map-root" data-map-root></div>' +
				'</div>' +
			'</section>');
	}
	
	// Tag cloud above

	if (tagCloudSource !== 'none' && tagCloudPosition === 'top' && (tagCloudSource !== 'subfolders' || level >= tagCloudSkipLevels)) {
		
		out.println('\t\t\t\t<section id="tag-cloud" class="tag-cloud hide-on-overlay"><div class="cont box small-column">' +
				(tagCloudLabel? ('<h4 class="icon-tag"> ' + tagCloudLabel + '</h4>') : '') +
				'<div class="tag-cloud-cont' + (tagCloudFontVaries? ' font-varies' : '') + '"></div>' +
			'</div></section>');
	}
			
	// THumbnails

	out.print('\t\t\t\t<section class="thumbnails"><div class="cont thumb-cont ' + 
			[	boxDesign,
				(fixedShapeThumbs && diaFrame)? 'diaframe' : '',
				hoverEffectThumbs? 'hover-zoom' : ''
				//(thumbs.length >= columns)? 'multi' : ('single cnt-' + thumbs.length)
			].filter(Boolean).join(' ') +
		'">');
	
	n = 0;
	
	for each (ao in currentFolder.getChildren()) {

		if (ao.isIncluded() && (!ao.isFolder() || !ao.isHidden())) {
			var vars 	= ao.getVars(),
				cat		= ao.getCategory(),
				lbable	= cat === Category.image || cat === Category.audio || cat === Category.video || cat === Category.other,
				folder 	= cat === Category.folder, 
				icp		= vars.get('imageAttachmentPath')? null : vars.get('iconPath'),
				tp		= cat === (icp && Category.webPage)? 
								(resPath + '/' + cardIconTheme + '/' + getOriginalPageName(ao, 'user') + '-page.svg') 
								: 
								cat === Category.folder?
									vars.get('folderThumbPath')
									:
									vars.get('thumbPath'),
				ip 		= vars.get(lbable? ((cat === Category.video || cat === Category.audio)? 'contentPath' : 'imagePath') : 'closeupPath'),
				tw		= parseInt(vars.get('thumbWidth')),
				th		= parseInt(vars.get('thumbHeight')),
				c 		= vars.get('thumbCaption'),
				t 		= stripHTML(vars.get('title')) || vars.get('label');

			out.print('<div class="' + [
						'card',
						(n < preloadThumbs)? 'preload' : 'lazyload',
						cat.name(),
						lbable? 'lbable' : '',
					].filter(Boolean).join(' ') +
				'">');
			
			out.print('<div class="thumb">');
			
			if (folder) {
				out.print('<div class="graphics">');
				
				if (icp) {
					tp = resPath + '/' + cardIconTheme + '/folder-icon.svg';
				}
			}
			
			out.print('<a class="image' +
				(icp? (' ' + (cat === Category.webPage? 'iconthumb' : 'icon')) : '') +
				((tw < maxThumbWidth && th < maxThumbHeight)? ' tiny' : '') + 
				'" href="' + ip + '">');

			if (n < preloadThumbs) {
				// Adding thumbnail for preload
				out.print('<img src="' + tp + '"' +
						((t && addAltTags)? (' alt="' + t.replace(/"/g, '&#34;') + '"') : '') +				// '
					'>');
			}

			out.print('</a>');

			if (folder) {
				out.print('</div>');
			}
			
			out.print('</div>');
			
			if (c) {
				// Caption
				out.print('<div class="caption">' + c + '</div>');
			}

			
			out.print('</div>');

			n++;
		}
	}

	out.println('</div></section>');
			
	// Tag cloud below

	if (tagCloudSource !== 'none' && tagCloudPosition === 'bottom' && (tagCloudSource !== 'subfolders' || level >= tagCloudSkipLevels)) {
		
		out.println('\t\t\t\t<section id="tag-cloud" class="hide-on-overlay"><div class="cont box small-column">' +
				(tagCloudLabel? ('<h4 class="icon-tag"> ' + tagCloudLabel + '</h4>') : '') +
				'<div class="tag-cloud-cont"></div>' +
			'</div></section>');
	}
				
	// Neighboring folders
	
	if (level && linkNeighboringFolders) {

		if ((typeof previousFolderPath !== UNDEF) && previousFolderPath || 
			(typeof nextFolderPath !== UNDEF) && nextFolderPath) {
			
			out.print('\t\t\t\t<section class="prev-next-links hide-on-overlay"><div class="cont">');

			if (previousFolderPath) {
				out.print('<div class="previous-link ' +
							((neighboringFolderBgImage && previousFolderThumbPath)? 'has-bg' : 'no-bg') +
						'">' + 
						'<a rel="prev" href="' + previousFolderPath + indexName + '"' +
							((neighboringFolderBgImage && previousFolderThumbPath)? (' style="background-image:url(' + previousFolderThumbPath + ')"') : ' class="button"') +
							((typeof previousFolderAsk !== UNDEF)? (' data-ask-permission="' + previousFolderAsk + '"') : '') +
						'>' +
							'<span class="caption"><span class="icon-caret-left"></span> ' + previousFolderTitle + '</span>' +
						'</a>' +
					'</div>');
			}

			if (nextFolderPath) {
				out.print('<div class="next-link ' +
							((neighboringFolderBgImage && nextFolderThumbPath)? 'has-bg' : 'no-bg') +
						'">' + 
						'<a rel="next" href="' + nextFolderPath + indexName + '"' +
							((neighboringFolderBgImage && nextFolderThumbPath)? (' style="background-image:url(' + nextFolderThumbPath + ')"') : ' class="button"') +
							((typeof nextFolderAsk !== UNDEF)? (' data-ask-permission="' + nextFolderAsk + '"') : '') +
						'>' +
							'<span class="caption">' + nextFolderTitle + ' <span class="icon-caret-right"></span></span>' +
						'</a>' +
					'</div>');
			}

			out.println('</div></section>');
		}
	}

	// Commenting
	
	if (_useFacebookCommenting || _useDisqusCommenting) {

		out.println('\t\t\t\t<section class="commenting">' +
				(_useFacebookCommenting? ('<div class="fb-comments cont" id="fb-comments" data-num-posts="' + facebookCommentingPosts + '" data-width="100%" data-colorscheme="' + commentingTheme + '"' + (pageUrl? ' (data-href="' + pageUrl + '")' : '') + '></div>') : '') +
				(_useDisqusCommenting? '<div class="disqus-comments cont" id="disqus-comments"><div id="disqus_thread"></div></div>' : '') +
			'</section>');
	}
	
	// Custom content

	if (typeof customSection !== UNDEF && customSection && (!level || !customSectionTopLevelOnly)) {
		var cs = getProcessed(customSection).trim();
		if (cs.indexOf('<') === -1) {
			cs = '<p>' + cs + '</p>';
		}
		out.println('\t\t\t\t<section class="custom-content">' + 
				'<div class="cont">' + cs + '</div>' +
			'</section>');
	}

%>