package lizard;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JCustomPanel;
import se.datadosen.util.SmartResourceBundle;

/**
 *
 * @author Laza
 */

public class ImageDataUI extends JCustomPanel {

	JCheckBox panorama = new JCheckBox();
	JCheckBox hideLocation = new JCheckBox();
	//JComboBox fotomotoCollection = new JComboBox();
	//JLabel fotomotoCollectionLabel = new JLabel();
	JLabel customSlideshowDelayLabel = new JLabel();
	JTextField customSlideshowDelay = new JTextField(4);
	JLabel customTransitionSpeedLabel = new JLabel();
	JTextField customTransitionSpeed = new JTextField(4);
	JTextArea shopOptionsLocal = new JSmartTextArea(4, 4);
	JScrollPane shopPane = new JScrollPane(shopOptionsLocal);
	JTextField shopDiscountRateLocal = new JTextField(4);
	JTextField shopQuantityCapLocal = new JTextField(4);
	
	@Override
	public void setAlbumObject(AlbumObject ao) {
			
		super.setAlbumObject(ao);
			
		if (ao != null) {
			Category cc = ao.getCategory();
			boolean lightboxable = cc != Category.folder && cc != Category.webPage && cc != Category.webLocation;
			
			panorama.setVisible(lightboxable);
			hideLocation.setVisible(lightboxable);
			customSlideshowDelayLabel.setVisible(lightboxable);
			customSlideshowDelay.setVisible(lightboxable);
			customTransitionSpeedLabel.setVisible(lightboxable);
			customTransitionSpeed.setVisible(lightboxable);
			//fotomotoCollection.setVisible(lightboxable);
			//fotomotoCollectionLabel.setVisible(lightboxable);
		}
	}
	
	public ImageDataUI(JAlbumContext context, SmartResourceBundle texts) {
		
		super(context);
		//setOpaque(true);
		panorama.setText(texts.getString("ui.panorama"));
		hideLocation.setText(texts.getString("ui.hideLocation"));
		//fotomotoCollection.addItem(new Item("", texts.getString("ui.default") + " (" + texts.getString("ui.forSale") + ")"));
		//fotomotoCollection.addItem(new Item("notForSale", texts.getString("ui.notForSale")));
		//fotomotoCollection.addItem(new Item("shareOnly", texts.getString("ui.shareOnly")));
		//fotomotoCollection.addItem(new Item("forSale", texts.getString("ui.forSale")));
		//fotomotoCollection.setEditable(true);
		//fotomotoCollectionLabel.setText(texts.getString("ui.fotomotoCollection"));
		customSlideshowDelayLabel.setText(texts.getString("ui.slideshowDelay"));
		customSlideshowDelay.setToolTipText(texts.getString("ui.customSlideshowDelayInfo") + " " + texts.getString("ui.leaveEmptyForDefault"));
		customTransitionSpeedLabel.setText(texts.getString("ui.transitionSpeed"));
		customTransitionSpeed.setToolTipText(texts.getString("ui.customTransitionSpeedInfo") + " " + texts.getString("ui.leaveEmptyForDefault"));
		shopDiscountRateLocal.setToolTipText(texts.getString("ui.shopDiscountRateInfo1"));
		shopOptionsLocal.setToolTipText(texts.getString("ui.shopOptionsInfo"));
		shopOptionsLocal.setText("");
		shopOptionsLocal.setEditable(true);
		shopOptionsLocal.setLineWrap(true);
		shopOptionsLocal.setWrapStyleWord(true);

		add("", panorama);
		add("br", hideLocation);
		//add("br", fotomotoCollectionLabel);
		//add("tab", fotomotoCollection);
		add("br", customSlideshowDelayLabel);
		add("tab", customSlideshowDelay);
		add("br", customTransitionSpeedLabel);
		add("tab", customTransitionSpeed);
		add("br", new JLabel(texts.getString("ui.shopOptions")));
		add("br hfill vfill", shopPane);
		add("br", new JLabel(texts.getString("ui.shopDiscountRate")));
		add("tab", shopDiscountRateLocal);
		add(new JLabel("%"));
		add("br", new JLabel(texts.getString("ui.shopQuantityCap")));
		add("tab", shopQuantityCapLocal);

		init();
	}
}
