package lizard;

import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JCustomPanel;
import se.datadosen.util.SmartResourceBundle;


/**
 *
 * @author Laza
 */

public class ExternalContentUI extends JCustomPanel {

	private WrappableJLabel memo = new WrappableJLabel();
	JTextArea externalContent = new JSmartTextArea(8, 12);
	JScrollPane externalContentPane = new JScrollPane(externalContent);
	JTextField externalContentSize = new JSmartTextField(8);
	JLabel externalContentSizeLabel = new JLabel();
	private final Font mono = new Font("monospaced", Font.PLAIN, 12);

	@Override
	public void setAlbumObject(AlbumObject ao) {
			
		super.setAlbumObject(ao);

		if (ao != null) {
			Category cc = ao.getCategory();
			boolean lightboxable = cc != Category.folder && cc != Category.webPage && cc != Category.webLocation;

			externalContentSizeLabel.setEnabled(lightboxable);
			externalContentSize.setVisible(lightboxable);
		}
	}
	
	public ExternalContentUI(JAlbumContext context, SmartResourceBundle texts) {
		
		super(context);
		
		memo.setText(texts.getString("ui.externalContent"));
		memo.setPreferredWidth(180);		
		externalContent.setToolTipText(texts.getString("ui.externalContentInfo"));
		externalContent.setText("");
		externalContent.setEditable(true);
		externalContent.setLineWrap(false);
		externalContent.setTabSize(2);
		externalContent.setFont(mono);
		externalContentSize.setToolTipText(texts.getString("ui.externalContentSizeInfo"));
		externalContentSizeLabel.setText(texts.getString("ui.externalContentSize"));

		add(memo);
		add("br hfill vfill", externalContentPane);
		add("br", externalContentSizeLabel);
		add("tab", externalContentSize);

		init();
	}
}
