<%
	var safeTitle = stripHTML(title).replace(/"/g, '&quot;').replace(/ & /g, ' &amp; '),				//" fixing syntax highlighting :)
		safeDescription = stripHTML((pageType === 'page')? comment : description).replace(/"/g, '&quot;').replace(/ & /g, ' &amp; '), 	//"
		safeThumbPath = (typeof pageThumbPath === UNDEF)? shareImageFilename : pageThumbPath;
		 // No predefined sections order
		sectionsOrder = (typeof sectionsOrder === 'undefined')? 'newImages\ttags\tmap\titems\tshoppingCart\tneighboringFolders\tcommenting\tfeedback\tcustomContent' : sectionsOrder,
		captionPlacement = (typeof captionPlacement === 'undefined')? 'below' : captionPlacement,
		captionStyle =  (typeof captionStyle === 'undefined')? 'dark' : captionStyle,
		folderMosaic = false,
		columns = 4;
	
	out.println('<!doctype html>' +
		'\n<html ' + (shareFacebook? 'prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb#" ' : '') + 'lang="' + language + '"' + ' class="no-js" data-level="' + level + '">' +
		'\n\t<!-- Generated by jAlbum app (https://jalbum.net) -->');
	
	/*********************************************************************************
	 *									HEAD
	 */
	
	out.println('\t<head>');
	
		out.println('\t\t<meta charset="' + textEncoding + '">');
		out.println('\t\t<meta http-equiv="x-ua-compatible" content="ie=edge">');
		out.println('\t\t<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">');
		
		// Preloading icon font
		out.println('\t\t<link rel="preload" href="' + resPath + '/icon/skinicon-' + iconStyle + '.woff?v' + skinVersion + '" as="font" type="font/woff" crossorigin>');
		out.println('\t\t<link rel="preload" href="' + resPath + '/icon/skinicon-' + iconStyle + '.ttf?v' + skinVersion + '" as="font" type="font/ttf" crossorigin>');
		
		// Google font
		if (typeof googleFont !== UNDEF && !!googleFont && copyGoogleFonts !== UNDEF && !copyGoogleFonts) {
			out.println('\t\t<link rel="preload" href="https://fonts.googleapis.com/css?family=' + googleFont + '" as="style">');
			out.println('\t\t<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=' + googleFont + '">');
		}
		
		// Title
		out.println('\t\t<title>' + [ safeTitle, titleSEOText ].filter(Boolean).join(' ') + '</title>');
		
		// Description
		out.println('\t\t<meta name="description" content="' + [ safeDescription || safeTitle, descriptionSEOText ].filter(Boolean).join(' ') + '">');
		
		// Author
		if (typeof writer !== UNDEF && writer) {
			out.println('\t\t<meta name="author" content="' + writer + '">');
		}
		
		// Generator
		out.println('\t\t<meta name="generator" content="' + [ 'jAlbum', internalVersion, '&', skinName, skinVersion, ('[' + styleName + ']') ].filter(Boolean).join(' ') + '">');
		
		// Keywords, tags
		var k = [];
		
		if (typeof keywords !== UNDEF && keywords) {
			k.push(keywords);
		}
		
		if (typeof albumTags !== UNDEF && albumTags) {
			k.push(albumTags);
		}
		
		if (k.length) {
			out.println('\t\t<meta name="keywords" content="' + k.join(' ') + '">');
		}
		
		// Folder thumbnail
		if (typeof pageUrl !== UNDEF && pageUrl) {
			out.println('\t\t<meta property="og:url" content="' + pageUrl + '">');
		}
		
		if (typeof hasFolderImage !== UNDEF && hasFolderImage) {
			out.println('\t\t<meta property="og:image" content="' + safeThumbPath + '">');
			
			if (pageProtocol === 'https:') {
				out.println('\t\t<meta property="og:image:secure_url" content="' + safeThumbPath + '">');
			}
			
			out.println('\t\t<meta property="og:image:width" content="' + folderThumbSize.split('x')[0] + '">');
			out.println('\t\t<meta property="og:image:height" content="' + folderThumbSize.split('x')[1] + '">');
			out.println('\t\t<link rel="image_src" href="' + safeThumbPath + '">');
			out.println('\t\t<meta name="twitter:image" content="' + safeThumbPath + '">');
		}
		
		// Title, description for OG
		out.println('\t\t<meta property="og:title" content="' + safeTitle + '">');
		out.println('\t\t<meta property="og:description" content="' + (safeDescription || safeTitle) + '">');
		
		// OG type
		out.println('\t\t<meta property="og:type" content="website">');
		
		// FB app ID
		if (facebookAppId) {
			out.println('\t\t<meta property="fb:app_id" content="' + facebookAppId + '">');
		}
		
		// Twitter-related meta tags
		out.println('\t\t<meta name="twitter:title" content="' + safeTitle + '">');
		out.println('\t\t<meta name="twitter:card" content="summary_large_image">');
		
		if (safeDescription) {
			out.println('\t\t<meta name="twitter:description" content="' + (safeDescription || safeTitle) + '">');
		}
		
		// Mobile-related meta
		out.println('\t\t<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">');
		out.println('\t\t<meta name="mobile-web-app-capable" content="yes">');
		out.println('\t\t<meta name="format-detection" content="telephone=no">');
		
		out.println('\t\t<link rel="manifest" href="' + resPath + '/site.webmanifest" crossorigin="use-credentials">');
		
		// Favicon
		if (useFavicon) {
			out.println('\t\t<link rel="apple-touch-icon" sizes="180x180" href="' + resPath + '/apple-touch-icon.png">');
			out.println('\t\t<link rel="icon" type="image/png" sizes="32x32" href="' + resPath + '/favicon-32x32.png">');
			out.println('\t\t<link rel="icon" type="image/png" sizes="16x16" href="' + resPath + '/favicon-16x16.png">');
			out.println('\t\t<link rel="mask-icon" href="' + resPath + '/safari-pinned-tab.svg" color="' + mainBgColor + '">');
			out.println('\t\t<link rel="icon" href="' + resPath + '/favicon.ico">');
			out.println('\t\t<meta name="msapplication-config" content="' + resPath + '/browserconfig.xml">');
		}
		
		out.println('\t\t<meta name="theme-color" content="' + mainBgColor + '">');
		out.println('\t\t<meta name="msapplication-TileColor" content="' + mainBgColor + '">');
	
		// Leaflet :: Open Street Map 
		if (_useMap && !googleApiKey && !avoidCDNs) {
			out.println('\t\t<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />');
		}
	
		// The main CSS file
		out.println('\t\t<link rel="stylesheet" href="' + resPath + '/common.css?v=' + skinVersion + '">');
		
		// Custom page-related CSS
		getCustomPageCSS(currentObject);
		
		if (headHook) {
			out.println('\t\t' + getProcessed(headHook));
		}
		
		if (googleAnalytics === 'gtag') {
			out.println('\t\t<script async src="https://www.googletagmanager.com/gtag/js?id=' + googleSiteID + '"></script>');
			out.println('\t\t<script>');
				out.println('\t\t\twindow.dataLayer=window.dataLayer||[];');
				out.println('\t\t\tfunction gtag(){dataLayer.push(arguments);}');
				out.println('\t\t\tgtag(\'js\',new Date());');
				out.println('\t\t\tgtag(\'config\',\'' + googleSiteID + '\',{\'send_page_view\':false});');
			out.println('\t\t</script>');
		}
		
	out.println('\t</head>');

	/*********************************************************************************
	 *									BODY
	 */
	 
		out.println('\t<body id="' + pageType + '" class="' + [
					pageType,
					'scrollable', 
					'stop-transitions',
					lightStyle? 'light-mode' : 'dark-mode',
					'style-' + styleName.toLowerCase(),
					level? 'sub-album' : 'top-level',
					'icon-' + iconStyle,
					(pageType === 'page')? pageHook : '',
					(typeof lightboxUseMainBg !== UNDEF && lightboxUseMainBg)? 'use-mainbg' : ''
				].filter(Boolean).join(' ') + '">');
			
		out.print(getInclude('top-bar.inc'));
		
		/*********************************************************************************
		 *								Main content
		 */
		
		out.println('\t\t<section id="main" class="content">');
			out.println('\t\t\t<article id="main-cont" class="' + [
						((pageType === 'index' || pageHook === 'newimages-page')? 'layer base-overlay' : ''),
						((pageType === 'page')? 'page-wrap' : '')
					].filter(Boolean).join(' ') + '">');
			
			if (pageType === 'page') {
				out.println('\t\t\t\t<section>');
			}
%>