<% // Newimages.htt skin specific part
	var thumbs = [],										// Thumbnails buffer
		dmax = newImagesDays * 24 * 60 * 60 * 1000,			// Difference in ms
		n = 0,
		start = (typeof skippedCount === 'undefined')? 0 : skippedCount,
		preload = (typeof preloadThumbs === 'undefined')? 20 : preloadThumbs,
		
		getTitle = function() {
				var s;
				
				switch (newImagesSource) {
					case 'dateTaken':
						s = getText('imagesTaken');
						break;
					case 'fileModified':
						s = getText('imagesModified');
						break;
					default:
						s = getText('imagesAdded');
				}
				
				return s + ' ' + getTimespan(newImagesDays); 
			},
		
		writeOutThumbnails = function() {

					//print('Writing out thumbs [' + thumbs.length + ']');

					out.print('\t\t\t\t<h4>' + getTitle() + '</h4>' +
						'<section class="thumbnails">' +
						'<div class="clip">' +
						'<div class="thumb-cont">');

					for (var i = 0; i < thumbs.length; i++) {
						var ao		= thumbs[i];

						if (isSimpleObject(ao) && ao.isIncluded()) {						

							var vars 	= ao.getVars(),
								c		= stripHTML(vars.get('thumbCaption'));
								alt 	= addAltTags? (' alt="' + stripHTML(vars.get('title')).trim() + '"') : '',
								rp		= thumbs[i].getPathFrom(currentFolder),
								t 		= stripHTML(vars.get('title')) || vars.get('label');

							out.print('<a class="thumb ' +
								((n >= preloadThumbs)? 'lazyload' : 'preload') + '"' + 
								' href="' + vars.get('imagePath') + '"' + 
								' data-path="' + getEncodedPathFromRoot(ao) + '"' +
								(c? (' title="' + c + '"') : '') + 
								'>');
							
							if (n < preload) {
								out.print('<img src="' + vars.get('thumbPath') + 
									'" alt="' + alt + '">');
							}
							
							out.print('</a>');
						}
						
						n++;
					}

					out.println('\t\t\t\t\t\t</div></section>');
				},
				
			sortThumbnails = function() {
				
					if (newImagesSort === 'date') {
						if (newImagesReverse) {
							thumbs.sort(function(a, b) {
									return  a['refDate'] - b['refDate'];
								});
						} else {
							thumbs.sort(function(a, b) {
									return  b['refDate'] - a['refDate'];
								});
						}
					} else if (newImagesSort === 'random') {
						thumbs.sort(function() {
								return  0.5 - Math.random();
							});
					}
				},
				
			// Gathering new images		
			
			gatherNew = function(folder) {
				
					var images = folder.getChildren(),
						ao,
						cat,				// Category
						now = new Date(),
						d;
				
					for (var i = start; i < images.length; i++) {
	
						ao = images[i];
						
						if (ao.isIncluded()) {
							cat = ao.getCategory();
							//print(ao.getName() + ' [' + cat + ']');
		
							if (cat === Category.folder) {
								if (newImagesDepth !== 'current' && !ao.isHidden()) {
									gatherNew(ao);
								}
							} else if (cat === Category.image || cat === Category.other ||
								cat === Category.audio || cat === Category.video) {
								
								if (newImagesSource === 'added') {
									d = ao.getWhenAdded();
								} else if (newImagesSource === 'dateTaken') {
									d = getEpochDate(ao, false);
								} else {
									d = ao.getLastModified();
								}
								
								if (d && (now - d) <= dmax) {
									ao['refDate'] = d;
									thumbs.push(ao);
								}
							}
						}
					}
				};
		
	if (newImagesDays) {
			
		gatherNew((newImagesDepth === 'tree')? rootFolder : currentFolder);
		
		if (newImagesSort !== 'original') {
			sortThumbnails();
		}
		
		writeOutThumbnails();
	}

%>