import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.ModifiesSize;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.awt.Dimension;
import se.datadosen.util.*;

/**
 * JAlbum image filter wrapper that applies the properties set
 * in the vars parameter to each matching setter method of the containing filter.
 * This filter wrapper, for instance allows an application to apply different filter
 * settings to each image by setting properties in the "current" object.
 * @author David Ekholm
 */
public class PropertySettingFilterWrapper implements JAFilter, ModifiesSize {
	JAFilter filter;

	public PropertySettingFilterWrapper(JAFilter filter) {
		this.filter = filter;
	}

	/** For XML serializer only */
	public PropertySettingFilterWrapper() {
	}
	
	/** For XML serializer only */
	public JAFilter getFilter() {
		return filter;
	}
	
	/** For XML serializer only */
	public void setFilter(JAFilter filter) {
		this.filter = filter;
	}

		// Implements JAFilter
    public String getName() {
        return filter.getName() + " (wrapped)";
    }

		// Implements JAFilter
    public String getDescription() {
        return filter.getDescription();
    }

		// Implements JAFilter
    public synchronized BufferedImage filter(BufferedImage bi, java.util.Map vars) {
		// Cool way to make this filter accept parameters passed as image specific variables
		try {
			BeanBinder.setProperties(filter, vars);
		}
		catch (BeanBinderException ex) {
			ex.printStackTrace(System.err);
		}
		return filter.filter(bi, vars);
    }

	// Implements ModifiesSize
	public Dimension getModifiedSize(Dimension originalSize, Map vars) {
		if (filter instanceof ModifiesSize) return ((ModifiesSize)filter).getModifiedSize(originalSize, vars);
		else return originalSize;
	}

}
