import se.datadosen.jalbum.*;

import java.awt.*;
import java.awt.image.BufferedImage;

import java.util.*;

/**
 * JAlbum filter that makes sure that all images/thumbnails stay within a specified area
 * (number of pixels)
 * @author David Ekholm
 * @version 1.0
 */
public class LimitAreaFilter implements JAFilter, ModifiesSize {
	
	private float megaPixels;
	
    public String getName() {
        return "Limit area filter";
    }

    // Implements JAFilter
    public String getDescription() {
        return "Makes all images stay within a specified number of pixels";
    }

    // Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
    	bi = doFilter(bi, vars);
    	return bi;
    }

    public void setArea(float megaPixels) {
    	this.megaPixels=megaPixels;
    }

    public float getArea() {
        return megaPixels;
    }

    // Implements JAFilter
    private BufferedImage doFilter(BufferedImage bi, java.util.Map vars) {    	
        Dimension sDim = new Dimension(bi.getWidth(), bi.getHeight());
        Dimension dDim = getModifiedSize(sDim, vars);
        if (dDim.equals(sDim)) {
        	return bi;	
        }

        AlbumBean engine = (AlbumBean)vars.get("engine");
        AlbumImage ai = new AlbumImage(bi, engine);
        return ai.scaleToFit(dDim).getBufferedImage();
    }

    // Implements ModifiesSize
    public Dimension getModifiedSize(Dimension originalSize, java.util.Map vars) {    	
    	int area = (int)(megaPixels * 1000 * 1000);
    	if (originalSize.width * originalSize.height <= area) {
    		return originalSize;
    	}
    	float ratio = (float)originalSize.width / (float)originalSize.height;
    	
    	double newHeight = Math.sqrt(area/ratio);
    	double newWidth = newHeight * ratio;
    	return new Dimension((int)newWidth, (int)newHeight);
    }
}
