import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.*;
import java.awt.color.ColorSpace;

/**
 * Title:        JAlbum grayscale image filter making an image grayscale
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class GrayscaleFilter implements JAFilter {

		// Implements JAFilter
    public String getName() {
        return "Grayscale filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Make an image grayscale";
    }

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
				Graphics2D g = bi.createGraphics();
				RenderingHints rhs = g.getRenderingHints();

				ColorSpace cs = ColorSpace.getInstance(ColorSpace.CS_GRAY);
				ColorConvertOp theOp = new ColorConvertOp(cs, rhs);

				BufferedImage dstImg =
								new BufferedImage(bi.getWidth(), bi.getHeight(), getSuitableType(bi));
				theOp.filter(bi, dstImg);
				g.dispose();
				return dstImg;
    }
    
    private static int getSuitableType(BufferedImage bi) {
    	return bi.getTransparency() == BufferedImage.OPAQUE ? BufferedImage.TYPE_INT_RGB : BufferedImage.TYPE_INT_ARGB;
    }
}
