import se.datadosen.jalbum.*;

import java.awt.*;
import java.awt.image.BufferedImage;

import java.util.*;

/**
 * Crop images to specified dimension
 * @author David Ekholm, jAlbum 2009
 * @since 8.4.2
 * @version 1.0
 */
public class CropFilter implements JAFilter, ModifiesSize {
	
	private Dimension bounds = new Dimension(120,120);
    private float xWeight = 0.5f;
    private float yWeight = 0.2f;    
    
	public String getName() {
	    return "Crop filter";
	}

    // Implements JAFilter
    public String getDescription() {
        return "Crops images to specified dimension";
    }

    public Dimension getBounds() {
        return bounds;
    }

    public void setBounds(Dimension bounds) {
        this.bounds = bounds;
    }

    public float getXWeight() {
        return xWeight;
    }

    /**
     * Control what area of the image to use when cropping occurs
     * Defaults to 50%, i.e focus on the middle part of the source image
     * Can be overridden by the "xWeight" user variable
     * @since 1.1
     */
    public void setXWeight(float weight) {
        this.xWeight = weight;
    }
    
    public float getYWeight() {
        return yWeight;
    }

     /**
     * Control what area of the image to use when cropping occurs
     * Defaults to 20%, i.e focus on the topmost part of the source image
     * Can be overridden by the "yWeight" user variable
     * @since 1.1
     */
    public void setYWeight(float weight) {
        this.yWeight = weight;
    }

    private Dimension minDimension(Dimension d1, Dimension d2) {
        return new Dimension(
            Math.min(d1.width, d2.width),
            Math.min(d1.height, d2.height));
    }

    // Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
//        System.out.println(vars);
        Dimension sDim = new Dimension(bi.getWidth(), bi.getHeight());
        Dimension dDim = minDimension(sDim, bounds);

        float hw = xWeight;
        if (vars.containsKey("xWeight")) {
            hw = Float.parseFloat((String)vars.get("xWeight"));
        }
        float vw = yWeight;
        if (vars.containsKey("yWeight")) {
            vw = Float.parseFloat((String)vars.get("yWeight"));
        }
        
        return bi.getSubimage(
            (int)((sDim.width-dDim.width)*hw),
            (int)((sDim.height-dDim.height)*vw),
            dDim.width, dDim.height);
    }

    // Implements ModifiesSize
    public Dimension getModifiedSize(Dimension originalSize, Map vars) {
        return minDimension(originalSize, bounds);
    }
}
