/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.libraries;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.SymbolLookup;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.jalbum.libraries.Platform;

public class LookupService {
    public static SymbolLookup libraryLookup(String libBaseName, Arena arena, Class baseClass) {
        String os;
        String string = Platform.isWindows() ? "win64" : (Platform.isLinux() ? "linux64" : (os = Platform.isMac() ? "macos64" : null));
        if (os == null) {
            throw new UnsupportedOperationException("Unsupported operating system.");
        }
        String prefix = "lib";
        String libName = prefix + libBaseName;
        String extension = Platform.isWindows() ? ".dll" : (Platform.isLinux() ? ".so" : (Platform.isMac() ? ".dylib" : ""));
        String resourcePath = "/native/" + os + "/" + System.getProperty("os.arch") + "/" + libName + extension;
        InputStream inputStream = baseClass.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            String msg = "jlibraw2: Couldn't find " + resourcePath + " in " + baseClass.getProtectionDomain().getCodeSource().getLocation().getFile();
            System.err.println(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            File tempFile = File.createTempFile(libName, extension);
            tempFile.deleteOnExit();
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return SymbolLookup.libraryLookup(tempFile.getAbsolutePath(), arena);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex);
            throw ex;
        }
    }
}

