/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jlibraw;

import java.io.Serializable;
import java.util.Objects;
import javax.imageio.ImageReadParam;
import net.jalbum.jlibraw.Gamma;
import net.jalbum.jlibraw.OutputColorSpace;
import net.jalbum.jlibraw.WBPresets;

public class RAWImageReadParam
extends ImageReadParam
implements Serializable,
Cloneable {
    private WBPresets whiteBalance = WBPresets.AS_SHOT;
    private boolean exposureCorrect = true;
    private float exposureShift = 0.0f;
    private float exposurePreserveHighlights = 0.0f;
    private float brightness = 1.0f;
    private Gamma gamma = Gamma.BT709;
    private double gammaPower = this.gamma.getPower();
    private double gammaSlope = this.gamma.getSlope();
    private OutputColorSpace outputColorSpace = OutputColorSpace.SRGB;

    public WBPresets getWhiteBalance() {
        return this.whiteBalance;
    }

    public void setWhiteBalance(WBPresets whiteBalance) {
        this.whiteBalance = whiteBalance;
    }

    public boolean isExposureCorrect() {
        return this.exposureCorrect;
    }

    public void setExposureCorrect(boolean exposureCorrect) {
        this.exposureCorrect = exposureCorrect;
    }

    public double getExposureShift() {
        return this.exposureShift;
    }

    public void setExposureShift(double exposureShift) {
        this.exposureShift = (float)exposureShift;
    }

    public double getExposurePreserveHighlights() {
        return this.exposurePreserveHighlights;
    }

    public double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(double brightness) {
        this.brightness = (float)brightness;
    }

    public void setExposurePreserveHighlights(double exposurePreserveHighlights) {
        this.exposurePreserveHighlights = (float)exposurePreserveHighlights;
    }

    public double getGammaPower() {
        return this.gammaPower;
    }

    public void setGammaPower(double gammaPower) {
        this.gammaPower = gammaPower;
    }

    public double getGammaSlope() {
        return this.gammaSlope;
    }

    public void setGammaSlope(double gammaSlope) {
        this.gammaSlope = gammaSlope;
    }

    public void setGamma(Gamma gamma) {
        this.gamma = gamma;
        this.gammaPower = gamma.getPower();
        this.gammaSlope = gamma.getSlope();
    }

    public Gamma getGamma() {
        return this.gamma;
    }

    public OutputColorSpace getOutputColorSpace() {
        return this.outputColorSpace;
    }

    public void setOutputColorSpace(OutputColorSpace outputColorSpace) {
        this.outputColorSpace = outputColorSpace;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode((Object)this.whiteBalance);
        hash = 53 * hash + (this.exposureCorrect ? 1 : 0);
        hash = 53 * hash + Float.floatToIntBits(this.exposureShift);
        hash = 53 * hash + Float.floatToIntBits(this.exposurePreserveHighlights);
        hash = 53 * hash + Float.floatToIntBits(this.brightness);
        hash = 53 * hash + Objects.hashCode((Object)this.gamma);
        hash = 53 * hash + (int)(Double.doubleToLongBits(this.gammaPower) ^ Double.doubleToLongBits(this.gammaPower) >>> 32);
        hash = 53 * hash + (int)(Double.doubleToLongBits(this.gammaSlope) ^ Double.doubleToLongBits(this.gammaSlope) >>> 32);
        hash = 53 * hash + Objects.hashCode((Object)this.outputColorSpace);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RAWImageReadParam other = (RAWImageReadParam)obj;
        if (this.whiteBalance != other.whiteBalance) {
            return false;
        }
        if (this.exposureCorrect != other.exposureCorrect) {
            return false;
        }
        if (Float.floatToIntBits(this.exposureShift) != Float.floatToIntBits(other.exposureShift)) {
            return false;
        }
        if (Float.floatToIntBits(this.exposurePreserveHighlights) != Float.floatToIntBits(other.exposurePreserveHighlights)) {
            return false;
        }
        if (Float.floatToIntBits(this.brightness) != Float.floatToIntBits(other.brightness)) {
            return false;
        }
        if (this.gamma != other.gamma) {
            return false;
        }
        if (Double.doubleToLongBits(this.gammaPower) != Double.doubleToLongBits(other.gammaPower)) {
            return false;
        }
        if (Double.doubleToLongBits(this.gammaSlope) != Double.doubleToLongBits(other.gammaSlope)) {
            return false;
        }
        return this.outputColorSpace == other.outputColorSpace;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static RAWImageReadParam clone(RAWImageReadParam param) {
        return param != null ? (RAWImageReadParam)param.clone() : null;
    }
}

