/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jlibraw;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.jalbum.jlibraw.LibRawImageReader;

public class LibRawImageReaderSpi
extends ImageReaderSpi {
    static final String vendorName = "JAlbum AB";
    static final String version = "0.1";
    static final String readerClassName = LibRawImageReader.class.getName();
    private static final String[][] formats = new String[][]{{"bay", "Casio Digital Camera Raw File Format", ""}, {"bmq", "NuCore Raw", ""}, {"cr2", "Canon Raw 2.0", "image/x-canon-cr2"}, {"crw", "Canon Raw 1.0", "image/x-canon-crw"}, {"cs1", "Capture Shop Raw", ""}, {"dc2", "Kodak DC25 Digital Camera File", ""}, {"dcr", "Kodak Raw", "image/x-dcr"}, {"dng", "Adobe Digital Negative", "image/x-adobe-dng"}, {"erf", "Epson Raw", ""}, {"fff", "Imacon Raw", ""}, {"hdr", "Leaf Raw", ""}, {"k25", "Kodak DC25 Raw", ""}, {"kdc", "Kodak Raw", "image/x-kdc"}, {"mdc", "Minolta RD175 Raw", ""}, {"mos", "Mamiya Raw", "image/x-raw"}, {"mrw", "Minolta Dimage Raw", ""}, {"nef", "Nikon Raw", "image/x-nikon-nef"}, {"orf", "Olympus Raw", ""}, {"pef", "Pentax Raw", ""}, {"pxn", "Logitech Raw", ""}, {"raf", "Fuji Raw", "image/x-fuji-raf"}, {"raw", "Panasonic Raw", ""}, {"rdc", "Digital Foto Maker Raw", ""}, {"sr2", "Sony Raw", ""}, {"srf", "Sony Raw (DSC-F828 and Sony DSC-R1)", ""}, {"x3f", "Sigma Raw", ""}, {"arw", "Sony Raw for Alpha devices", ""}, {"3fr", "Hasselblad Raw", ""}, {"cine", "Phantom Software Raw", ""}, {"ia", "Sinar Raw", ""}, {"kc2", "Kodak DCS200 Raw", ""}, {"mef", "Mamiya Raw", ""}, {"nrw", "Nikon Raw", ""}, {"qtk", "Apple Quicktake 100/150 Raw", ""}, {"rw2", "Panasonic LX3 Raw", "image/x-raw"}, {"sti", "Sinar Capture Shop Raw", ""}, {"rwl", "Leica Raw", ""}, {"srw", "Samsung Raw", ""}};
    static Set<String> supported = new HashSet<String>();
    static final String[] writerSpiNames;
    static final boolean supportsStandardStreamMetadataFormat = false;
    static final String nativeStreamMetadataFormatName;
    static final String nativeStreamMetadataFormatClassName;
    static final String[] extraStreamMetadataFormatNames;
    static final String[] extraStreamMetadataFormatClassNames;
    static final boolean supportsStandardImageMetadataFormat = false;
    static final String nativeImageMetadataFormatName = "net.jalbum.libraw.RAWMetadata_1.0";
    static final String nativeImageMetadataFormatClassName = "net.jalbum.libraw.RAWMetadata";
    static final String[] extraImageMetadataFormatNames;
    static final String[] extraImageMetadataFormatClassNames;

    private static String[] formatsSlice(int slice) {
        String[] arr = new String[formats.length];
        for (int i = 0; i < formats.length; ++i) {
            arr[i] = formats[i][slice];
        }
        return arr;
    }

    public LibRawImageReaderSpi() {
        super(vendorName, version, LibRawImageReaderSpi.formatsSlice(1), LibRawImageReaderSpi.formatsSlice(0), LibRawImageReaderSpi.formatsSlice(2), readerClassName, new Class[]{ImageInputStream.class}, writerSpiNames, false, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, false, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        return false;
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new LibRawImageReader(this, extension);
    }

    @Override
    public String getDescription(Locale locale) {
        return "RAW image reader";
    }

    public static boolean isFormatSupported(String extension) {
        return supported.contains(extension.toLowerCase());
    }

    static {
        for (String[] fmt : formats) {
            supported.add(fmt[0]);
        }
        writerSpiNames = new String[0];
        nativeStreamMetadataFormatName = null;
        nativeStreamMetadataFormatClassName = null;
        extraStreamMetadataFormatNames = null;
        extraStreamMetadataFormatClassNames = null;
        extraImageMetadataFormatNames = null;
        extraImageMetadataFormatClassNames = null;
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i][2].equals("")) continue;
            LibRawImageReaderSpi.formats[i][2] = "image/x-" + formats[i][0];
        }
    }
}

