/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jlibraw;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.jalbum.jlibraw.RAWImageReadParam;
import net.jalbum.libraw4j.LibRaw;
import net.jalbum.libraw4j.libraw_data_t;
import net.jalbum.libraw4j.libraw_image_sizes_t;
import net.jalbum.libraw4j.libraw_output_params_t;
import net.jalbum.libraw4j.libraw_processed_image_t;

public class LibRawImageReader
extends ImageReader {
    private ImageInputStream iis = null;
    Arena arena = Arena.ofConfined();
    MemorySegment retSegment = this.arena.allocateFrom(ValueLayout.JAVA_INT, 0);
    MemorySegment data;
    private int width;
    private int height;
    private int currentImage = -1;

    public LibRawImageReader(ImageReaderSpi originatingProvider, Object extension) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.iis = (ImageInputStream)input;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public String getFormatName() throws IOException {
        return "RAW File Format";
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        if (this.currentImage != imageIndex) {
            this.readInitial(imageIndex, true);
        }
        return this.width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        if (this.currentImage != imageIndex) {
            this.readInitial(imageIndex, true);
        }
        return this.height;
    }

    private boolean isPortrait() {
        MemorySegment sizes = libraw_data_t.sizes(this.data);
        int flip = libraw_image_sizes_t.flip(sizes);
        switch (flip) {
            case -270: 
            case -90: 
            case 5: 
            case 6: 
            case 90: 
            case 270: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        ImageTypeSpecifier imageType = ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1000), new int[]{0, 1, 2}, 0, false, false);
        l.add(imageType);
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        throw new UnsupportedOperationException("Reading metadata from RAW files not supported yet.");
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        throw new UnsupportedOperationException("Reading metadata from RAW files not supported yet.");
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new RAWImageReadParam();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        MemorySegment params;
        Rectangle crop;
        if (this.currentImage != imageIndex) {
            this.readInitial(imageIndex, true);
        }
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        if ((crop = param.getSourceRegion()) != null) {
            params = libraw_data_t.params(this.data);
            libraw_output_params_t.cropbox(params, 0L, crop.x);
            libraw_output_params_t.cropbox(params, 1L, crop.y);
            libraw_output_params_t.cropbox(params, 2L, crop.width);
            libraw_output_params_t.cropbox(params, 3L, crop.height);
        }
        if (param.getSourceXSubsampling() > 1) {
            params = libraw_data_t.params(this.data);
            libraw_output_params_t.half_size(params, 1);
        }
        if (param instanceof RAWImageReadParam) {
            RAWImageReadParam rawParam = (RAWImageReadParam)param;
            MemorySegment params2 = libraw_data_t.params(this.data);
            switch (rawParam.getWhiteBalance()) {
                case AS_SHOT: {
                    libraw_output_params_t.use_camera_wb(params2, 1);
                    libraw_output_params_t.use_auto_wb(params2, 0);
                    break;
                }
                case AUTO: {
                    libraw_output_params_t.use_camera_wb(params2, 0);
                    libraw_output_params_t.use_auto_wb(params2, 1);
                    break;
                }
                default: {
                    libraw_output_params_t.use_camera_wb(params2, 0);
                    libraw_output_params_t.use_auto_wb(params2, 0);
                    float[] multipliers = rawParam.getWhiteBalance().getMultipliers();
                    MemorySegment userMul = libraw_output_params_t.user_mul(params2);
                    for (int i = 0; i < multipliers.length; ++i) {
                        userMul.setAtIndex(ValueLayout.JAVA_FLOAT, (long)i, multipliers[i]);
                    }
                }
            }
            libraw_output_params_t.bright(params2, (float)rawParam.getBrightness());
            MemorySegment gamma = libraw_output_params_t.gamm(params2);
            gamma.setAtIndex(ValueLayout.JAVA_DOUBLE, 0L, rawParam.getGammaPower());
            gamma.setAtIndex(ValueLayout.JAVA_DOUBLE, 1L, rawParam.getGammaSlope());
            libraw_output_params_t.exp_correc(params2, rawParam.isExposureCorrect() ? 1 : 0);
            libraw_output_params_t.exp_shift(params2, (float)Math.pow(2.0, rawParam.getExposureShift() + 1.0));
            libraw_output_params_t.exp_preser(params2, (float)rawParam.getExposurePreserveHighlights());
            libraw_output_params_t.output_color(params2, rawParam.getOutputColorSpace().ordinal());
        }
        int res = LibRaw.libraw_unpack(this.data);
        LibRawImageReader.checkError(res);
        res = LibRaw.libraw_dcraw_process(this.data);
        LibRawImageReader.checkError(res);
        MemorySegment processedImage = LibRaw.libraw_dcraw_make_mem_image(this.data, this.retSegment);
        LibRawImageReader.checkError(this.retSegment.get(ValueLayout.JAVA_INT, 0L));
        BufferedImage bi = LibRawImageReader.createBufferedImage(processedImage);
        LibRaw.libraw_dcraw_clear_mem(processedImage);
        return bi;
    }

    @Override
    public BufferedImage readThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        BufferedImage thumb = this.doReadThumbnail(imageIndex, thumbnailIndex);
        MemorySegment sizes = libraw_data_t.sizes(this.data);
        int flip = libraw_image_sizes_t.flip(sizes);
        switch (flip) {
            case 3: {
                return LibRawImageReader.rotate180(thumb);
            }
            case 5: {
                return LibRawImageReader.rotateLeft(thumb);
            }
            case 6: {
                return LibRawImageReader.rotateRight(thumb);
            }
        }
        return thumb;
    }

    private static BufferedImage rotate180(BufferedImage bi) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-bi.getWidth(), -bi.getHeight());
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(bi, null);
    }

    private static BufferedImage rotateLeft(BufferedImage bi) {
        AffineTransform rot270Transform = AffineTransform.getRotateInstance(4.71238898038469);
        rot270Transform.translate(-bi.getWidth(), 0.0);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot270Transform, hints);
        return op.filter(bi, null);
    }

    private static BufferedImage rotateRight(BufferedImage bi) {
        AffineTransform rot90Transform = AffineTransform.getRotateInstance(1.5707963267948966);
        rot90Transform.translate(0.0, -bi.getHeight());
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot90Transform, hints);
        return op.filter(bi, null);
    }

    private BufferedImage doReadThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        if (this.currentImage != imageIndex) {
            this.readInitial(imageIndex, true);
        }
        int ret = LibRaw.libraw_unpack_thumb(this.data);
        LibRawImageReader.checkError(ret);
        MemorySegment processedImage = LibRaw.libraw_dcraw_make_mem_thumb(this.data, this.retSegment);
        LibRawImageReader.checkError(this.retSegment.get(ValueLayout.JAVA_INT, 0L));
        BufferedImage bi = LibRawImageReader.createBufferedImage(processedImage);
        LibRaw.libraw_dcraw_clear_mem(processedImage);
        if (bi != null) {
            return bi;
        }
        throw new IOException("No thumbnail image available");
    }

    @Override
    public int getNumThumbnails(int imageIndex) throws IOException {
        return 1;
    }

    @Override
    public void dispose() {
        if (this.data != null) {
            LibRaw.libraw_recycle(this.data);
            this.data = null;
        }
        this.arena.close();
    }

    private void readInitial(int imageIndex, boolean reset) throws IOException {
        int read;
        this.data = LibRaw.libraw_init(0);
        if (this.iis == null) {
            throw new IllegalStateException("Input not set");
        }
        MemorySegment fileData = this.arena.allocate(ValueLayout.JAVA_BYTE, this.iis.length());
        ByteBuffer dstBuf = fileData.asByteBuffer();
        byte[] buf = new byte[0x100000];
        while ((read = this.iis.read(buf)) != -1) {
            dstBuf.put(buf, 0, read);
        }
        int result = LibRaw.libraw_open_buffer(this.data, fileData, fileData.byteSize());
        LibRawImageReader.checkError(result);
        result = LibRaw.libraw_adjust_sizes_info_only(this.data);
        LibRawImageReader.checkError(result);
        MemorySegment sizes = libraw_data_t.sizes(this.data);
        this.width = libraw_image_sizes_t.iwidth(sizes);
        this.height = libraw_image_sizes_t.iheight(sizes);
        LibRaw.libraw_recycle(this.data);
        LibRawImageReader.checkError(result);
        result = LibRaw.libraw_open_buffer(this.data, fileData, fileData.byteSize());
        LibRawImageReader.checkError(result);
        this.currentImage = imageIndex;
    }

    private static void checkError(int errCode) throws IOException {
        if (errCode != 0) {
            throw new IOException("Error " + errCode + ": " + LibRaw.libraw_strerror(errCode).getString(0L));
        }
    }

    private static BufferedImage createBufferedImage(MemorySegment processed) {
        short width = libraw_processed_image_t.width(processed);
        short height = libraw_processed_image_t.height(processed);
        int size = libraw_processed_image_t.data_size(processed);
        if (width == 0 | height == 0) {
            return null;
        }
        BufferedImage bi = new BufferedImage(width, height, 1);
        int[] dest = bi.getRGB(0, 0, width, height, null, 0, width);
        MemorySegment data = processed.asSlice(libraw_processed_image_t.data_size$offset(), size);
        byte[] src = data.toArray(ValueLayout.JAVA_BYTE);
        for (int i = 0; i < size; i += 3) {
            int rgb;
            dest[i / 3] = rgb = (0xFF & src[i + 1]) << 16 | (0xFF & src[i + 2]) << 8 | 0xFF & src[i];
        }
        bi.setRGB(0, 0, width, height, dest, 0, width);
        return bi;
    }
}

