/*
 * Decompiled with CFR 0.152.
 */
package com.lazaworx.util;

import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.PermissionDeniedException;

public class DiskCache {
    private static final int BUFSIZE = 262144;
    private static final String DEFAULT_DB_NAME = "diskcache.json";
    private static final String PRIMARY_KEY = "primary";
    private static final String TARGET_KEY = "target";
    private File cacheDir;
    private String dbName;
    private DCException lastException;
    private Consumer<DCException> errorHandler;
    private Map<String, URL> urlList = new HashMap<String, URL>();
    private JsonObject db = new JsonObject();
    private JsonObject primaryContents;
    private JsonObject targetContents;

    public DiskCache(File primaryCacheDir) {
        this(primaryCacheDir, DEFAULT_DB_NAME);
    }

    public DiskCache(File primaryCacheDir, String dbName) {
        this.cacheDir = primaryCacheDir;
        if (dbName.indexOf(46) == -1) {
            dbName = dbName + ".json";
        }
        this.dbName = dbName;
        File dbFile = new File(primaryCacheDir, dbName);
        if (dbFile.exists()) {
            try (FileReader r = new FileReader(dbFile, Charset.forName("UTF8"));){
                this.db = (JsonObject)Jsoner.deserialize((Reader)r);
            }
            catch (JsonException | IOException ex) {
                Logger.getLogger(DiskCache.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.primaryContents = (JsonObject)this.db.get((Object)PRIMARY_KEY);
        this.targetContents = (JsonObject)this.db.get((Object)TARGET_KEY);
        if (this.primaryContents == null) {
            this.primaryContents = new JsonObject();
            this.db.put((Object)PRIMARY_KEY, (Object)this.primaryContents);
        }
        if (this.targetContents == null) {
            this.targetContents = new JsonObject();
            this.db.put((Object)TARGET_KEY, (Object)this.targetContents);
        }
    }

    public void onError(Consumer<DCException> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public DiskCache add(String url) {
        try {
            return this.add(new URL(url), null);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DiskCache add(URL url) {
        return this.add(url, null);
    }

    public DiskCache add(URL url, String localName) {
        if (localName == null) {
            localName = DiskCache.getName(url);
        }
        this.urlList.put(localName, url);
        return this;
    }

    public DiskCache add(File file) {
        return this.add(file, null);
    }

    public DiskCache add(File file, String localName) {
        try {
            return this.add(file.toURI().toURL(), localName);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int size() {
        return this.urlList.size();
    }

    public void clear() {
        this.urlList.clear();
    }

    public void refresh() throws DCException {
        this.refresh(false);
    }

    public void refresh(boolean abortOnError) throws OperationAbortedException, DCException {
        this.cacheDir.mkdirs();
        Map<String, File> contents = this.getContents();
        contents.entrySet().stream().forEach(e -> {
            if (!this.urlList.containsKey(e.getKey())) {
                ((File)e.getValue()).delete();
                this.primaryContents.remove(e.getKey());
            }
        });
        this.saveDB();
        this.lastException = null;
        this.urlList.entrySet().parallelStream().forEach(e -> {
            try {
                this.cacheFile((URL)e.getValue(), new File(this.cacheDir, (String)e.getKey()));
            }
            catch (IOException ex) {
                File localFile = new File(this.cacheDir, (String)e.getKey());
                DCException dce = new DCException((URL)e.getValue(), localFile, ex);
                if (!localFile.exists()) {
                    this.lastException = dce;
                }
                if (this.errorHandler != null) {
                    this.errorHandler.accept(dce);
                }
            }
            finally {
                this.saveDB();
            }
        });
        if (abortOnError && this.lastException != null) {
            throw new OperationAbortedException(this.lastException.getMessage());
        }
        if (this.lastException != null) {
            throw this.lastException;
        }
    }

    public DCException getLastException() {
        return this.lastException;
    }

    private static String getName(URL u) {
        String path;
        String name = path = u.getPath();
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex != -1) {
            name = path.substring(slashIndex + 1);
        }
        return URLDecoder.decode(name, Charset.forName("UTF8"));
    }

    public Map<String, File> getContents() {
        return DiskCache.getContents(this.cacheDir, this.primaryContents);
    }

    public void syncTo(File targetDir) throws IOException {
        targetDir.mkdirs();
        Map<String, File> src = this.getContents();
        Map<String, File> dest = DiskCache.getContents(targetDir, this.targetContents);
        dest.entrySet().forEach(e -> {
            if (!src.containsKey(e.getKey())) {
                ((File)e.getValue()).delete();
                this.targetContents.remove(e.getKey());
            }
        });
        this.saveDB();
        for (Map.Entry<String, File> e2 : src.entrySet()) {
            File targetFile = dest.get(e2.getKey());
            if (targetFile != null && targetFile.lastModified() >= e2.getValue().lastModified()) continue;
            try {
                IO.copyFile((File)e2.getValue(), (File)new File(targetDir, e2.getKey()));
                this.targetContents.put((Object)e2.getKey(), (Object)e2.getValue().lastModified());
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        this.saveDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File cacheFile(URL url, File dest) throws PermissionDeniedException, IOException {
        FileOutputStream fos;
        long lastModified;
        if (dest.isDirectory()) {
            dest = new File(dest, DiskCache.getName(url));
        }
        if (url.getProtocol().equals("file")) {
            try {
                IO.copyFile((File)Paths.get(url.toURI()).toFile(), (File)dest, (boolean)false);
                lastModified = dest.lastModified();
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (dest.exists()) {
            conn.setIfModifiedSince(dest.lastModified());
        }
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        lastModified = conn.getLastModified();
        if (conn.getResponseCode() == 304) {
            return dest;
        }
        File tmp = new File(dest.getParentFile(), dest.getName() + ".downloading");
        try {
            fos = new FileOutputStream(tmp);
        }
        catch (IOException ex) {
            throw new PermissionDeniedException("Can't write to " + dest, (Throwable)ex);
        }
        try {
            DiskCache.cacheFile(conn, fos);
            fos.close();
            tmp.renameTo(dest);
            if (lastModified != 0L) {
                dest.setLastModified(lastModified);
            }
        }
        catch (IOException ex) {
            tmp.delete();
            throw ex;
        }
        DiskCache diskCache = this;
        synchronized (diskCache) {
            this.primaryContents.put((Object)dest.getName(), (Object)lastModified);
        }
        return dest;
    }

    private static boolean cacheFile(HttpURLConnection conn, OutputStream out) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
            if (conn.getResponseCode() != 200) {
                throw new IOException("Error accessing " + conn.getURL() + ". Server reported " + conn.getResponseCode() + " " + conn.getResponseMessage());
            }
            BufferedOutputStream bout = new BufferedOutputStream(out);
            byte[] data = new byte[262144];
            int x = 0;
            while ((x = in.read(data, 0, data.length)) >= 0) {
                bout.write(data, 0, x);
            }
            bout.flush();
        }
        return true;
    }

    private static Map<String, File> getContents(File dir, JsonObject key) {
        HashMap<String, File> map = new HashMap<String, File>();
        for (Map.Entry e : key.entrySet()) {
            map.put((String)e.getKey(), new File(dir, (String)e.getKey()));
        }
        return map;
    }

    private void saveDB() {
        File dbFile = new File(this.cacheDir, this.dbName);
        if (this.primaryContents.isEmpty() && this.targetContents.isEmpty()) {
            dbFile.delete();
        } else {
            try (FileWriter w = new FileWriter(dbFile, Charset.forName("UTF8"));){
                this.db.toJson((Writer)w);
            }
            catch (IOException ex) {
                Logger.getLogger(DiskCache.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static class DCException
    extends IOException {
        private URL url;
        private File localFile;

        public DCException(URL url, File localFile, Throwable cause) {
            super("Error downloading " + url + " to " + localFile, cause);
            this.url = url;
            this.localFile = localFile;
        }

        public URL getURL() {
            return this.url;
        }

        public File getLocalFile() {
            return this.localFile;
        }

        public void showDialog(Component parent) {
            Debug.showFriendlyErrorDialog((Component)parent, (Throwable)this);
        }
    }
}

