/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.spellcheck;

import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class Language {
    public static final Language BULGARIAN = Language.of("bg");
    public static final Language CATALAN = Language.of("ca");
    public static final Language CZECH = Language.of("cs");
    public static final Language DANISH = Language.of("da");
    public static final Language DUTCH = Language.of("nl");
    public static final Language GERMAN = Language.of("de");
    public static final Language GREEK = Language.of("el");
    public static final Language ENGLISH_US = Language.of("en", "us");
    public static final Language ENGLISH_UK = Language.of("en", "gb");
    public static final Language SPANISH_SPAIN = Language.of("es");
    public static final Language ESTONIAN = Language.of("et");
    public static final Language PERSIAN = Language.of("fa");
    public static final Language FRENCH = Language.of("fr");
    public static final Language HEBREW = Language.of("he");
    public static final Language HINDI = Language.of("hi");
    public static final Language CROATIAN = Language.of("hr");
    public static final Language HUNGARIAN = Language.of("hu");
    public static final Language INDONESIAN = Language.of("id");
    public static final Language ITALIAN = Language.of("it");
    public static final Language KOREAN = Language.of("ko");
    public static final Language LITHUANIAN = Language.of("lt");
    public static final Language LATVIAN = Language.of("lv");
    public static final Language NORWEGIAN = Language.of("nb");
    public static final Language POLISH = Language.of("pl");
    public static final Language PORTUGUESE_BRAZIL = Language.of("pt", "br");
    public static final Language PORTUGUESE_PORTUGAL = Language.of("pt", "pt");
    public static final Language ROMANIAN = Language.of("ro");
    public static final Language RUSSIAN = Language.of("ru");
    public static final Language SLOVAK = Language.of("sk");
    public static final Language SLOVENIAN = Language.of("sl");
    public static final Language SERBIAN = Language.of("sr");
    public static final Language SWEDISH = Language.of("sv");
    public static final Language TURKISH = Language.of("tr");
    public static final Language UKRAINIAN = Language.of("uk");
    public static final Language VIETNAMESE = Language.of("vi");
    private final String code;
    private final String region;

    public static Language of(String code, String region) {
        StringPreconditions.checkNotNullEmptyOrBlank(code);
        StringPreconditions.checkNotNullEmptyOrBlank(region);
        return new Language(code.toLowerCase(), region.toUpperCase());
    }

    public static Language of(String code) {
        StringPreconditions.checkNotNullEmptyOrBlank(code);
        return new Language(code.toLowerCase(), null);
    }

    private Language(String code, @Nullable String region) {
        this.code = code;
        this.region = region;
    }

    public String code() {
        return this.code;
    }

    public Optional<String> region() {
        return Optional.ofNullable(this.region);
    }

    public String toString() {
        StringBuilder localeLanguage = new StringBuilder();
        localeLanguage.append(this.code);
        this.region().ifPresent(region -> {
            localeLanguage.append("-");
            localeLanguage.append((String)region);
        });
        return localeLanguage.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Language)) {
            return super.equals(obj);
        }
        Language language = (Language)obj;
        return language.toString().equals(this.toString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }
}

