/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.plugin.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.plugin.Plugin;
import com.teamdev.jxbrowser.plugin.PluginSettings;
import com.teamdev.jxbrowser.plugin.Plugins;
import com.teamdev.jxbrowser.plugin.callback.PluginsCallback;
import com.teamdev.jxbrowser.plugin.internal.PluginSettingsImpl;
import com.teamdev.jxbrowser.plugin.internal.rpc.PluginList;
import com.teamdev.jxbrowser.plugin.internal.rpc.PluginManagerStub;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class PluginsImpl
extends CloseableImpl
implements Plugins {
    private final ProfileImpl profile;
    private final Lazy<PluginSettingsImpl> settings;
    private final ServiceConnectionImpl<PluginManagerStub> rpc;

    public PluginsImpl(ProfileImpl profile) {
        Preconditions.checkNotNull(profile);
        this.profile = profile;
        this.settings = new Lazy<PluginSettingsImpl>(() -> new PluginSettingsImpl(profile));
        EngineImpl engine = profile.engine();
        this.rpc = new ServiceConnectionImpl<PluginManagerStub>(engine.id(), engine.connection(), PluginManagerStub::new);
    }

    @Override
    public ProfileImpl profile() {
        return this.profile;
    }

    @Override
    public List<Plugin> list() {
        this.checkNotClosed();
        return Collections.unmodifiableList(((PluginList)this.rpc.invoke(this.rpc.stub()::getPlugins, Protobuf.empty())).getPluginList());
    }

    @Override
    public PluginSettings settings() {
        return this.settings.get();
    }

    @Override
    public <C extends PluginsCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((PluginsCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends PluginsCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends PluginsCallback> C remove(Class<C> callbackClass) {
        return (C)((PluginsCallback)this.rpc.remove(callbackClass));
    }

    @Override
    public void close() {
        PluginsImpl.closeIfNecessary(this.settings);
        this.rpc.close();
        super.close();
    }
}

