/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.tls;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.net.tls.Certificate;
import com.teamdev.jxbrowser.net.tls.KeyStoreType;
import com.teamdev.jxbrowser.net.tls.LoadClientCertificateException;
import com.teamdev.jxbrowser.net.tls.SslPrivateKey;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface ClientCertificate
extends Certificate {
    public static ClientCertificate of(X509Certificate x509Cert, SslPrivateKey privateKey) throws CertificateEncodingException {
        return ClientCertificate.of(x509Cert, privateKey, Collections.emptyList());
    }

    public static ClientCertificate of(X509Certificate x509Cert, SslPrivateKey privateKey, List<X509Certificate> intermediateX509Certs) throws CertificateEncodingException {
        Preconditions.checkNotNull(x509Cert);
        Preconditions.checkNotNull(privateKey);
        Preconditions.checkNotNull(intermediateX509Certs);
        return com.teamdev.jxbrowser.net.internal.rpc.ClientCertificate.newBuilder().setCertificate(com.teamdev.jxbrowser.net.internal.rpc.Certificate.cast(Certificate.of(x509Cert, intermediateX509Certs))).setPrivateKey(com.teamdev.jxbrowser.net.internal.rpc.SslPrivateKey.cast(privateKey)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientCertificate of(Path keystoreFilePath, String keystorePassword, KeyStoreType keyStoreType) {
        Preconditions.checkNotNull(keystoreFilePath);
        Preconditions.checkNotNull(keystorePassword);
        Preconditions.checkNotNull(keyStoreType);
        try (FileInputStream inputStream = new FileInputStream(keystoreFilePath.toFile());){
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.name());
            char[] passwordArray = keystorePassword.toCharArray();
            keyStore.load(inputStream, passwordArray);
            String alias = Collections.list(keyStore.aliases()).get(0);
            Key privateKey = keyStore.getKey(alias, passwordArray);
            SslPrivateKey sslPrivateKey = SslPrivateKey.of(privateKey.getEncoded());
            java.security.cert.Certificate[] chain = keyStore.getCertificateChain(alias);
            if (chain == null || chain.length == 0) {
                throw new LoadClientCertificateException(String.format("No certificates found in %s", keystoreFilePath));
            }
            X509Certificate x509Cert = (X509Certificate)chain[0];
            ArrayList<X509Certificate> intermediateX509Certs = new ArrayList<X509Certificate>();
            for (int i = 1; i < chain.length; ++i) {
                String issuer;
                X509Certificate intermediateX509Cert = (X509Certificate)chain[i];
                String subject = intermediateX509Cert.getSubjectX500Principal().getName();
                if (subject.equals(issuer = intermediateX509Cert.getIssuerX500Principal().getName())) continue;
                intermediateX509Certs.add(intermediateX509Cert);
            }
            ClientCertificate clientCertificate = ClientCertificate.of(x509Cert, sslPrivateKey, intermediateX509Certs);
            return clientCertificate;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new LoadClientCertificateException(String.format("Failed to load %s", keystoreFilePath), e);
        }
    }

    @Override
    default public byte[] derEncodedValue() {
        return com.teamdev.jxbrowser.net.internal.rpc.ClientCertificate.cast(this).getCertificate().getDerEncodedValue().toByteArray();
    }

    @Override
    @Immutable
    default public List<Certificate> intermediateCertificates() {
        return com.teamdev.jxbrowser.net.internal.rpc.ClientCertificate.cast(this).getCertificate().getIntermediateCertsList().stream().map(certificate -> certificate).collect(ImmutableList.toImmutableList());
    }

    default public SslPrivateKey privateKey() {
        return com.teamdev.jxbrowser.net.internal.rpc.ClientCertificate.cast(this).getPrivateKey();
    }
}

