/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.media.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.media.Audio;
import com.teamdev.jxbrowser.media.event.AudioEvent;
import com.teamdev.jxbrowser.media.internal.rpc.AudioStub;

public final class AudioImpl
extends CloseableImpl
implements Audio {
    private final BrowserImpl browser;
    private final ServiceConnectionImpl<AudioStub> rpc;

    public AudioImpl(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.rpc = new ServiceConnectionImpl<AudioStub>(browser.id(), browser.engine().connection(), AudioStub::new);
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public void mute() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::mute, this.browser.id());
    }

    @Override
    public void unmute() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::unmute, this.browser.id());
    }

    @Override
    public boolean isMuted() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isMuted, this.browser.id())).getValue();
    }

    @Override
    public boolean isPlaying() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isPlaying, this.browser.id())).getValue();
    }

    @Override
    public <E extends AudioEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

