/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.engine.ChromiumBinariesDeliveryException;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.JniLibrary;
import com.teamdev.jxbrowser.internal.JniLibraryName;
import com.teamdev.jxbrowser.internal.xz.JavaResourceExtractor;
import com.teamdev.jxbrowser.internal.xz.ResourceLocator;
import com.teamdev.jxbrowser.internal.xz.SevenZip;
import com.teamdev.jxbrowser.os.Environment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;

public final class ToolkitLibraryExtractor {
    private ToolkitLibraryExtractor() {
    }

    public static void extractTo(Path destDir) {
        if (Environment.isMac() || SevenZip.shouldUseNativeExtraction()) {
            ToolkitLibraryExtractor.extract(destDir);
        }
    }

    private static void extract(Path destDir) {
        Files.createDirs(destDir);
        JavaResourceExtractor extractor = new JavaResourceExtractor();
        JniLibraryName toolkitLibName = JniLibraryName.TOOLKIT;
        Path toolkitLibraryDest = destDir.resolve(toolkitLibName.toPlatform());
        ImmutableList<String> fileNames = Environment.isMac() ? ImmutableList.of("lib" + (Object)((Object)toolkitLibName) + "_x64.dylib", "lib" + (Object)((Object)toolkitLibName) + "_arm64.dylib") : ImmutableList.of(toolkitLibName.toPlatform());
        for (String fileName : fileNames) {
            try {
                if (!ResourceLocator.findResource(fileName).isPresent()) continue;
                extractor.extract(fileName, toolkitLibraryDest);
                JniLibrary.path(destDir);
                return;
            }
            catch (IOException e) {
                throw new ChromiumBinariesDeliveryException(e);
            }
        }
        throw new ChromiumBinariesDeliveryException(new FileNotFoundException("No JAR file with the platform binaries in the classpath."));
    }
}

