/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.stream.util;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.event.Event;
import com.teamdev.jxbrowser.internal.rpc.stream.util.AbstractType;

public final class EventType
extends AbstractType<Object> {
    public static <T> EventType from(Class<T> eventClass) {
        Preconditions.checkNotNull(eventClass);
        Preconditions.checkArgument(Event.class.isAssignableFrom(eventClass), "The event class must implement the com.teamdev.jxbrowser.event.Event interface: " + eventClass);
        if (eventClass.isInterface()) {
            return new EventType((Class<?>)eventClass);
        }
        for (Class<?> eventType : eventClass.getInterfaces()) {
            if (!Event.class.isAssignableFrom(eventType)) continue;
            return new EventType(eventType);
        }
        throw new IllegalArgumentException("Failed to determine the event class for the message: " + eventClass);
    }

    private EventType(Class<?> type) {
        super(type);
    }

    @Override
    public String toString() {
        return "EventType:" + super.toString();
    }
}

