/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.reflect;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.internal.reflect.AccessibleObjects;
import com.teamdev.jxbrowser.internal.reflect.ReflectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class Methods {
    public static Optional<Method> findPublicMethodByName(Class<?> cls, String methodName) {
        return Arrays.stream(cls.getMethods()).filter(method -> method.getName().equals(methodName)).findAny();
    }

    public static Optional<Method> findPublicMethod(Class<?> cls, String methodName, Class<?> ... params) {
        return Arrays.stream(cls.getMethods()).filter(method -> method.getName().equals(methodName)).filter(method -> Arrays.equals(method.getParameterTypes(), params)).findAny();
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> ... args) {
        try {
            return cls.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Method getMethod(String className, String name, Class<?> ... args) {
        try {
            Class<?> cls = Class.forName(className);
            return cls.getDeclaredMethod(name, args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Set<Method> findDeclaredMethods(Class<?> cls, Predicate<Method> predicate) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Arrays.stream(cls.getDeclaredMethods()).filter(predicate).forEach(builder::add);
        if (cls.getSuperclass() != null) {
            builder.addAll(Methods.findDeclaredMethods(cls.getSuperclass(), predicate));
        }
        for (Class<?> anInterface : cls.getInterfaces()) {
            builder.addAll(Methods.findDeclaredMethods(anInterface, predicate));
        }
        return builder.build();
    }

    public static <T> T invoke(@Nullable Object instance, Method method, Object ... args) {
        try {
            Object result = method.invoke(instance, args);
            return (T)result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) {
        try {
            Object result = method.invoke(null, args);
            return (T)result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public static <T> T invokeInaccessible(@Nullable Object instance, Method method, Object ... args) {
        try {
            AccessibleObjects.makeAccessible(method);
            Object result = method.invoke(instance, args);
            return (T)result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    private Methods() {
    }
}

