/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.frame.internal.convert.AbstractValue;
import com.teamdev.jxbrowser.frame.internal.convert.JavaValue;
import com.teamdev.jxbrowser.internal.reflect.PrimitiveToWrapper;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;

final class NumberValue
extends AbstractValue
implements JavaValue {
    private final LinkedHashMap<Class<?>, Function<Double, ?>> destinationTypes;

    NumberValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.NUMBER_VALUE);
        this.destinationTypes = this.createDestinationTypes();
    }

    private LinkedHashMap<Class<?>, Function<Double, ?>> createDestinationTypes() {
        LinkedHashMap result = new LinkedHashMap();
        double value = this.jsValue().getNumberValue();
        result.put(Double.class, num -> num);
        if (Double.compare(value, 3.4028234663852886E38) <= 0 && Double.compare(value, -3.4028234663852886E38) >= 0 && Double.compare(value, (float)value) == 0) {
            result.put(Float.class, Double::floatValue);
        }
        if (this.isInteger()) {
            if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
                result.put(Long.class, Double::longValue);
            }
            if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                result.put(Integer.class, Double::intValue);
            }
            if (value >= -32768.0 && value <= 32767.0) {
                result.put(Short.class, Double::shortValue);
            }
            if (value >= -128.0 && value <= 127.0) {
                result.put(Byte.class, Double::byteValue);
            }
        }
        return result;
    }

    private boolean isInteger() {
        Double value = this.jsValue().getNumberValue();
        return value.compareTo(Math.floor(value)) == 0;
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return ImmutableList.copyOf(this.destinationTypes.keySet());
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        if (type.isPrimitive()) {
            type = new PrimitiveToWrapper().apply(type);
        }
        for (Class<?> destinationType : this.destinationTypes.keySet()) {
            if (!type.isAssignableFrom(destinationType)) continue;
            return (T)this.destinationTypes.get(destinationType).apply(this.jsValue().getNumberValue());
        }
        throw new IllegalArgumentException("Cannot convert the value to: " + type);
    }
}

