/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.frame.internal.convert;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.dom.Node;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.frame.internal.PageContext;
import com.teamdev.jxbrowser.frame.internal.convert.AbstractValue;
import com.teamdev.jxbrowser.internal.ProtobufMessages;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.List;

final class NodeValue
extends AbstractValue {
    NodeValue(JsValue jsValue) {
        super(jsValue);
        Preconditions.checkArgument(jsValue.getValueCase() == JsValue.ValueCase.NODE_INFO);
    }

    @Override
    public List<Class<?>> destinationTypes() {
        return ImmutableList.of(Node.class, JsObject.class);
    }

    @Override
    public <T> T toObject(Class<?> type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(this.isConvertibleTo(type), "Cannot convert the value to: " + type);
        NodeInfo nodeInfo = this.jsValue().getNodeInfo();
        if (ProtobufMessages.isDefault(nodeInfo)) {
            return null;
        }
        PageContext context = PageContext.of(nodeInfo.getNodeId().getPageContextId());
        return (T)context.domContext().toNode(nodeInfo);
    }
}

