/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.engine;

import com.teamdev.jxbrowser.Closeable;
import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.cache.HttpAuthCache;
import com.teamdev.jxbrowser.cache.HttpCache;
import com.teamdev.jxbrowser.cookie.CookieStore;
import com.teamdev.jxbrowser.download.Downloads;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.Theme;
import com.teamdev.jxbrowser.engine.event.EngineEvent;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.media.MediaDevices;
import com.teamdev.jxbrowser.net.Network;
import com.teamdev.jxbrowser.net.proxy.Proxy;
import com.teamdev.jxbrowser.permission.Permissions;
import com.teamdev.jxbrowser.plugin.Plugins;
import com.teamdev.jxbrowser.profile.Profiles;
import com.teamdev.jxbrowser.spellcheck.SpellChecker;
import com.teamdev.jxbrowser.zoom.ZoomLevels;
import java.util.List;

public interface Engine
extends Closeable,
Observable<EngineEvent> {
    public static Engine newInstance(RenderingMode renderingMode) {
        EngineOptions options = EngineOptions.newBuilder(renderingMode).build();
        return Engine.newInstance(options);
    }

    public static Engine newInstance(EngineOptions options) {
        return EngineImpl.newInstance(options);
    }

    public EngineOptions options();

    public Browser newBrowser();

    @Immutable
    public List<Browser> browsers();

    public ZoomLevels zoomLevels();

    public Proxy proxy();

    public Network network();

    public SpellChecker spellChecker();

    public CookieStore cookieStore();

    public HttpCache httpCache();

    public HttpAuthCache httpAuthCache();

    public MediaDevices mediaDevices();

    public Plugins plugins();

    public Downloads downloads();

    public Permissions permissions();

    public Profiles profiles();

    public void setTheme(Theme var1);

    public Theme theme();
}

