/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.dom.InputElement;
import com.teamdev.jxbrowser.dom.internal.FormControlElementImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.FilePathList;
import com.teamdev.jxbrowser.dom.internal.rpc.GetFilesRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.InputElementStub;
import com.teamdev.jxbrowser.dom.internal.rpc.IsCheckboxRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsCheckedRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsEmailFieldRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsFileRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsMultipleFileRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsPasswordFieldRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsRadioButtonRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsTextFieldRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsTextRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.SetCheckedRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.SetFileRequest;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import java.util.Collection;
import java.util.Collections;

public final class InputElementImpl
extends FormControlElementImpl
implements InputElement {
    private static final String ILLEGAL_TYPE_MESSAGE = "The 'type' attribute of the input element is not %s.";
    private final ServiceConnectionImpl<InputElementStub> rpc;

    public static InputElementImpl newInstance(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        return new InputElementImpl(connection, domContext, nodeInfo);
    }

    private InputElementImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new ServiceConnectionImpl<InputElementStub>(nodeInfo, connection, InputElementStub::new);
    }

    @Override
    public boolean isText() {
        this.checkNotClosed();
        IsTextRequest request = IsTextRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isText, request)).getValue();
    }

    @Override
    public boolean isCheckbox() {
        this.checkNotClosed();
        IsCheckboxRequest request = IsCheckboxRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isCheckbox, request)).getValue();
    }

    @Override
    public boolean isRadioButton() {
        this.checkNotClosed();
        IsRadioButtonRequest request = IsRadioButtonRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isRadioButton, request)).getValue();
    }

    @Override
    public boolean isTextField() {
        this.checkNotClosed();
        IsTextFieldRequest request = IsTextFieldRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isTextField, request)).getValue();
    }

    @Override
    public boolean isEmailField() {
        this.checkNotClosed();
        IsEmailFieldRequest request = IsEmailFieldRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isEmailField, request)).getValue();
    }

    @Override
    public boolean isPasswordField() {
        this.checkNotClosed();
        IsPasswordFieldRequest request = IsPasswordFieldRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isPasswordField, request)).getValue();
    }

    @Override
    public boolean isFile() {
        this.checkNotClosed();
        IsFileRequest request = IsFileRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isFile, request)).getValue();
    }

    @Override
    public String file() {
        Collection<String> files = this.files();
        return files.isEmpty() ? "" : files.iterator().next();
    }

    @Override
    public void file(String ... filePaths) {
        StringPreconditions.checkNotNullEmptyOrBlank(filePaths);
        Preconditions.checkState(this.isFile(), String.format(ILLEGAL_TYPE_MESSAGE, "'file'"));
        this.checkNotClosed();
        FilePathList filePathList = FilePathList.newBuilder().addAllFilesPath(ImmutableList.copyOf(filePaths)).build();
        SetFileRequest request = SetFileRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setFilePathList(filePathList).build();
        this.rpc.invoke(this.rpc.stub()::setFile, request);
    }

    @Override
    public boolean isMultipleFile() {
        this.checkNotClosed();
        IsMultipleFileRequest request = IsMultipleFileRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isMultipleFile, request)).getValue();
    }

    @Override
    public Collection<String> files() {
        Preconditions.checkState(this.isFile(), String.format(ILLEGAL_TYPE_MESSAGE, "'file'"));
        this.checkNotClosed();
        GetFilesRequest request = GetFilesRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return Collections.unmodifiableCollection(((FilePathList)this.rpc.invoke(this.rpc.stub()::getFiles, request)).getFilesPathList());
    }

    @Override
    public boolean isChecked() {
        Preconditions.checkState(this.isCheckbox() || this.isRadioButton(), String.format(ILLEGAL_TYPE_MESSAGE, "'checkbox' or 'radio'"));
        this.checkNotClosed();
        IsCheckedRequest request = IsCheckedRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isChecked, request)).getValue();
    }

    private void setChecked(boolean checked) {
        Preconditions.checkState(this.isCheckbox() || this.isRadioButton(), String.format(ILLEGAL_TYPE_MESSAGE, "'checkbox' or 'radio'"));
        this.checkNotClosed();
        SetCheckedRequest request = SetCheckedRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setChecked(checked).build();
        this.rpc.invoke(this.rpc.stub()::setChecked, request);
    }

    @Override
    public void check() {
        this.setChecked(true);
    }

    @Override
    public void uncheck() {
        this.setChecked(false);
    }
}

