/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.UnsupportedRenderingModeException;
import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.event.FocusLost;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.NativeKeyboardListenerLinux;
import com.teamdev.jxbrowser.browser.internal.NativeKeyboardListenerMac;
import com.teamdev.jxbrowser.browser.internal.NativeKeyboardListenerWin;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeKeyEvent;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeKeyboardListener {
    private long windowId;
    private final String uuid;
    private Subscription focusGained;
    private Subscription focusLost;
    final AtomicBoolean isChromiumFocused;
    final AtomicBoolean isActive;
    protected final BrowserWidget widget;
    protected final EventInterceptor interceptor;

    public static NativeKeyboardListener create(BrowserWidget widget, EventInterceptor handler) {
        Preconditions.checkNotNull(widget);
        if (Environment.isMac()) {
            return new NativeKeyboardListenerMac(widget, handler);
        }
        if (Environment.isWindows()) {
            NativeKeyboardListener.checkOffScreen(widget);
            return new NativeKeyboardListenerWin(widget, handler);
        }
        NativeKeyboardListener.checkOffScreen(widget);
        return new NativeKeyboardListenerLinux(widget, handler);
    }

    private static void checkOffScreen(BrowserWidget widget) {
        RenderingMode renderingMode = widget.browser().engine().options().renderingMode();
        if (renderingMode != RenderingMode.OFF_SCREEN) {
            throw new UnsupportedRenderingModeException(renderingMode);
        }
    }

    NativeKeyboardListener(BrowserWidget widget, EventInterceptor interceptor) {
        this.interceptor = interceptor;
        this.widget = widget;
        this.isChromiumFocused = new AtomicBoolean();
        this.isActive = new AtomicBoolean();
        this.uuid = UUID.randomUUID().toString();
    }

    public boolean isActive() {
        return this.isActive.get();
    }

    public void start(long windowId, boolean focused) {
        Preconditions.checkArgument(windowId > 0L);
        this.isActive.set(true);
        this.windowId = windowId;
        this.isChromiumFocused.set(focused);
        this.focusGained = this.widget.browser().on(FocusGained.class, event -> this.isChromiumFocused.set(true));
        this.focusLost = this.widget.browser().on(FocusLost.class, event -> this.isChromiumFocused.set(false));
        ToolkitLibrary.instance().addKeyboardListener(this, this.uuid, windowId);
    }

    public void stop() {
        this.isActive.set(false);
        this.focusGained.unsubscribe();
        this.focusLost.unsubscribe();
        ToolkitLibrary.instance().removeKeyboardListener(this.uuid, this.windowId);
    }

    public static interface EventInterceptor {
        public void intercept(NativeKeyEvent var1);
    }
}

