/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser;

import com.teamdev.jxbrowser.deps.com.google.common.base.Joiner;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.deps.com.google.common.io.Resources;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class ObjectClosedException
extends IllegalStateException {
    private static final Lazy<String> MESSAGE = new Lazy<String>(ObjectClosedException::message);

    public ObjectClosedException() {
        super(ObjectClosedException.fullMessage());
    }

    private static String fullMessage() {
        String emptyLine = "";
        ImmutableList messageLines = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("Attempted to use a closed object.")).add(emptyLine)).add(MESSAGE.get())).add(emptyLine)).build();
        return Joiner.on(System.lineSeparator()).join(messageLines);
    }

    private static String message() {
        try {
            URL message = Resources.getResource(ObjectClosedException.class, "object-closed-exception-detail.txt");
            List<String> lines = Resources.readLines(message, StandardCharsets.UTF_8);
            return Joiner.on(System.lineSeparator()).join(lines);
        }
        catch (IOException e) {
            Logger.debug("Couldn't read the exception detail file.", e);
            return "";
        }
    }
}

