/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.nio.charset.Charset;

public class FastByteArrayOutputStream {
    private int increment_size = 1000;
    private int current_item;
    private int max_size = 250;
    private byte[] items;

    public FastByteArrayOutputStream() {
        this.items = new byte[this.max_size];
    }

    private static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 320000 ? (increment_size *= 2) : (increment_size += 320000));
        return increment_size;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.current_item];
        System.arraycopy(this.items, 0, newbuf, 0, this.current_item);
        return newbuf;
    }

    public String toString(Charset charset) {
        return new String(this.items, 0, this.current_item, charset);
    }

    public FastByteArrayOutputStream(int number) {
        this.max_size = number;
        this.items = new byte[this.max_size];
    }

    public final void write(byte new_name) {
        if (this.current_item + 1 > this.max_size) {
            this.checkSize(this.current_item + 1);
        }
        this.items[this.current_item] = new_name;
        ++this.current_item;
    }

    public final void write(int new_name) {
        if (this.current_item + 1 > this.max_size) {
            this.checkSize(this.current_item + 1);
        }
        this.items[this.current_item] = (byte)(new_name & 0xFF);
        ++this.current_item;
    }

    public final void write(byte[] new_name, int start, int len) {
        int size = len - start;
        if (this.current_item + size > this.max_size) {
            this.checkSize(this.current_item + size);
        }
        for (int i = 0; i < size; ++i) {
            this.items[this.current_item] = new_name[i + start];
            ++this.current_item;
        }
    }

    public final void write(byte[] new_name) {
        int size = new_name.length;
        if (this.current_item + size > this.max_size) {
            this.checkSize(this.current_item + size);
        }
        byte[] byArray = new_name;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte aNew_name;
            this.items[this.current_item] = aNew_name = byArray[i];
            ++this.current_item;
        }
    }

    public final int size() {
        return this.current_item;
    }

    private void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            byte[] temp = this.items;
            this.items = new byte[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = FastByteArrayOutputStream.incrementSize(this.increment_size);
        }
    }

    public void reset() {
        this.current_item = 0;
    }
}

