/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.json;

import org.jpedal.render.output.json.Json;
import org.jpedal.render.output.json.JsonObject;
import org.jpedal.render.output.json.JsonPreformattedElement;

public class JsonArray {
    private final StringBuilder output = new StringBuilder();
    private boolean isFinal;

    public JsonArray() {
        this.output.append('[');
    }

    private void appendSeparator() {
        if (this.output.length() > 1) {
            this.output.append(',');
        }
    }

    public JsonArray add(String value) {
        this.appendSeparator();
        this.output.append(Json.format(value));
        return this;
    }

    public JsonArray add(int value) {
        this.appendSeparator();
        this.output.append(value);
        return this;
    }

    public JsonArray add(JsonObject value) {
        this.appendSeparator();
        this.output.append(value);
        return this;
    }

    public JsonArray add(JsonArray value) {
        this.appendSeparator();
        this.output.append(value);
        return this;
    }

    public JsonArray add(JsonPreformattedElement value) {
        this.appendSeparator();
        this.output.append(value);
        return this;
    }

    public String toString() {
        if (!this.isFinal) {
            this.output.append(']');
            this.isFinal = true;
        }
        return this.output.toString();
    }
}

