/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.utils.LogWriter;

public class IdrOutputStream
extends FilterOutputStream {
    private final CryptoIDR crypto;

    public IdrOutputStream(OutputStream out, CryptoIDR crypto) {
        super(out);
        this.crypto = crypto;
        if (LogWriter.isRunningFromIDE) {
            LogWriter.writeLog(String.valueOf(out) + " " + String.valueOf(this.crypto));
        }
    }

    @Override
    public void write(int i) throws IOException {
        this.out.write(this.crypto.encrypt(new byte[]{(byte)i}));
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.out.write(this.crypto.encrypt(bytes));
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        if ((off | len | bytes.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = off; i < len; ++i) {
            bytes[i] = this.crypto.encrypt(bytes[i], true);
        }
        this.out.write(bytes, off, len);
    }
}

