/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.utils.LogWriter;

public class IdrInputStream
extends FilterInputStream {
    private final CryptoIDR crypto;
    private int salt;

    public IdrInputStream(InputStream in, CryptoIDR crypto) {
        super(in);
        this.in = in;
        this.crypto = crypto;
        if (LogWriter.isRunningFromIDE) {
            LogWriter.writeLog(String.valueOf(in) + " " + String.valueOf(this.crypto));
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long returnN = super.skip(n);
        this.salt += (int)n;
        return returnN;
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        byte decoded = this.crypto.decrypt((byte)(read & 0xFF), this.salt);
        ++this.salt;
        return decoded;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        int result = super.read(b, offset, len);
        int max = Math.min(b.length - offset, len);
        for (int i = offset; i != max; ++i) {
            byte decoded = this.crypto.decrypt((byte)(b[i] & 0xFF), this.salt);
            ++this.salt;
            b[i] = decoded;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

