/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.BPredictionMode;
import com.idrsolutions.image.webp.enc.Compressor;
import com.idrsolutions.image.webp.enc.EntropyMode;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.MBPredictionMode;
import com.idrsolutions.image.webp.enc.TokenAlphabet;
import com.idrsolutions.image.webp.enc.TreeWriter;
import com.idrsolutions.image.webp.enc.VP8Util;
import java.util.HashMap;

class RDCosts {
    final FullGetSetPointer[] mvcosts = new FullGetSetPointer[2];
    final FullGetSetPointer[] mvsadcosts = new FullGetSetPointer[2];
    final HashMap<Integer, HashMap<Integer, Integer>> mbmode_cost = new HashMap();
    final int[][] intra_uv_mode_cost = new int[2][MBPredictionMode.count];
    final HashMap<Integer, HashMap<Integer, HashMap<Integer, Integer>>> bmode_costs = new HashMap();
    final HashMap<Integer, Integer> inter_bmode_costs = new HashMap();
    final int[][][][] token_costs = new int[4][8][3][TokenAlphabet.entropyTokenCount];
    private final HashMap<Integer, int[]> costArrayCache = new HashMap();
    private final int[] bpmHelper = new int[14];

    RDCosts() {
        RDCosts.initcostarr(this.mvcosts, 2048);
        RDCosts.initcostarr(this.mvsadcosts, 512);
        for (int ft : new int[]{0, 1}) {
            this.mbmode_cost.put(ft, new HashMap());
        }
        for (int bpm : BPredictionMode.validmodes) {
            HashMap submap = new HashMap();
            int[] nArray = BPredictionMode.validmodes;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer b2pm = nArray[i];
                submap.put(b2pm, new HashMap());
            }
            this.bmode_costs.put(bpm, submap);
        }
    }

    private static void initcostarr(FullGetSetPointer[] carr, int size) {
        carr[0] = new FullGetSetPointer(size);
        carr[1] = new FullGetSetPointer(size);
    }

    int[] getMBmodeCostAsArray(int t) {
        int[] ret = this.costArrayCache.computeIfAbsent(t, k -> new int[MBPredictionMode.count]);
        HashMap<Integer, Integer> data = this.mbmode_cost.get(t);
        for (MBPredictionMode mode : MBPredictionMode.validModes) {
            Integer v = data.get((Object)mode);
            ret[mode.ordinal()] = v == null ? 0 : v;
        }
        return ret;
    }

    void setMBmodeCostAsArray(int t) {
        HashMap<Integer, Integer> data = this.mbmode_cost.get(t);
        int i = 0;
        int[] arr = this.costArrayCache.get(t);
        for (MBPredictionMode mode : MBPredictionMode.validModes) {
            data.put(mode.ordinal(), arr[i++]);
        }
    }

    private void bpmMaptoArray(HashMap<Integer, Integer> data) {
        int[] nArray = BPredictionMode.validmodes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer mode = nArray[i];
            Integer v = data.get(mode);
            this.bpmHelper[mode.intValue()] = v == null ? 0 : v;
        }
    }

    private void arraytoBpmMap(HashMap<Integer, Integer> data) {
        int i = 0;
        int[] nArray = BPredictionMode.validmodes;
        int n = nArray.length;
        for (int j = 0; j < n; ++j) {
            Integer mode = nArray[j];
            data.put(mode, this.bpmHelper[i++]);
        }
    }

    void vp8_init_mode_costs(Compressor c) {
        GetSetPointer T = EntropyMode.vp8_bmode_tree;
        for (int bpO : BPredictionMode.bintramodes) {
            for (int bpI : BPredictionMode.bintramodes) {
                this.bpmMaptoArray(this.bmode_costs.get(bpO).get(bpI));
                TreeWriter.vp8_cost_tokens(this.bpmHelper, FullGetSetPointer.toPointer(VP8Util.SubblockKeys.keyFrameSubblockModeProb[bpO][bpI]), T);
                this.arraytoBpmMap(this.bmode_costs.get(bpO).get(bpI));
            }
        }
        this.bpmMaptoArray(this.inter_bmode_costs);
        TreeWriter.vp8_cost_tokens(this.bpmHelper, c.common.fc.bmode_prob, T);
        TreeWriter.vp8_cost_tokens(this.bpmHelper, c.common.fc.sub_mv_ref_prob, EntropyMode.vp8_sub_mv_ref_tree);
        this.arraytoBpmMap(this.inter_bmode_costs);
        int[] temp = this.getMBmodeCostAsArray(1);
        TreeWriter.vp8_cost_tokens(temp, c.common.fc.ymode_prob, EntropyMode.vp8_ymode_tree);
        this.setMBmodeCostAsArray(1);
        temp = this.getMBmodeCostAsArray(0);
        TreeWriter.vp8_cost_tokens(temp, EntropyMode.vp8_kf_ymode_prob, EntropyMode.vp8_kf_ymode_tree);
        this.setMBmodeCostAsArray(0);
        TreeWriter.vp8_cost_tokens(this.intra_uv_mode_cost[1], c.common.fc.uv_mode_prob, EntropyMode.vp8_uv_mode_tree);
        TreeWriter.vp8_cost_tokens(this.intra_uv_mode_cost[0], EntropyMode.vp8_kf_uv_mode_prob, EntropyMode.vp8_uv_mode_tree);
    }
}

