/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.IntraPredFN;
import com.idrsolutions.image.webp.enc.VP8Util;

class D135Predictor4x4
implements IntraPredFN {
    D135Predictor4x4() {
    }

    @Override
    public void call(FullGetSetPointer dst, int stride, GetPointer above, GetPointer left) {
        GetSetPointer pLeft = GetSetPointer.makePositionable(left);
        GetSetPointer pAbove = GetSetPointer.makePositionable(above);
        short I = pLeft.getAndInc();
        short J = pLeft.getAndInc();
        short K = pLeft.getAndInc();
        short L = pLeft.getAndInc();
        short X = pAbove.getRel(-1);
        short A = pAbove.getAndInc();
        short B = pAbove.getAndInc();
        short C = pAbove.getAndInc();
        short D2 = pAbove.getAndInc();
        dst.setRel(3 * stride, VP8Util.avg3(J, K, L));
        dst.setRel(1 + 3 * stride, dst.setRel(2 * stride, VP8Util.avg3(I, J, K)));
        dst.setRel(2 + 3 * stride, dst.setRel(1 + 2 * stride, dst.setRel(stride, VP8Util.avg3(X, I, J))));
        dst.setRel(3 + 3 * stride, dst.setRel(2 + 2 * stride, dst.setRel(1 + stride, dst.set(VP8Util.avg3(A, X, I)))));
        dst.setRel(3 + 2 * stride, dst.setRel(2 + stride, dst.setRel(1, VP8Util.avg3(B, A, X))));
        dst.setRel(3 + stride, dst.setRel(2, VP8Util.avg3(C, B, A)));
        dst.setRel(3, VP8Util.avg3(D2, C, B));
    }
}

