/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.BitEncoder;
import com.idrsolutions.image.webp.enc.CUtils;
import com.idrsolutions.image.webp.enc.CommonData;
import com.idrsolutions.image.webp.enc.Compressor;
import com.idrsolutions.image.webp.enc.Entropy;
import com.idrsolutions.image.webp.enc.EntropyMode;
import com.idrsolutions.image.webp.enc.FindNearMV;
import com.idrsolutions.image.webp.enc.FrameContext;
import com.idrsolutions.image.webp.enc.FullGenArrPointer;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.Header;
import com.idrsolutions.image.webp.enc.LoopFilterType;
import com.idrsolutions.image.webp.enc.MBLvlFeatures;
import com.idrsolutions.image.webp.enc.MBModeInfo;
import com.idrsolutions.image.webp.enc.MBPredictionMode;
import com.idrsolutions.image.webp.enc.MVReferenceFrame;
import com.idrsolutions.image.webp.enc.Macroblock;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.ModeInfo;
import com.idrsolutions.image.webp.enc.ReferenceCounts;
import com.idrsolutions.image.webp.enc.Token;
import com.idrsolutions.image.webp.enc.TokenAlphabet;
import com.idrsolutions.image.webp.enc.TokenExtra;
import com.idrsolutions.image.webp.enc.TokenList;
import com.idrsolutions.image.webp.enc.TokenPartition;
import com.idrsolutions.image.webp.enc.TreeWriter;
import com.idrsolutions.image.webp.enc.VP8Util;
import java.util.EnumMap;
import org.jpedal.utils.LogWriter;

final class BitStream {
    static final int[] VP_8_CX_BASE_SKIP_FALSE_PROB = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 248, 244, 240, 236, 232, 229, 225, 221, 217, 213, 208, 204, 199, 194, 190, 187, 183, 179, 175, 172, 168, 164, 160, 157, 153, 149, 145, 142, 138, 134, 130, 127, 124, 120, 117, 114, 110, 107, 104, 101, 98, 95, 92, 89, 86, 83, 80, 77, 74, 71, 68, 65, 62, 59, 56, 53, 50, 47, 44, 41, 38, 35, 32, 30, 28, 26, 24, 22, 20, 18, 16};
    private static final int[][][][] VP_8_COEF_UPDATE_PROBS = new int[][][][]{new int[][][]{new int[][]{{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{176, 246, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {223, 241, 252, 255, 255, 255, 255, 255, 255, 255, 255}, {249, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 244, 252, 255, 255, 255, 255, 255, 255, 255, 255}, {234, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 246, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {239, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {254, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 248, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {251, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {251, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {254, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 254, 253, 255, 254, 255, 255, 255, 255, 255, 255}, {250, 255, 254, 255, 254, 255, 255, 255, 255, 255, 255}, {254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}}, new int[][][]{new int[][]{{217, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {225, 252, 241, 253, 255, 255, 254, 255, 255, 255, 255}, {234, 250, 241, 250, 253, 255, 253, 254, 255, 255, 255}}, new int[][]{{255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {223, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {238, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 248, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {249, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {247, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 254, 253, 255, 255, 255, 255, 255, 255, 255, 255}, {250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}}, new int[][][]{new int[][]{{186, 251, 250, 255, 255, 255, 255, 255, 255, 255, 255}, {234, 251, 244, 254, 255, 255, 255, 255, 255, 255, 255}, {251, 251, 243, 253, 254, 255, 254, 255, 255, 255, 255}}, new int[][]{{255, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {236, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {251, 253, 253, 254, 254, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}}, new int[][][]{new int[][]{{248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {250, 254, 252, 254, 255, 255, 255, 255, 255, 255, 255}, {248, 254, 249, 253, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255}, {246, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255}, {252, 254, 251, 254, 254, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 254, 252, 255, 255, 255, 255, 255, 255, 255, 255}, {248, 254, 253, 255, 255, 255, 255, 255, 255, 255, 255}, {253, 255, 254, 254, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 251, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {245, 251, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 251, 253, 255, 255, 255, 255, 255, 255, 255, 255}, {252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {249, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255}, {250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}, new int[][]{{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255}}}};
    static final int[][][][] default_coef_counts = new int[][][][]{new int[][][]{new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, new int[][]{{30190, 26544, 225, 24, 4, 0, 0, 0, 0, 0, 0, 4171593}, {26846, 25157, 1241, 130, 26, 6, 1, 0, 0, 0, 0, 149987}, {10484, 9538, 1006, 160, 36, 18, 0, 0, 0, 0, 0, 15104}}, new int[][]{{25842, 40456, 1126, 83, 11, 2, 0, 0, 0, 0, 0, 0}, {9338, 8010, 512, 73, 7, 3, 2, 0, 0, 0, 0, 43294}, {1047, 751, 149, 31, 13, 6, 1, 0, 0, 0, 0, 879}}, new int[][]{{26136, 9826, 252, 13, 0, 0, 0, 0, 0, 0, 0, 0}, {8134, 5574, 191, 14, 2, 0, 0, 0, 0, 0, 0, 35302}, {605, 677, 116, 9, 1, 0, 0, 0, 0, 0, 0, 611}}, new int[][]{{10263, 15463, 283, 17, 0, 0, 0, 0, 0, 0, 0, 0}, {2773, 2191, 128, 9, 2, 2, 0, 0, 0, 0, 0, 10073}, {134, 125, 32, 4, 0, 2, 0, 0, 0, 0, 0, 50}}, new int[][]{{10483, 2663, 23, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {2137, 1251, 27, 1, 1, 0, 0, 0, 0, 0, 0, 14362}, {116, 156, 14, 2, 1, 0, 0, 0, 0, 0, 0, 190}}, new int[][]{{40977, 27614, 412, 28, 0, 0, 0, 0, 0, 0, 0, 0}, {6113, 5213, 261, 22, 3, 0, 0, 0, 0, 0, 0, 26164}, {382, 312, 50, 14, 2, 0, 0, 0, 0, 0, 0, 345}}, new int[][]{{0, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 319}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8}}}, new int[][][]{new int[][]{{3268, 19382, 1043, 250, 93, 82, 49, 26, 17, 8, 25, 82289}, {8758, 32110, 5436, 1832, 827, 668, 420, 153, 24, 0, 3, 52914}, {9337, 23725, 8487, 3954, 2107, 1836, 1069, 399, 59, 0, 0, 18620}}, new int[][]{{12419, 8420, 452, 62, 9, 1, 0, 0, 0, 0, 0, 0}, {11715, 8705, 693, 92, 15, 7, 2, 0, 0, 0, 0, 53988}, {7603, 8585, 2306, 778, 270, 145, 39, 5, 0, 0, 0, 9136}}, new int[][]{{15938, 14335, 1207, 184, 55, 13, 4, 1, 0, 0, 0, 0}, {7415, 6829, 1138, 244, 71, 26, 7, 0, 0, 0, 0, 9980}, {1580, 1824, 655, 241, 89, 46, 10, 2, 0, 0, 0, 429}}, new int[][]{{19453, 5260, 201, 19, 0, 0, 0, 0, 0, 0, 0, 0}, {9173, 3758, 213, 22, 1, 1, 0, 0, 0, 0, 0, 9820}, {1689, 1277, 276, 51, 17, 4, 0, 0, 0, 0, 0, 679}}, new int[][]{{12076, 10667, 620, 85, 19, 9, 5, 0, 0, 0, 0, 0}, {4665, 3625, 423, 55, 19, 9, 0, 0, 0, 0, 0, 5127}, {415, 440, 143, 34, 20, 7, 2, 0, 0, 0, 0, 101}}, new int[][]{{12183, 4846, 115, 11, 1, 0, 0, 0, 0, 0, 0, 0}, {4226, 3149, 177, 21, 2, 0, 0, 0, 0, 0, 0, 7157}, {375, 621, 189, 51, 11, 4, 1, 0, 0, 0, 0, 198}}, new int[][]{{61658, 37743, 1203, 94, 10, 3, 0, 0, 0, 0, 0, 0}, {15514, 11563, 903, 111, 14, 5, 0, 0, 0, 0, 0, 25195}, {929, 1077, 291, 78, 14, 7, 1, 0, 0, 0, 0, 507}}, new int[][]{{0, 990, 15, 3, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 412, 13, 0, 0, 0, 0, 0, 0, 0, 0, 1641}, {0, 18, 7, 1, 0, 0, 0, 0, 0, 0, 0, 30}}}, new int[][][]{new int[][]{{953, 24519, 628, 120, 28, 12, 4, 0, 0, 0, 0, 2248798}, {1525, 25654, 2647, 617, 239, 143, 42, 5, 0, 0, 0, 66837}, {1180, 11011, 3001, 1237, 532, 448, 239, 54, 5, 0, 0, 7122}}, new int[][]{{1356, 2220, 67, 10, 4, 1, 0, 0, 0, 0, 0, 0}, {1450, 2544, 102, 18, 4, 3, 0, 0, 0, 0, 0, 57063}, {1182, 2110, 470, 130, 41, 21, 0, 0, 0, 0, 0, 6047}}, new int[][]{{370, 3378, 200, 30, 5, 4, 1, 0, 0, 0, 0, 0}, {293, 1006, 131, 29, 11, 0, 0, 0, 0, 0, 0, 5404}, {114, 387, 98, 23, 4, 8, 1, 0, 0, 0, 0, 236}}, new int[][]{{579, 194, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {395, 213, 5, 1, 0, 0, 0, 0, 0, 0, 0, 4157}, {119, 122, 4, 0, 0, 0, 0, 0, 0, 0, 0, 300}}, new int[][]{{38, 557, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {21, 114, 12, 1, 0, 0, 0, 0, 0, 0, 0, 427}, {0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7}}, new int[][]{{52, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {18, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 652}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30}}, new int[][]{{640, 569, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {25, 77, 2, 0, 0, 0, 0, 0, 0, 0, 0, 517}, {4, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3}}, new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}}, new int[][][]{new int[][]{{2506, 20161, 2707, 767, 261, 178, 107, 30, 14, 3, 0, 100694}, {8806, 36478, 8817, 3268, 1280, 850, 401, 114, 42, 0, 0, 58572}, {11003, 27214, 11798, 5716, 2482, 2072, 1048, 175, 32, 0, 0, 19284}}, new int[][]{{9738, 11313, 959, 205, 70, 18, 11, 1, 0, 0, 0, 0}, {12628, 15085, 1507, 273, 52, 19, 9, 0, 0, 0, 0, 54280}, {10701, 15846, 5561, 1926, 813, 570, 249, 36, 0, 0, 0, 6460}}, new int[][]{{6781, 22539, 2784, 634, 182, 123, 20, 4, 0, 0, 0, 0}, {6263, 11544, 2649, 790, 259, 168, 27, 5, 0, 0, 0, 20539}, {3109, 4075, 2031, 896, 457, 386, 158, 29, 0, 0, 0, 1138}}, new int[][]{{11515, 4079, 465, 73, 5, 14, 2, 0, 0, 0, 0, 0}, {9361, 5834, 650, 96, 24, 8, 4, 0, 0, 0, 0, 22181}, {4343, 3974, 1360, 415, 132, 96, 14, 1, 0, 0, 0, 1267}}, new int[][]{{4787, 9297, 823, 168, 44, 12, 4, 0, 0, 0, 0, 0}, {3619, 4472, 719, 198, 60, 31, 3, 0, 0, 0, 0, 8401}, {1157, 1175, 483, 182, 88, 31, 8, 0, 0, 0, 0, 268}}, new int[][]{{8299, 1226, 32, 5, 1, 0, 0, 0, 0, 0, 0, 0}, {3502, 1568, 57, 4, 1, 1, 0, 0, 0, 0, 0, 9811}, {1055, 1070, 166, 29, 6, 1, 0, 0, 0, 0, 0, 527}}, new int[][]{{27414, 27927, 1989, 347, 69, 26, 0, 0, 0, 0, 0, 0}, {5876, 10074, 1574, 341, 91, 24, 4, 0, 0, 0, 0, 21954}, {1571, 2171, 778, 324, 124, 65, 16, 0, 0, 0, 0, 979}}, new int[][]{{0, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 459}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13}}}};
    static final Token[] vp8_coef_encodings = new Token[TokenAlphabet.entropyTokenCount];

    private BitStream() {
    }

    static void kfwrite_ymode(BitEncoder bc, MBPredictionMode m) {
        TreeWriter.vp8_write_token(bc, EntropyMode.vp8_kf_ymode_tree, EntropyMode.vp8_kf_ymode_prob, Token.vp8_kf_ymode_encodings[m.ordinal()]);
    }

    static void write_uv_mode(BitEncoder bc, MBPredictionMode m) {
        TreeWriter.vp8_write_token(bc, EntropyMode.vp8_uv_mode_tree, EntropyMode.vp8_kf_uv_mode_prob, Token.vp8_uv_mode_encodings[m.ordinal()]);
    }

    static void write_bmode(BitEncoder bc, int m, GetPointer p) {
        TreeWriter.vp8_write_token(bc, EntropyMode.vp8_bmode_tree, p, Token.vp8_bmode_encodings[m]);
    }

    private static void encodeTokenPartShort(BitEncoder w, int v, int n, int i, short[] probs, short[] tree) {
        do {
            int bb;
            w.vp8_encode_bool((bb = v >> --n & 1) != 0, probs[i >> 1]);
            i = tree[i + bb];
        } while (n != 0);
    }

    static void vp8_pack_tokens(BitEncoder w, TokenList p) {
        FullGenArrPointer<TokenExtra> curr = p.start.shallowCopy();
        while (!curr.equals(p.stop)) {
            int i;
            int n;
            TokenExtra text = curr.get();
            TokenAlphabet t = text.Token;
            if (text.skip_eob_node) {
                n = t.coefEncodingLen - 1;
                i = 2;
            } else {
                n = t.coefEncodingLen;
                i = 0;
            }
            BitStream.encodeTokenPartShort(w, t.coefEncodingValue, n, i, text.context_tree, Entropy.vp8_coef_tree_shorts);
            if (t.base_val != 0) {
                int e = text.Extra;
                int L = t.len;
                if (L != 0) {
                    BitStream.encodeTokenPartShort(w, e >> 1, L, 0, t.prob, t.tree);
                }
                w.vp8_encode_extra(e);
            }
            curr.inc();
        }
    }

    static void write_partition_size(FullGetSetPointer cx_data, int size) {
        cx_data.set((short)(size & 0xFF));
        cx_data.setRel(1, (short)(size >> 8 & 0xFF));
        cx_data.setRel(2, (short)(size >> 16 & 0xFF));
    }

    static void pack_tokens_into_partitions(Compressor cpi, FullGetSetPointer cx_data, GetPointer end, int num_part) {
        int mb_row;
        int i;
        for (i = 0; i < num_part; ++i) {
            BitEncoder w = cpi.bc[i + 1];
            w.vp8_start_encode(cx_data, end);
            for (mb_row = i; mb_row < cpi.common.mb_rows; mb_row += num_part) {
                BitStream.vp8_pack_tokens(w, cpi.tplist[mb_row]);
            }
            w.vp8_stop_encode();
            cx_data.incBy(w.getPos());
        }
        for (i = 0; i < num_part; ++i) {
            for (mb_row = i; mb_row < cpi.common.mb_rows; mb_row += num_part) {
                cpi.tplist[mb_row].start.arr.clear();
                cpi.tplist[mb_row].stop.arr.clear();
            }
        }
    }

    static void write_mb_features(BitEncoder w, MBModeInfo mi, MacroblockD x) {
        if (x.segmentation_enabled != 0 && x.update_mb_segmentation_map) {
            switch (mi.segment_id) {
                case 1: {
                    w.vp8_encode_bool(false, x.mb_segment_tree_probs[0]);
                    w.vp8_encode_bool(true, x.mb_segment_tree_probs[1]);
                    break;
                }
                case 2: {
                    w.vp8_encode_bool(true, x.mb_segment_tree_probs[0]);
                    w.vp8_encode_bool(false, x.mb_segment_tree_probs[2]);
                    break;
                }
                case 3: {
                    w.vp8_encode_bool(true, x.mb_segment_tree_probs[0]);
                    w.vp8_encode_bool(true, x.mb_segment_tree_probs[2]);
                    break;
                }
                default: {
                    w.vp8_encode_bool(false, x.mb_segment_tree_probs[0]);
                    w.vp8_encode_bool(false, x.mb_segment_tree_probs[1]);
                }
            }
        }
    }

    static void vp8_convert_rfct_to_prob(Compressor cpi) {
        cpi.vp8_convert_rfct_to_prob();
    }

    static void write_kfmodes(Compressor cpi) {
        BitEncoder bc = cpi.bc[0];
        CommonData c = cpi.common;
        FullGenArrPointer<ModeInfo> m = c.mi;
        int mPos = c.mi.getPos();
        int mb_row = -1;
        int prob_skip_false = 0;
        if (c.mb_no_coeff_skip) {
            int total_mbs = c.mb_rows * c.mb_cols;
            prob_skip_false = (total_mbs - cpi.mb.skip_true_count) * 256 / total_mbs;
            if (prob_skip_false <= 1) {
                prob_skip_false = 1;
            }
            if (prob_skip_false >= 255) {
                prob_skip_false = 255;
            }
            cpi.prob_skip_false = prob_skip_false;
            TreeWriter.vp8_write_literal(bc, prob_skip_false, 8);
        }
        while (++mb_row < c.mb_rows) {
            int mb_col = -1;
            while (++mb_col < c.mb_cols) {
                MBPredictionMode ym = m.get().mbmi.mode;
                if (cpi.mb.e_mbd.update_mb_segmentation_map) {
                    BitStream.write_mb_features(bc, m.get().mbmi, cpi.mb.e_mbd);
                }
                if (c.mb_no_coeff_skip) {
                    bc.vp8_encode_bool(m.get().mbmi.mb_skip_coeff, prob_skip_false);
                }
                BitStream.kfwrite_ymode(bc, ym);
                if (ym == MBPredictionMode.B_PRED) {
                    int mis = c.mode_info_stride;
                    int i = 0;
                    do {
                        int A = FindNearMV.above_block_mode(m, i, mis);
                        int L = FindNearMV.left_block_mode(m, i);
                        int bm = m.get().bmi[i].as_mode();
                        BitStream.write_bmode(bc, bm, new GetPointer(VP8Util.SubblockKeys.keyFrameSubblockModeProb[A][L], 0));
                    } while (++i < 16);
                }
                BitStream.write_uv_mode(bc, m.getAndInc().mbmi.uv_mode);
            }
            m.inc();
        }
        m.setPos(mPos);
    }

    static void sum_probs_over_prev_coef_context(int[][] probs, int[] out) {
        for (int i = 0; i < TokenAlphabet.entropyTokenCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                int tmp = out[i];
                int n = i;
                out[n] = out[n] + probs[j][i];
                if (out[i] >= tmp) continue;
                out[i] = Integer.MAX_VALUE;
            }
        }
    }

    static int prob_update_savings(int[] ct, int oldp, int newp, int upd) {
        int old_b = TreeWriter.vp8_cost_branch(ct, oldp);
        int new_b = TreeWriter.vp8_cost_branch(ct, newp);
        int update_b = 8 + (TreeWriter.vp8_cost_one(upd) - TreeWriter.vp8_cost_zero(upd) >> 8);
        return old_b - new_b - update_b;
    }

    static int independent_coef_context_savings(Compressor cpi) {
        Macroblock x = cpi.mb;
        int savings = 0;
        int i = 0;
        int[] prev_coef_count_sum = new int[TokenAlphabet.entropyTokenCount];
        int[] prev_coef_savings = new int[TokenAlphabet.entropyTokenCount];
        do {
            int j = 0;
            do {
                int k = 0;
                CUtils.vp8_zero(prev_coef_savings);
                CUtils.vp8_zero(prev_coef_count_sum);
                int[][] probs = x.coef_counts[i][j];
                if (cpi.common.frame_type == 0) {
                    probs = default_coef_counts[i][j];
                }
                BitStream.sum_probs_over_prev_coef_context(probs, prev_coef_count_sum);
                do {
                    int t = 0;
                    BitStream.vp8_tree_probs_from_distribution(cpi.frame_coef_probs[i][j][k], cpi.frame_branch_ct[i][j][k], prev_coef_count_sum);
                    do {
                        int[] ct = cpi.frame_branch_ct[i][j][k][t];
                        short newp = cpi.frame_coef_probs[i][j][k][t];
                        short oldp = cpi.common.fc.coef_probs[i][j][k][t];
                        int upd = VP_8_COEF_UPDATE_PROBS[i][j][k][t];
                        int s = BitStream.prob_update_savings(ct, oldp, newp, upd);
                        if (cpi.common.frame_type == 0 && newp == oldp) continue;
                        int n = t;
                        prev_coef_savings[n] = prev_coef_savings[n] + s;
                    } while (++t < 11);
                } while (++k < 3);
                k = 0;
                do {
                    if (prev_coef_savings[k] <= 0 && cpi.common.frame_type != 0) continue;
                    savings += prev_coef_savings[k];
                } while (++k < 11);
            } while (++j < 8);
        } while (++i < 4);
        return savings;
    }

    static int default_coef_context_savings(Compressor cpi) {
        Macroblock x = cpi.mb;
        int savings = 0;
        int i = 0;
        do {
            int j = 0;
            do {
                int k = 0;
                do {
                    int t = 0;
                    BitStream.vp8_tree_probs_from_distribution(cpi.frame_coef_probs[i][j][k], cpi.frame_branch_ct[i][j][k], x.coef_counts[i][j][k]);
                    do {
                        int upd;
                        short newp;
                        short oldp;
                        int[] ct;
                        int s;
                        if ((s = BitStream.prob_update_savings(ct = cpi.frame_branch_ct[i][j][k][t], oldp = cpi.common.fc.coef_probs[i][j][k][t], newp = cpi.frame_coef_probs[i][j][k][t], upd = VP_8_COEF_UPDATE_PROBS[i][j][k][t])) <= 0) continue;
                        savings += s;
                    } while (++t < 11);
                } while (++k < 3);
            } while (++j < 8);
        } while (++i < 4);
        return savings;
    }

    static void vp8_calc_ref_frame_costs(int[] ref_frame_cost, int prob_intra, int prob_last, int prob_garf) {
        ref_frame_cost[MVReferenceFrame.INTRA_FRAME.ordinal()] = TreeWriter.vp8_cost_zero(prob_intra);
        ref_frame_cost[MVReferenceFrame.LAST_FRAME.ordinal()] = TreeWriter.vp8_cost_one(prob_intra) + TreeWriter.vp8_cost_zero(prob_last);
        ref_frame_cost[MVReferenceFrame.GOLDEN_FRAME.ordinal()] = TreeWriter.vp8_cost_one(prob_intra) + TreeWriter.vp8_cost_one(prob_last) + TreeWriter.vp8_cost_zero(prob_garf);
        ref_frame_cost[MVReferenceFrame.ALTREF_FRAME.ordinal()] = TreeWriter.vp8_cost_one(prob_intra) + TreeWriter.vp8_cost_one(prob_last) + TreeWriter.vp8_cost_one(prob_garf);
    }

    static int vp8_estimate_entropy_savings(Compressor cpi) {
        int savings = 0;
        ReferenceCounts rf = cpi.mb.sumReferenceCounts();
        EnumMap<MVReferenceFrame, Integer> rfct = cpi.mb.count_mb_ref_frame_usage;
        int[] refFrameCost = new int[MVReferenceFrame.count];
        if (cpi.common.frame_type != 0) {
            int new_intra = rf.intra * 255 / (rf.intra + rf.inter);
            if (new_intra == 0) {
                new_intra = 1;
            }
            int new_last = rf.inter != 0 ? rfct.get((Object)MVReferenceFrame.LAST_FRAME) * 255 / rf.inter : 128;
            int new_garf = rfct.get((Object)MVReferenceFrame.GOLDEN_FRAME) + rfct.get((Object)MVReferenceFrame.ALTREF_FRAME) != 0 ? rfct.get((Object)MVReferenceFrame.GOLDEN_FRAME) * 255 / (rfct.get((Object)MVReferenceFrame.GOLDEN_FRAME) + rfct.get((Object)MVReferenceFrame.ALTREF_FRAME)) : 128;
            BitStream.vp8_calc_ref_frame_costs(refFrameCost, new_intra, new_last, new_garf);
            int newTotal = rfct.get((Object)MVReferenceFrame.INTRA_FRAME) * refFrameCost[MVReferenceFrame.INTRA_FRAME.ordinal()] + rfct.get((Object)MVReferenceFrame.LAST_FRAME) * refFrameCost[MVReferenceFrame.LAST_FRAME.ordinal()] + rfct.get((Object)MVReferenceFrame.GOLDEN_FRAME) * refFrameCost[MVReferenceFrame.GOLDEN_FRAME.ordinal()] + rfct.get((Object)MVReferenceFrame.ALTREF_FRAME) * refFrameCost[MVReferenceFrame.ALTREF_FRAME.ordinal()];
            BitStream.vp8_calc_ref_frame_costs(refFrameCost, cpi.prob_intra_coded, cpi.prob_last_coded, cpi.prob_gf_coded);
            int oldtotal = rfct.get((Object)MVReferenceFrame.INTRA_FRAME) * refFrameCost[MVReferenceFrame.INTRA_FRAME.ordinal()] + rfct.get((Object)MVReferenceFrame.LAST_FRAME) * refFrameCost[MVReferenceFrame.LAST_FRAME.ordinal()] + rfct.get((Object)MVReferenceFrame.GOLDEN_FRAME) * refFrameCost[MVReferenceFrame.GOLDEN_FRAME.ordinal()] + rfct.get((Object)MVReferenceFrame.ALTREF_FRAME) * refFrameCost[MVReferenceFrame.ALTREF_FRAME.ordinal()];
            savings += (oldtotal - newTotal) / 256;
        }
        savings = cpi.oxcf.error_resilient_mode ? (savings += BitStream.independent_coef_context_savings(cpi)) : (savings += BitStream.default_coef_context_savings(cpi));
        return savings;
    }

    static void vp8UpdateCoefProbs(Compressor cpi) {
        int i = 0;
        BitEncoder w = cpi.bc[0];
        int[] prev_coef_savings = new int[11];
        do {
            int j = 0;
            do {
                int t;
                int k = 0;
                CUtils.vp8_zero(prev_coef_savings);
                if (cpi.oxcf.error_resilient_mode) {
                    for (k = 0; k < 3; ++k) {
                        t = 0;
                        while (t < 11) {
                            int[] ct = cpi.frame_branch_ct[i][j][k][t];
                            short newp = cpi.frame_coef_probs[i][j][k][t];
                            short oldp = cpi.common.fc.coef_probs[i][j][k][t];
                            int upd = VP_8_COEF_UPDATE_PROBS[i][j][k][t];
                            int n = t++;
                            prev_coef_savings[n] = prev_coef_savings[n] + BitStream.prob_update_savings(ct, oldp, newp, upd);
                        }
                    }
                    k = 0;
                }
                do {
                    t = 0;
                    do {
                        short newp = cpi.frame_coef_probs[i][j][k][t];
                        short Pold = cpi.common.fc.coef_probs[i][j][k][t];
                        int upd = VP_8_COEF_UPDATE_PROBS[i][j][k][t];
                        int s = prev_coef_savings[t];
                        boolean u = false;
                        if (!cpi.oxcf.error_resilient_mode) {
                            s = BitStream.prob_update_savings(cpi.frame_branch_ct[i][j][k][t], Pold, newp, upd);
                        }
                        if (s > 0) {
                            u = true;
                        }
                        if (cpi.oxcf.error_resilient_mode && cpi.common.frame_type == 0 && newp != Pold) {
                            u = true;
                        }
                        w.vp8_encode_bool(u, upd);
                        if (!u) continue;
                        cpi.common.fc.coef_probs[i][j][k][t] = newp;
                        TreeWriter.vp8_write_literal(w, newp, 8);
                    } while (++t < 11);
                } while (++k < 3);
            } while (++j < 8);
        } while (++i < 4);
    }

    static void put_delta_q(BitEncoder bc, int delta_q) {
        if (delta_q != 0) {
            bc.vp8_write_bit(true);
            TreeWriter.vp8_write_literal(bc, Math.abs(delta_q), 4);
            bc.vp8_write_bit(delta_q < 0);
        } else {
            bc.vp8_write_bit(false);
        }
    }

    static int vp8_pack_bitstream(Compressor cpi, FullGetSetPointer dest, GetPointer dest_end) {
        int size;
        Header oh = new Header();
        CommonData pc = cpi.common;
        BitEncoder[] bc = cpi.bc;
        MacroblockD xd = cpi.mb.e_mbd;
        int extra_bytes_packed = 0;
        FullGetSetPointer cx_data = dest.shallowCopy();
        boolean mbfeaturedatabitsIdx = false;
        oh.show_frame = pc.show_frame;
        oh.type = pc.frame_type;
        oh.version = pc.getVersion();
        oh.first_partition_length_in_bytes = 0;
        BitEncoder.validate_buffer(cx_data, 3, dest_end);
        cx_data.incBy(3);
        if (oh.type == 0) {
            BitEncoder.validate_buffer(cx_data, 7, dest_end);
            cx_data.setAndInc((short)157);
            cx_data.setAndInc((short)1);
            cx_data.setAndInc((short)42);
            int v = CommonData.horiz_scale.ordinal() << 14 | pc.Width;
            cx_data.setAndInc((short)(v & 0xFF));
            cx_data.setAndInc((short)(v >> 8));
            v = CommonData.vert_scale.ordinal() << 14 | pc.Height;
            cx_data.setAndInc((short)(v & 0xFF));
            cx_data.setAndInc((short)(v >> 8));
            extra_bytes_packed = 7;
            bc[0].vp8_start_encode(cx_data, dest_end);
            bc[0].vp8_write_bit(false);
            bc[0].vp8_write_bit(false);
        } else {
            bc[0].vp8_start_encode(cx_data, dest_end);
        }
        bc[0].vp8_write_bit(xd.segmentation_enabled != 0);
        if (xd.segmentation_enabled != 0) {
            BitStream.compressSegmentEnabled(xd, bc, 0);
        }
        bc[0].vp8_write_bit(pc.filter_type == LoopFilterType.SIMPLE);
        TreeWriter.vp8_write_literal(bc[0], pc.filter_level, 6);
        TreeWriter.vp8_write_literal(bc[0], pc.sharpness_level, 3);
        bc[0].vp8_write_bit(xd.mode_ref_lf_delta_enabled);
        if (xd.mode_ref_lf_delta_enabled) {
            BitStream.compressDeltaEnabled(cpi, xd, bc);
        }
        TreeWriter.vp8_write_literal(bc[0], pc.multi_token_partition.ordinal(), 2);
        TreeWriter.vp8_write_literal(bc[0], pc.base_qindex, 7);
        BitStream.put_delta_q(bc[0], pc.delta_q.get((Object)CommonData.Quant.Y1).get((Object)CommonData.Comp.DC).shortValue());
        BitStream.put_delta_q(bc[0], pc.delta_q.get((Object)CommonData.Quant.Y2).get((Object)CommonData.Comp.DC).shortValue());
        BitStream.put_delta_q(bc[0], pc.delta_q.get((Object)CommonData.Quant.Y2).get((Object)CommonData.Comp.AC).shortValue());
        BitStream.put_delta_q(bc[0], pc.delta_q.get((Object)CommonData.Quant.UV).get((Object)CommonData.Comp.DC).shortValue());
        BitStream.put_delta_q(bc[0], pc.delta_q.get((Object)CommonData.Quant.UV).get((Object)CommonData.Comp.AC).shortValue());
        if (pc.frame_type != 0) {
            bc[0].vp8_write_bit(pc.refresh_golden_frame);
            bc[0].vp8_write_bit(pc.refresh_alt_ref_frame);
            if (!pc.refresh_golden_frame) {
                TreeWriter.vp8_write_literal(bc[0], pc.copy_buffer_to_gf, 2);
            }
            if (!pc.refresh_alt_ref_frame) {
                TreeWriter.vp8_write_literal(bc[0], pc.copy_buffer_to_arf, 2);
            }
            bc[0].vp8_write_bit(pc.ref_frame_sign_bias.get((Object)MVReferenceFrame.GOLDEN_FRAME));
            bc[0].vp8_write_bit(pc.ref_frame_sign_bias.get((Object)MVReferenceFrame.ALTREF_FRAME));
        }
        if (cpi.oxcf.error_resilient_mode) {
            pc.refresh_entropy_probs = pc.frame_type == 0;
        }
        bc[0].vp8_write_bit(pc.refresh_entropy_probs);
        if (pc.frame_type != 0) {
            bc[0].vp8_write_bit(pc.refresh_last_frame);
        }
        if (!pc.refresh_entropy_probs) {
            cpi.common.lfc = new FrameContext(cpi.common.fc);
        }
        BitStream.vp8UpdateCoefProbs(cpi);
        bc[0].vp8_write_bit(pc.mb_no_coeff_skip);
        if (pc.frame_type == 0) {
            BitStream.write_kfmodes(cpi);
        } else {
            LogWriter.writeLog("should not be called");
        }
        bc[0].vp8_stop_encode();
        cx_data.incBy(bc[0].getPos());
        oh.first_partition_length_in_bytes = cpi.bc[0].getPos();
        short[] ohAsbytes = oh.asThreeBytes();
        dest.memcopyin(0, ohAsbytes, 0, ohAsbytes.length);
        cpi.partition_sz[0] = size = 3 + extra_bytes_packed + cpi.bc[0].getPos();
        if (pc.multi_token_partition != TokenPartition.ONE_PARTITION) {
            int i;
            int num_part = 1 << pc.multi_token_partition.ordinal();
            cpi.partition_sz[0] = cpi.partition_sz[0] + (size += 3 * (num_part - 1));
            BitEncoder.validate_buffer(cx_data, 3 * (num_part - 1), dest_end);
            BitStream.pack_tokens_into_partitions(cpi, cx_data.shallowCopyWithPosInc(3 * (num_part - 1)), dest_end, num_part);
            for (i = 1; i < num_part; ++i) {
                cpi.partition_sz[i] = cpi.bc[i].getPos();
                BitStream.write_partition_size(cx_data, cpi.partition_sz[i]);
                cx_data.incBy(3);
                size += cpi.partition_sz[i];
            }
            cpi.partition_sz[i] = cpi.bc[i].getPos();
            size += cpi.partition_sz[i];
        } else {
            cpi.bc[1].vp8_start_encode(cx_data, dest_end);
            TokenList tlist = new TokenList();
            tlist.start = cpi.tok;
            tlist.stop = cpi.tok.shallowCopyWithPosInc(cpi.tok_count);
            BitStream.vp8_pack_tokens(cpi.bc[1], tlist);
            cpi.bc[1].vp8_stop_encode();
            cpi.partition_sz[1] = size += cpi.bc[1].getPos();
        }
        return size;
    }

    private static void compressSegmentEnabled(MacroblockD xd, BitEncoder[] bc, int mbfeaturedatabitsIdx) {
        int Data;
        int i;
        bc[0].vp8_write_bit(xd.update_mb_segmentation_map);
        bc[0].vp8_write_bit(xd.update_mb_segmentation_data);
        if (xd.update_mb_segmentation_data) {
            bc[0].vp8_write_bit(xd.mb_segement_abs_delta);
            for (i = 0; i < MBLvlFeatures.featureCount; ++i) {
                for (int j = 0; j < 4; ++j) {
                    Data = xd.segment_feature_data[i][j];
                    if (Data != 0) {
                        bc[0].vp8_write_bit(true);
                        if (Data < 0) {
                            Data = -Data;
                            TreeWriter.vp8_write_literal(bc[0], Data, Entropy.vp8_mb_feature_data_bits[mbfeaturedatabitsIdx + i]);
                            bc[0].vp8_write_bit(true);
                            continue;
                        }
                        TreeWriter.vp8_write_literal(bc[0], Data, Entropy.vp8_mb_feature_data_bits[mbfeaturedatabitsIdx + i]);
                        bc[0].vp8_write_bit(false);
                        continue;
                    }
                    bc[0].vp8_write_bit(false);
                }
            }
        }
        if (xd.update_mb_segmentation_map) {
            for (i = 0; i < 3; ++i) {
                Data = xd.mb_segment_tree_probs[i];
                if (Data != 255) {
                    bc[0].vp8_write_bit(true);
                    TreeWriter.vp8_write_literal(bc[0], Data, 8);
                    continue;
                }
                bc[0].vp8_write_bit(false);
            }
        }
    }

    private static void compressDeltaEnabled(Compressor cpi, MacroblockD xd, BitEncoder[] bc) {
        boolean send_update = xd.mode_ref_lf_delta_update || cpi.oxcf.error_resilient_mode;
        bc[0].vp8_write_bit(send_update);
        if (send_update) {
            byte[][] updater = new byte[][]{xd.ref_lf_deltas, xd.mode_lf_deltas};
            byte[][] lastUpd = new byte[][]{xd.last_ref_lf_deltas, xd.last_mode_lf_deltas};
            for (int k = 0; k < updater.length; ++k) {
                for (int i = 0; i < 4; ++i) {
                    byte Data = updater[k][i];
                    if (Data != lastUpd[k][i] || cpi.oxcf.error_resilient_mode) {
                        lastUpd[k][i] = updater[k][i];
                        bc[0].vp8_write_bit(true);
                        boolean sign = false;
                        if (Data < 0) {
                            Data = -Data;
                            sign = true;
                        }
                        TreeWriter.vp8_write_literal(bc[0], Data & 0x3F, 6);
                        bc[0].vp8_write_bit(sign);
                        continue;
                    }
                    bc[0].vp8_write_bit(false);
                }
            }
        }
    }

    static void vp8_tree_probs_from_distribution(short[] probs, int[][] branch_ct, int[] num_events) {
        int tree_len = TokenAlphabet.entropyTokenCount - 1;
        int t = 0;
        BitStream.branch_counts(TokenAlphabet.entropyTokenCount, vp8_coef_encodings, Entropy.vp8_coef_tree, branch_ct, num_events);
        do {
            int[] c;
            int tot;
            if ((tot = (c = branch_ct[t])[0] + c[1]) != 0) {
                short p = (short)(((long)c[0] * 256L + (long)(tot >> 1)) / (long)tot);
                probs[t] = CUtils.clamp(p, (short)1, (short)255);
                continue;
            }
            probs[t] = 128;
        } while (++t < tree_len);
    }

    static void branch_counts(int n, Token[] tok, GetPointer tree, int[][] branch_ct, int[] num_events) {
        int tree_len = n - 1;
        int t = 0;
        do {
            branch_ct[t][1] = 0;
            branch_ct[t][0] = 0;
        } while (++t < tree_len);
        t = 0;
        do {
            int b;
            int L = tok[t].len;
            int enc = tok[t].value;
            int ct = num_events[t];
            int i = 0;
            do {
                b = enc >> --L & 1;
                int j = i >> 1;
                assert (j < tree_len && 0 <= L);
                int[] nArray = branch_ct[j];
                int n2 = b;
                nArray[n2] = nArray[n2] + ct;
            } while ((i = (int)tree.getRel(i + b)) > 0);
            assert (L == 0);
        } while (++t < n);
    }

    static {
        int i = 0;
        for (TokenAlphabet ta : TokenAlphabet.values()) {
            BitStream.vp8_coef_encodings[i++] = new Token(ta.coefEncodingValue, ta.coefEncodingLen);
        }
    }
}

