/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.util.ImageUtils;
import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import com.idrsolutions.image.webp.data.EVP8;
import com.idrsolutions.image.webp.data.EVP8L;
import com.idrsolutions.image.webp.enc.VP8Encoder;
import com.idrsolutions.image.webp.options.WebpCompressionFormat;
import com.idrsolutions.image.webp.options.WebpEncoderOptions;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WebpEncoder
extends JDeliImage
implements Encoder {
    private WebpEncoderOptions webpEncoderOptions = new WebpEncoderOptions();

    public WebpEncoder(EncoderOptions format) {
        if (format != null) {
            this.webpEncoderOptions = (WebpEncoderOptions)format;
        }
    }

    public WebpEncoder() {
    }

    public void write(BufferedImage image, File file) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        this.write(image, bos);
        bos.flush();
        bos.close();
    }

    @Override
    public void write(BufferedImage inputImage, OutputStream os) throws IOException {
        WebpEncoder.optimiseImage(inputImage);
        WebpCompressionFormat webpCompression = this.webpEncoderOptions.getCompressionFormat();
        if (webpCompression == WebpCompressionFormat.LOSSLESS || WebpEncoder.hasAlpha(inputImage)) {
            EVP8L.encode(inputImage, os);
        } else if (webpCompression == WebpCompressionFormat.LOSSY) {
            BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(inputImage);
            int qp = 100 - this.webpEncoderOptions.getQuality();
            if (imageToCompress.getHeight() < 5000 && imageToCompress.getWidth() < 5000) {
                VP8Encoder.encodeWEBP(imageToCompress, os, qp);
            } else {
                EVP8.encode(imageToCompress, os, qp);
            }
        }
    }

    @Override
    public WebpEncoderOptions getEncoderOptions() {
        return this.webpEncoderOptions;
    }

    private static boolean hasAlpha(BufferedImage image) {
        int type = image.getType();
        if (type == 2 || type == 6) {
            PixGet pg = Access.getPixGet(image);
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int v = pg.getARGB(x, y) >>> 24;
                    if (v == 255) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

